/*

f-cpu/qdcpoc2/init.c
created Mon Jul 30 00:52:16 2001 by whygee@f-cpu.org
version Sun Aug  5 04:39:04 2001 : switching to QDCPOC2

This file is included by f-cpu/qdcpoc2/main.c
which includes all the necessary stuffs.

Beware ! don't do what is written here at home !
Don't let children look, or they'll be scared to death !

(C) YG all rights reserved. you're warned !!!
read f-cpu/qdcpoc/about.txt for the details.


 about this file :

This file initializes all the structures before
the simulator can be run. The fetcher buffer
and all (not yet) the internal signals are set
to a stable state.

Another more interesting part is the creation of
the opcode lookup table. It defines and generates
the latency of the input instruction in function
of the opcode and the necessary flags. It also drives
some signals that are sent directly to the SQ or
the Xbar.

Making a flexible array of constants is not easy
because it will be changed often and must be easily synthesised.
The choice here is to generate the array with a loop.
A switch() would not be "clean" and it translates to a lookup
table anyway in the end.
When translated to VHDL, the LUT construction method
is still valid because it can be done during the simulation setup
(at "elaboration" time).

Of course, everything here is preliminary.
It's a very first written version that will be refined
progressively and will eventually work...

 */

void init_fc0() {


  BIST_R7(); /* initialise and reset the registers */


#ifdef otherssssss

This part is currently out of order.
it is not yet necessary (no need of this function)
and variables names are often created and updated.



  /* Xbar */
  Xbar_write_address0 = 0;
  Xbar_write_address1 = 0;
  Xbar_read_address0 = 0;
  Xbar_read_address1 = 0;
  Xbar_read_address2 = 0;
  Xbar_ROP2_port = 0;
  Xbar_ASU_port0 = 0;
  Xbar_ASU_port1 = 0;
  Xbar_read_port0 = 0;
  Xbar_read_port1 = 0;
  Xbar_read_port2 = 0;

  EU_ROP2 = 0;
  ROP2_function_bit0 = 0;
  ROP2_function_bit1 = 0;
  ROP2_function_bit2 = 0;
  ROP2_function_bit3 = 0;
  ROP2_function = 0;
  ROP2_mode = 0;

  FETCH_NIP = 0;
  FETCH_NIP = 0;
  DEC_imm_port = 0;
  DEC_CIP = 0;
  DEC_NIP = 0;
  emit_instruction = 0;
  current_opcode = 0;
  instruction_buffer = 0;
  get_next_instruction = 1; /* start the pipeline */

/* scoreboard = 0; */
  memset(sched_FIFO,0,sizeof(sched_FIFO));
  register0_ready = 0;
  register1_ready = 0;
  register2_ready = 0;
  pointer_ready = 0; /* unused */
  condition_true = 0;
  RW2_ready = 0;
  RW2 = 0;

  /* warning ! not complete ... */

#endif
}


/* look at qdcpoc2.h for the declaration of the used structures */
void elaborate_opcode_LUT() {
  int i;
  opcode_lookup_type k,l;
  memset(&k,0,sizeof(k));

  /* flush all the bits : */
  memset(opcode_LUT,0,sizeof(opcode_LUT));

  /* NOP */
  opcode_LUT[OP_NOP].latency_zero=1; /* do nothing */

  /* ROP2 */
  l = k;
  l.latency_cycle_1 = 1;
  l.need_src0 = 1;
  l.need_src1 = 1;
  l.need_w1 = 1;
  /* problem : MUX needs src2+rw2 : this
     is currently managed at decode stage. */
  for (i=OP_ROP2; i<(OP_ROP2+8); i++) {
    opcode_LUT[i]=l;
  }

  /* ROP2I */
  l = k;
  l.latency_cycle_1 = 1;
  l.op_imm8 = 1;
  l.need_src1 = 1;
  l.need_w1 = 1;
  for (i=OP_ROP2I; i<(OP_ROP2I+8); i++) {
    opcode_LUT[i]=l;
  }

  /* (C)MOVE */
  l = k;
  l.latency_direct = 1;
  l.need_src0 = 1;
  l.need_src1 = 1;
  l.need_src2 = 1;
  l.need_w1   = 1;
  l.need_cond = 1;
  opcode_LUT[OP_MOV]=l;

  /* LOADCONS(X)   [missing : checking subword verification for back-to-back issue !!!] */
  l = k;
  l.latency_direct = 1;
  l.need_src2 = 1;
  l.need_w1   = 1;
  l.op_imm16  = 1;
  for (i=OP_LOADCONS; i<(OP_LOADCONS+8); i++) {
    opcode_LUT[i]=l;
  }

}


/* initialize the fetcher buffer, its configuration and its contents. */
void init_fetcher(char *fname) {
  FILE *file_in;
  int res;
  struct stat buf;

/* strategy :
   we want to load the whole file in memory.
   we need to stat() the file before malloc().
   then we dump the file to memory.
 */

  res = stat(fname,&buf);
  if (res != 0)
    qdcpoc_error("can't stat() the input file", 1);

  fetcher_buffer_size = buf.st_size;
  if ((fetcher_buffer_size & 3)!=0)
    qdcpoc_error("input file size is not 0 mod 4",2);

  if (fetcher_buffer != NULL)
    free(fetcher_buffer);

  fetcher_buffer = malloc(fetcher_buffer_size);
  if (fetcher_buffer == NULL)
    qdcpoc_error("can't allocate memory for the instructions", 3);

  file_in = fopen(fname,"rb");
  if (fname == NULL)
    qdcpoc_error("can't fopen the input file", 4);

  fread (fetcher_buffer,fetcher_buffer_size,1,file_in);

  FETCH_PIP = 0;

/*  DEC_CIP = 0;
  DEC_NIP = 0;
  FETCH_CIP = 0;
  FETCH_NIP = 4; */

  /* create a current_page of 4KB : */
  FETCH_current_page_size = (1LL << 12) -1;
}
