/*
f-cpu/ygasm/ygasm_labels.c

This is a Free Software created : ven avr 28 21:08:06 CEST 2000 by Yann Guidon
for the PPCM2 hack. this time, i make a binary tree.
maybe next time i'll make a hash table ?

Sun Jul 15 18:06:45 2001 : adaptation for the ygasm F-CPU Assembler.

*/

symbol *root_symbol=NULL, *current_symbol;
int direction, max_tree_depth=0, tree_symbol_count=0;

symbol * symbol_exists (char *name, int size) {
  int i, current_depth=0;;
  current_symbol=root_symbol;

  if (current_symbol==NULL) {
    /* printf("root\n");*/
    return NULL;
  }

loop_symbol:
  current_depth++;
  if (current_depth>max_tree_depth)
    max_tree_depth=current_depth;

  i=current_symbol->size;
  if (size>i)
    i=size;

  direction=memcmp(name,current_symbol->name,i);
  /*  printf("cmp=%s, dir=%d ",current_symbol->name,direction); */

  if (direction==0) {
    /* printf("found.\n");*/
    return current_symbol;
  }

  if (direction<0) {
    if (current_symbol->left==NULL) {
      /* printf("not found, left.\n");*/
      return NULL;
    }
    current_symbol=current_symbol->left;
    goto loop_symbol;
  }
  /* else */
  if (current_symbol->right==NULL) {
    /* printf("not found, right.\n");*/
    return NULL;
  }
  current_symbol=current_symbol->right;

  goto loop_symbol;
}


/* this function is always called after a call
   to symbol_exists() because it sets global variables,
   such as the position in the tree (current_symbol and direction). */
symbol * create_symbol (char *name, int size, int attr) {
  symbol *s=ygasm_malloc(sizeof(struct struct_symbol)+size+1);
             /* don't forget the trailing zero... */

  /* never tested but can become useful one day...
    if (current_symbol == NULL)
      ygasm_error("can't create symbol, because current_symbol is not correctly set.",NULL);
  */

  /* initialize the fields */
  s->size=size;
  memcpy(s->name,name,size); /* trailing zero done by calloc() */
  s->value=0;
  s->attributes=attr;
  s->line=Line_Number;
  s->include_file=include_prec;

  tree_symbol_count++;

  /* link from the other  */
  if (!root_symbol)
    root_symbol=s;
  else {
    if (direction<0)
      current_symbol->left=s;
    else
      current_symbol->right=s;
  }

  return s;
}

/* recursive routine that displays the tree,
   first call with: "examine_tree(root_symbol,0);" 
void examine_tree(symbol * start, int indent) {
  int i;
  if (start->left)
    examine_tree(start->left,indent+1);
  for (i=0;i<indent;i++)
    putchar(' ');
  printf("%s\n",start->name);  
  if (start->right)
    examine_tree(start->right,indent+1);
}*/
