-------------------------------------------------------------------------------
-- test_sram2r3w.vhdl : a testbench for the multiport SRAM block of
-- the F-CPU register set, created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
-- updated Wed Jul  3 00:36:19 CEST 2002 : added the read loop
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
--
--
--
--
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    use IEEE.std_logic_textio.all;
    use std.textio.all;
LIBRARY work;
    USE work.FCPU_config.ALL;
    USE work.sram3r2w;

entity test_sram3r2w is
  -- empty
end test_sram3r2w;


architecture testbench of test_sram3r2w is
  constant test_width : integer := 16;  -- data width in the testbench
  signal AdrRead1, AdrRead2, AdrRead3, AdrWrite1, AdrWrite2 : t_reg := "000000";
  signal DataWrite1, DataWrite2 : std_ulogic_vector(test_width-1 downto 0);
  signal DataRead1, DataRead2, DataRead3 : std_ulogic_vector(test_width-1 downto 0);
  signal clk : std_ulogic := '0';

begin  -- testbench

  sram : entity sram3r2w
    generic map (width => 16)
    port map (
      AdrRead1 => AdrRead1,
      AdrRead2 => AdrRead2,
      AdrRead3 => AdrRead3,
      AdrWrite1 => AdrWrite1,
      AdrWrite2 => AdrWrite2,
      DataWrite1 => DataWrite1,
      DataWrite2 => DataWrite2,
      DataRead1 => DataRead1,
      DataRead2 => DataRead2,
      DataRead3 => DataRead3,
      clk => clk
    );

  test_driver : process
    variable lout : line;
  begin

    for i in 1 to 63 loop
      AdrRead1 <= std_ulogic_vector(to_unsigned(i,6));
      wait for 1 ns;
    end loop;

    
    -- one write cycle :

    AdrWrite1 <= "000101";
    DataWrite1 <= "0110101111010001";
    clk <= '1';
    wait for 1 ns;

    AdrWrite1 <= "000000";
    clk <= '0';
    wait for 1 ns;

    -- one read cycle :

    AdrRead1 <= "000101";
    wait for 1 ns;
    AdrRead1 <= "000000";

    wait; -- the end.
  end process;

  process (DataRead1)
    variable lout : line;
  begin
    write(lout, now);
    write(lout, string'(" Adr1="));
    write(lout, AdrRead1); 
    write(lout, string'("  DataRead1="));
    write(lout, DataRead1);
--    writeline(output, lout);
  end process;

  process (DataRead2)
    variable lout : line;
  begin
    write(lout, now);
    write(lout, string'(" Adr2="));
    write(lout, AdrRead2);
    write(lout, string'(" DataRead2="));
    write(lout, DataRead2);
--    writeline(output, lout);
  end process;

  process (DataRead3)
    variable lout : line;
  begin
    write(lout, now);
    write(lout, string'(" Adr3="));
    write(lout, AdrRead3);
    write(lout, string'(" DataRead3="));
    write(lout, DataRead3);
--    writeline(output, lout);
  end process;

end testbench;
