-- inc.vhdl -- F-CPU Simple Increment Unit
-- Copyright (C) 2000 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: inc.vhdl,v 1.2 2000/10/24 00:39:25 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity Inc is
        generic (
                WIDTH : natural := 64   -- do not change!
        );
        port (
                -- input
                A : in std_ulogic_vector(WIDTH-1 downto 0);
                -- output
                Y : out std_ulogic_vector(WIDTH-1 downto 0)
        );
end Inc;

architecture Arch_1 of Inc is
        signal B, G : std_ulogic_vector(WIDTH-1 downto 0);
        signal C, D : std_ulogic_vector(WIDTH/4-1 downto 0);
        signal E, F : std_ulogic_vector(WIDTH/16-1 downto 0);
begin
        -- d=1
        level1 : for i in 0 to WIDTH/4-1 generate
                B(4*i+0) <= '1';
                B(4*i+1) <= A(4*i+0);
                B(4*i+2) <= A(4*i+0) and A(4*i+1);
                B(4*i+3) <= A(4*i+0) and A(4*i+1) and A(4*i+2);
                C(i)     <= A(4*i+0) and A(4*i+1) and A(4*i+2) and A(4*i+3);
        end generate;
        -- d=2
        level2 : for i in 0 to WIDTH/16-1 generate
                D(4*i+0) <= '1';
                D(4*i+1) <= C(4*i+0);
                D(4*i+2) <= C(4*i+0) and C(4*i+1);
                D(4*i+3) <= C(4*i+0) and C(4*i+1) and C(4*i+2);
                E(i)     <= C(4*i+0) and C(4*i+1) and C(4*i+2) and C(4*i+3);
        end generate;
        -- d=3
        level3 : for i in 0 to WIDTH/64-1 generate
                F(4*i+0) <= '1';
                F(4*i+1) <= E(4*i+0);
                F(4*i+2) <= E(4*i+0) and E(4*i+1);
                F(4*i+3) <= E(4*i+0) and E(4*i+1) and E(4*i+2);
        end generate;
        -- d=4
        level4 : for i in 0 to WIDTH-1 generate
                G(i) <= B(i) and D(i/4) and F(i/16);
        end generate;
        -- d=5
        Y <= A xor G;
end Arch_1;

-- vi: set ts=4 sw=4 : please
