-------------------------------------------------------------------------------
-- sram2r3w_simple.vhdl : a basic behavioural multiport SRAM block for building
-- the F-CPU register set, created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
--
-- version feb 10 00:00:10 GMT 2002 : almost everything is a process and
-- the index problems (when zero, undetermined etc.) are solved.
-- A lot of debugging code is left, but commented out, in case it is useful later.
--
-- version Mon Jun 24 01:20:04 CEST 2002 : adding clk and t_reg, removing debug code.
-- updated Mon Jun 24 06:18:15 CEST 2002 : removing WriteEn !
-- updated Tue Jul  2 23:50:52 CEST 2002 : added the random stuff
-- version Thu Jul  4 05:00:05 CEST 2002 : riviera hicups on rand => renamed.
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- This is a first prototype for this "generic" low-level SRAM block.
-- Another implementation should ideally provided, implementing a SW-generated
-- custom block whenever possible.
--
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.FCPU_config.ALL; -- for t_reg
    USE work.random.all;      -- for the random initialisation
    USE work.sram3r2w;        -- the definition of the interface


architecture prototype of sram3r2w is

  -- describe the register set array :
  subtype RAM_word is std_ulogic_vector(width-1 downto 0);  -- definition of one element
  type RAM_ARRAY_TYPE is array(63 downto 1) of RAM_word;    -- the 63 registers

  -- a function that initialises it to a random value :
  function R7_random return RAM_ARRAY_TYPE
  is
    variable res : RAM_ARRAY_TYPE;
  begin
    for i in 1 to 63 loop
      res(i) := rand_size (width);
    end loop;
    return res;
  end;

  signal RAM_ARRAY : RAM_ARRAY_TYPE := R7_random;            -- the array itself


  -- dirty hack that transforms the register address
  -- into an integer for use in the processes.
  -- it's a modified form of to_integer(t_reg).

  -- when the component is not connected or initialised,
  -- the addresses are "floating" and they trigger index
  -- errors so here we select address 0 by default.

  function sulv_to_int (sulv : t_reg) return reg_number is
    variable i : integer := 0;
    variable j : reg_number := 0;

  begin  -- sulv_to_int

    for i in sulv'high downto sulv'low loop
      j := j*2;
      if sulv(i) = '1' then
        j := j+1;
      else
        if sulv(i) /= '0' then
          return 0;   -- safety net

-- important note : since Us and Xs etc. don't appear in real life, this function
-- does not represent the _real_ behaviour of the bank. Usually, when decoding
-- a "000000", the decoder does nothing (the corresponding address is not wired)

-- There is certainly a better way to do this.

        end if;
      end if;
    end loop;  -- i
    return j;
  end sulv_to_int;
  
begin  -- prototype 

-------------------------------------------------------------------------------
-- asynchronous reads :
-------------------------------------------------------------------------------

  process (AdrRead1)
    variable index : reg_number;
  begin
    index := sulv_to_int(AdrRead1);
    if (index = 0) then
      DataRead1 <= (others => '0');
    else
      DataRead1 <= RAM_ARRAY(index);
    end if;
  end process;

  process (AdrRead2)
    variable index : reg_number;
  begin
    index := sulv_to_int(AdrRead2);
    if (index = 0) then
      DataRead2 <= (others => '0');
    else
      DataRead2 <= RAM_ARRAY(index);
    end if;
  end process;

  process (AdrRead3)
    variable index : reg_number;
  begin
    index := sulv_to_int(AdrRead3);
    if (index = 0) then
      DataRead3 <= (others => '0');
    else
      DataRead3 <= RAM_ARRAY(index);
    end if;
  end process;

-------------------------------------------------------------------------------
-- writes :
-------------------------------------------------------------------------------

  -- both write routines are gathered in this process
  -- to avoid the use of std_logic_vector (resolution problems)
  process
    variable index1, index2 : reg_number;
  begin
    wait until rising_edge(clk);

    index1 := sulv_to_int(AdrWrite1);
    index2 := sulv_to_int(AdrWrite2);

    assert not((index1 /= 0) and (index1 = index2))
      report "WRITE CONTENTION !"
      severity ERROR;

    if (index1 /= 0) then
      RAM_ARRAY(index1) <= DataWrite1;
    end if;

    if (index2 /= 0) then
      RAM_ARRAY(index2) <= DataWrite2;
    end if;
  end process;

end prototype;
