-- eu_sr.vhdl - Special Register Execution Unit for the F-CPU.
-- Copyright (C) 2000 Yann GUIDON <whygee@f-cpu.org>
--
-- This file is a behavioural description of the Special Registers.
-- No particular implementation or architecture is intended yet.
-- The main purpose is to make a general and functional census,
-- it is not cycle acurate.
--
-- rev. 0.1: 11/26/2000: YG created the file from asu.vhdl
-- rev. 0.2: 12/1/2000: YG cleaned but it's incomplete...
--   this version displays the SR_URL, it should be modified
--   if it doesn't match the bit/byte ordering.
--
-- current revision : 12/1/2000
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_textio.all;
use IEEE.numeric_std.all;
LIBRARY std;
    USE std.textio.ALL;

library work;
use work.FCPU_config.all;

entity EU_SR is
	port(
                Din_0    : in F_VECTOR;   -- input value (upon write)
                Din_1    : in F_VECTOR;   -- special register number
                CTRL_RW,                  -- read or write control line
                ready,                    -- the unit has finished his work (not used yet)
                main_clk : in std_ulogic; -- clock
        --
                Dout_0   : out F_VECTOR   -- output value (upon read)
	);
end EU_SR;

architecture Struct_1 of EU_SR is

type URL_array is array (0 to SR_URL_size-1) of F_VECTOR;

-- The following functions are derived from Michael Riepe's propositions

impure function s2v (st : string) return F_VECTOR is
  variable vector_out : F_VECTOR := ((others => '0'));
  variable i, j : natural := 0;  
  variable lout : line ;
begin
  if st'length > MAXSIZE then
    write(lout,string'("Warning s2v : URL string too long !"));
    writeline(output,lout);
  end if;

  for j in st'low to st'high loop
    vector_out(i+7 downto i) := std_ulogic_vector(to_unsigned(character'pos(st(j)), 8));
    i:=i+8;
  end loop;
  return vector_out;
end s2v;


impure function s2va (st : string) return URL_array is
  variable array_out : URL_array ;
  variable i,j,k : natural := 0;  
  variable lout : line;
begin
  k := SR_URL_size*MAXSIZE;
  if st'length >= k then
    write(lout,string'("Warning s2va : URL string too long !"));
    writeline(output,lout);
  end if;

  k := st'low;
  while k < st'high loop
    if k+7 < st'high then
      i:=k+7;
    else
      i:=st'high;
    end if;
    array_out(j) := s2v(st(k to i));
    k:=k+MAXSIZE;
    j:=j+1;
  end loop;

  return array_out;
end s2va;


constant SR_URL_array : URL_array := s2va(SR_URL_val);

signal SR_CYCLE_val : F_VECTOR := (others => '0');

begin

-- increment the cycle counter for every clock tick.
  clock_tick : process(main_clk)
  begin
    if (main_clk='1' and main_clk'event) then
       SR_CYCLE_val(0) <= not SR_CYCLE_val(0);
 -- i gotta map an incrementer here !
    end if;
  end process clock_tick;

  check : process 
    variable lout : line ;
  begin
    wait for 100 ns;
    hwrite (lout,SR_URL_array(0));
    writeline(output,lout);
    hwrite (lout,SR_URL_array(1));
    writeline(output,lout);
    hwrite (lout,SR_URL_array(2));
    writeline(output,lout);
    hwrite (lout,SR_URL_array(3));
    writeline(output,lout);
    hwrite (lout,SR_URL_array(4));
    writeline(output,lout);
    hwrite (lout,SR_URL_array(5));
    writeline(output,lout);
    hwrite (lout,SR_URL_array(6));
    writeline(output,lout);
    hwrite (lout,SR_URL_array(7));
    writeline(output,lout);
    wait;
  end process check;

-- Unfinished.

end Struct_1;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please


