#ifndef FCPU_PORTS_H
#define FCPU_PORTS_H

/* f-cpu/include/f-cpu_ports.h
   included by f-cpu/include/f-cpu_config.h

created Sun Aug 12 20:05:20 2001 by whygee@f-cpu.org
Fri Jul 26 23:24:32 CEST 2002 JWS: added 0 latency EU

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

This file defines the names of the Xbar ports and
the values that are used to switch a specific data.
These values are used by Xbar_write_to_(x) and
Xbar_read_from_(x).

This file is not (yet) generated by m4 scripts
because the VHDL code lags behind the C code.
The same defined values and names will be used,
however, in the future codes.

 */


/* Xbar_read_from_(x)  (Xbar Read cycle) : */
#define PORT_READ_FROM_REGISTER       0   /* the normal stuff */
#define PORT_READ_FROM_BYPASS_0       1   /* bypass write bus 0 */
#define PORT_READ_FROM_BYPASS_0_BIS   2   /* 1-cycle delay of the above */
#define PORT_READ_FROM_BYPASS_0_BI2   3   /* 2-cycle delay of the above */
#define PORT_READ_FROM_BYPASS_1       4   /* bypass write bus 1 */
#define PORT_READ_FROM_BYPASS_1_BIS   5   /* 1-cycle delay of the above */
#define PORT_READ_FROM_BYPASS_1_BI2   6   /* 1-cycle delay of the above */
#define PORT_READ_FROM_IMMEDIATE      7   /* from the instruction deocder */
#define PORT_READ_FROM_CIP            8   /* from the fetcher */
#define PORT_READ_FROM_NIP            9   /* from the fetcher */


/* Xbar_write_to_(x)   (Xbar Write cycle) : */
#define PORT_WRITE_FROM_NOTHING       0    /* "nop" */
#define PORT_WRITE_FROM_REGISTER      1    /* register to register write */
#define PORT_WRITE_FROM_IMMEDIATE     2    /* similar to the above but copy from a different port */
#define PORT_WRITE_FROM_ROP2          3    /* ROP2 output */
#define PORT_WRITE_FROM_ASU           4    /* ASU main port */
#define PORT_WRITE_FROM_ASU2          5    /* ASU carry port */
#define PORT_WRITE_FROM_BIST0         6    /* BIST service port 0 */
#define PORT_WRITE_FROM_BIST1         7    /* BIST service port 1 */
/* added by JWS: (for register move) */
#define PORT_WRITE_FROM_MOV           8    /* 0 cycle EU output port */
#define PORT_WRITE_FROM_IMU0          9    /* IMU low part of result */
#define PORT_WRITE_FROM_IMU1        0xA    /* IMU high part of result */

/* other EU will be added : IDIV, IMU, INC, LSU,... */

/* added by JWS: (for xbar read to) */
#define EU_type_ASU    0
#define EU_type_INC    2
#define EU_type_SHL    4
#define EU_type_IDU    6
#define EU_type_ROP2   7
#define EU_type_POPC   8
#define EU_type_LSU    9
#define EU_type_SR   0xA
#define EU_type_IMU  0xB
#define EU_type_MOV  0xC /* added by JWS: (for register move) */
/* we could just add an extra output port to an existing EU, */
/* so we don't need a seperate 0-cycle unit !!               */


/* added by JWS: (for xbar write to is missing !! i.e.: ip, data ) */



#endif /* EOF */
