/*
 WARNING ! This file is automatically generated !
 Do not modify. Check all the m4 files in f-cpu/configuration
 for the original definitions.

 * compiled by USER = root on HOSTNAME = localhost.localdomain
 * DATE = Mon Jul 29 15:51:12 CEST 2002
 * PWD = /fcpu/jws/f-cpu/configuration

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#ifndef FCPU_OPCODES_H
#define FCPU_OPCODES_H

/*

source : f-cpu/configuration/f-cpu_opcodes.h.in
destination : f-cpu/include/f-cpu_opcodes.h
included by f-cpu/f-cpu_config.h
created Sat Jul 14 23:26:36 2001 by whygee@f-cpu.org
adapted Tue Aug 21 05:29:38 2001 for m4 preprocessing

This file contains the definition of the opcodes'
values, reflecting the most recent work. ie:
the ROP2 opcodes incorporate the function flags
in the opcode field. This is not yet stated in the
existing versions of the F-CPU manual.


********************WARNING!************************
All the #define are subject to changes.
They operate on 8-bit values that may be contiguous
(and must, in some cases). The #defines will be
optimized and reorganised later. Don't rely on their
values !!!
****************************************************

version Tue Jul 17 02:52:31 2001 by YG :

This file is included in f-cpu/qdcpoc2/main.c
and f-cpu/ygasm/ygasm.c so there is only one
instance of the file. It only contains #defines
and it can be reused in other software as well
(and even in VHDL, i guess, using cpp).

This is an attempt at doing a proof of concept,
this might not comply with the F-CPU Manual
and could contain errors. This is preliminary, do
not rely on this version for the actual values.

However, please reuse the naming conventions
everywhere it is possible. It will spare us
all a lot of work !


version Sun Aug  5 19:32:09 2001
changed some '+' to '|'

version Sun Aug 12 03:00:26 2001
renamed from opcodes.h.
removed non-opcode stuff.
look in features.h now.

version Sun Aug 12 20:11:36 2001
moved to f-cpu/include/

version Tue Aug 21 05:38:34 2001
moved to f-cpu/configuration/
the version in f-cpu/include/f-cpu_opcodes.h
is now automatically generated with m4.

version Sun Jul 28 18:51:13 CEST 2002
added a separate CMOV opcode

version Mon Jul 29 05:48:44 CEST 2002
added some temporary definitions + changed the layout

*/

/*********************************
    the "move" family of opcodes
 *********************************/
#define OP_NOP     0    /* do nothing. */
#define OP_MOV     1
#define OP_CMOV    2

/* the 2 opcodes require a 4-bit shift field,
   the 2 LSB are used. We need 8 opcodes for these 2 : */
#define OP_LOADCONS   8
#define OP_LOADCONSX  12   /*(OP_LOADCONS + 4)*/

/*********************************
    the ROP2 family of opcodes
 *********************************/
#define OP_ROP2    16   /* reserving a 3-bit field => 8 opcodes */
#define OP_MUX     16    /* MUX and combine overlap this 8-opcode field */
#define OP_AND     16    /*(OP_ROP2 | FUNCTION_AND)*/
#define OP_ANDN    17   /*(OP_ROP2 | FUNCTION_ANDN)*/
#define OP_XOR     18    /*(OP_ROP2 | FUNCTION_XOR)*/
#define OP_OR      19     /*(OP_ROP2 | FUNCTION_OR)*/
#define OP_NOR     20    /*(OP_ROP2 | FUNCTION_NOR)*/
#define OP_XNOR    21   /*(OP_ROP2 | FUNCTION_XNOR)*/
#define OP_ORN     22    /*(OP_ROP2 | FUNCTION_ORN)*/
#define OP_NAND    23   /*(OP_ROP2 | FUNCTION_NAND)*/

#define OP_ROP2I   24
/* imm8 eats the useful bits so we can't encode MUX or combine */
#define OP_ANDI    24   /*(OP_ROP2I | FUNCTION_AND) */
#define OP_ANDNI   25  /*(OP_ROP2I | FUNCTION_ANDN) */
#define OP_XORI    26   /*(OP_ROP2I | FUNCTION_XOR) */
#define OP_ORI     27    /*(OP_ROP2I | FUNCTION_OR) */
#define OP_NORI    28   /*(OP_ROP2I | FUNCTION_NOR) */
#define OP_XNORI   29  /*(OP_ROP2I | FUNCTION_XNOR) */
#define OP_ORNI    30   /*(OP_ROP2I | FUNCTION_ORN) */
#define OP_NANDI   31  /*(OP_ROP2I | FUNCTION_NAND) */

/**********************************
 !! WARNING !! only for early tests
 **********************************/

/* added for JWS */
#define OP_INC    100    /* added by JWS */
#define OP_DEC    101    /* added by JWS */
#define OP_INCI   102   /* added by JWS */
#define OP_DECI   103   /* added by JWS */
#define OP_ADD    104    /* added by JWS */
#define OP_SUB    105    /* added by JWS */
#define OP_ADDI   106   /* added by JWS */
#define OP_SUBI   107   /* added by JWS */
#define OP_MUL    108    /* added by JWS */

#endif /* EOF */
