/*
  /yg/f/f-cpu/c/stimulib/stimulib.c
  created Sun Jul 21 07:08:43 CEST 2002 by whygee@f-cpu.org

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

  This file is included by all the C testbenches for writing and
  reading stimuli files. It is kept to the bare functionalities,
  keeping it simple to understand, use, debug, port and fight bloat.

  Warning : it may be used only by the "main()" of a program at once,
  since it uses only one input and one output, kept in global variables.
  I hope we won't need multiple vectors at anytime (better merge them
  into a single file).

  Remark : since <stdio.h> is extensively used, this little library
  is really tiny. The size with other langages will depend on the
  availability of the necessary library functions.

*/

#include <stimulib.h>
#include <stdlib.h> /* for exit() */

/* "clean" exit : */

void test_error (char * message, int return_value) {
  printf(" ## ouch ! ##\n");
  printf(message);
  exit(return_value);
}

/* reading vectors : */

void open_vector_in (char * vector_name) {
  input_vector_handler = fopen (vector_name, "rb");
  if (input_vector_handler == NULL)
    test_error ("can't open input vector file\n", 1);
  input_vector_line = 0;
}

/* this is a define ==> no type check or cast is needed ! VHDL RULEZ !
     First argument is a string containing the variable name
     2nd : variable containing the expected value (from the stimuli)
     3rd : variable containing the computed value (unit's output)
     4th : string for easing the display of the variables
 */
#define COMPARE_VECTOR(VAR_NAME, EXPECTED, GOT, TYPE_FORMAT) \
  if (EXPECTED != GOT) { \
    printf("line #%ld\n", input_vector_line); \
    dump_state(); \
    printf("Expected value for %s is ", VAR_NAME); \
    printf(TYPE_FORMAT, EXPECTED); \
    printf(" but got "); \
    printf(TYPE_FORMAT, GOT); \
    test_error("Comparison failed !\n", 2); \
  }

void close_vector_in () {
  if (parsed != EOF) {
    input_vector_line ++;
    test_error("wrong vector format !\n", 5);
  }
  if (feof(input_vector_handler))
    printf("Successfully tested %ld vectors\n", input_vector_line);
  else
    test_error("End of file not reached ! Please verify the vectors.", 3);

  fclose (input_vector_handler);
}


/* writing vectors : */

void open_vector_out (char * vector_name) {
  output_vector_handler = fopen (vector_name, "wb");
  if (output_vector_handler == NULL)
    test_error ("can't open output vector file\n", 4);
  output_vector_line = 0;
}

void close_vector_out () {
  fclose (output_vector_handler);
}
