/*
  f-cpu/c/eu_imu/eu_imu.h - IMU Execution Unit ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:

Sun Jul 28 12:32:29 CEST 2002 JWS: created
Mon Jul 29 15:08:32 CEST 2002 JWS: added inputs and outputs

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef EU_IMU_H
#define EU_IMU_H

#include <f-cpu_config.h>
#define SIMD_MAX 0 /* move this to configure ! */
#define SIMD_32  1
#define SIMD_16  2
#define SIMD_8   3
#define true     1
#define false    0


#define LAT_IMU_8_L     3
#define LAT_IMU_8_H     4
#define LAT_IMU_16_L    4
#define LAT_IMU_16_H    5
#define LAT_IMU_32_L    5
#define LAT_IMU_32_H    5
#define LAT_IMU_64_L    6
#define LAT_IMU_64_H    6

/* inputs: */
UMAX imu_in_A;   /* the 2 operands */
UMAX imu_in_B;
u8   imu_size;
bool imu_simd;
bool imu_high;  /* compute it anyway ?? */

/* outputs : */
UMAX imu_out0;    /* low part of result */
UMAX imu_out1;    /* high part of result */

/* internal: */
UMAX imu_out_low[LAT_IMU_64_H]; /* delay queue */
UMAX imu_out_hig[LAT_IMU_64_H]; /* delay queue */

static inline void eu_imu_cycle (void);

#endif /* EU_IMU_H */
