/*
  f-cpu/c/scheduler/fetcher.v
  c simulation of the F-CPU fetcher unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update
Sun Jul 28 12:46:15 CEST 2002 JWS: added fetcher_view.c
Sun Jul 28 12:46:15 CEST 2002 JWS: added display_color and display_normal

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

                   fet_ip             memory bus and I cache
                      |                       ^
                      |                       |
                      v                       v
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%                         fetcher                                  %%
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    |       |          |          |              |            |  
    v       v          v          v              v            v
 fet_cip fet_nip   fet_instr fet_operand_2 fet_operand_1 fet_operand_dst
                             (or condition) (or pointer) (or opcode 3)
 fet_instr = opcode + flage + fet_imm + fet_op2 + fet_op1 + fet_dst

 how is 3r1w done ?  3rd read register == write register ?

 registers are read in the same cycle as the decode cycle !!
 we dont know if we need all 3 of them (or even none), but we instuct
 the register unit anyway, so we don't need to wait for it later.

 the intermidiate has to run thrue the decoder to see if it is 8 ir 16 bit.
 the data will be shifted 2 bits if needed.
*/

/* defines the constants, inputs and outputs : */
#include <fetcher.h>
#include <toplevel.h>

void fetcher_view(void){
  printf("fetcher input:\n");
  printf("fet_ip     = %s%16llX%s\n", display_color, fet_ip   , display_normal );
  /* add code memory interface ?? */
  printf("fetcher output:\n");
  printf("fet_cip    = %s%16llX%s\n",   display_color, fet_cip  , display_normal );
  printf("fet_nip    = %s%16llX%s\n",   display_color, fet_nip  , display_normal );
  printf("fet_instr  = %s%8lX%s  ",     display_color, fet_instr, display_normal );
  printf("( opcode = 0x%s%2lX%s ",      display_color, (fet_instr & 0xFF000000 )>>24, display_normal );
  printf(         "= %s%2li%s )\n",     display_color, (fet_instr & 0xFF000000 )>>24, display_normal );
  printf("fet_operand_2  = 0x%s%2X%s ", display_color, fet_operand_2  , display_normal );
  printf(               "= %s%2i%s\n",  display_color, fet_operand_2  , display_normal );
  printf("fet_operand_1  = 0x%s%2X%s ", display_color, fet_operand_1  , display_normal );
  printf(               "= %s%2i%s\n",  display_color, fet_operand_1  , display_normal );
  printf("fet_operand_dst= 0x%s%2X%s ", display_color, fet_operand_dst, display_normal );
  printf(               "= %s%2i%s\n",  display_color, fet_operand_dst, display_normal );
}

static inline void fetcher_cycle(void) {

  /* fetcher stage */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

  u8  c0;
  u8  c1;
  u8  c2;
  u8  c3;

  /*
  printf("fetcher: ");
  printf("Please enter 32bit instruction for IP=%16llX = 0x", fet_ip);
  scanf("%x",&fet_instr);
  scanf("%c",&get_enter);
  */

  if ( ( !bist_active ) && ( fet_ip+3 < SIM_MEMORY_SIZE ) ){
    c0 = sim_memory[fet_ip+0]; /* reead from memory */
    c1 = sim_memory[fet_ip+1];
    c2 = sim_memory[fet_ip+2];
    c3 = sim_memory[fet_ip+3];
    fet_instr =                     c0;  /* change byte order here if needed. */
    fet_instr = ( fet_instr << 8) | c1;
    fet_instr = ( fet_instr << 8) | c2;
    fet_instr = ( fet_instr << 8) | c3;
    fet_cip = fet_ip;                    /* update current and next IP output */
    fet_nip = fet_ip + 4;
  }else{
    fet_instr = 0;        /* nop */
    fet_cip = 0;
    fet_nip = 0;
  }

  fet_operand_2  = (fet_instr & 0x0003F000LL) >> 12;
  fet_operand_1  = (fet_instr & 0x00000FC0LL) >> 6;
  fet_operand_dst=  fet_instr & 0x0000003FLL;

}
