/*
  f-cpu/c/scheduler/decoder_view.c
  shows status of scheduler unit for f-cpu simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
Sun Jul 21 19:32:54 CEST 2002 JWS.
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update
Tue Jul 23 13:03:52 CEST 2002 JWS: added missing inputs / outputs

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

void decoder_view(void){

  printf(  "decoder inputs:");

  printf("\ndec_instr =");      g(); printf("%8X",dec_instr      ); n();
  printf( " dec_operand_2 =" ); g(); printf("%2i",dec_operand_2  ); n();
  printf( " dec_operand_1 = " ); g(); printf("%2i",dec_operand_1  ); n();
  printf( " dec_operand_dst=");g(); printf("%2i",dec_operand_dst); n();

  printf("\ndecoder outputs:");

  printf("\ndec_latency   = "); g(); printf("%2i",dec_latency); n();
  printf( " dec_imm     = 0x"); g(); printf("%4X",dec_imm    ); n();

  printf("\ndec_use_r0    = "); print_true_false(dec_use_r0);
  printf( " dec_use_r1 = "); print_true_false(dec_use_r1);
  printf( " dec_use_r2 = "); print_true_false(dec_use_r2);

  printf("\ndec_r0_reg_nr = "); g(); printf("%2i",dec_r0_reg_nr); n();
  printf( " dec_r1_reg_nr = "); g(); printf("%2i",dec_r1_reg_nr); n();
  printf( " dec_r2_reg_nr = "); g(); printf("%2i",dec_r2_reg_nr); n();
  printf( " dec_read_to_EU_nr=");g();printf("%2i",dec_read_to_EU_nr); n();

  printf("\ndec_r0_port_nr= "); g(); printf("%2i",dec_r0_port_nr); n();
  printf( " dec_r1_port_nr= "); g(); printf("%2i",dec_r1_port_nr); n();
  printf( " dec_r2_port_nr= "); g(); printf("%2i",dec_r2_port_nr); n();

  printf("\ndec_w0_reg_nr = "); g(); printf("%2i",dec_w0_reg_nr); n();
  printf( " dec_w1_reg_nr = "); g(); printf("%2i",dec_w1_reg_nr); n();
  printf("\ndec_w0_port_nr= "); g(); printf("%2X",dec_w0_port_nr); n();
  printf( " dec_w1_port_nr= "); g(); printf("%2X",dec_w1_port_nr); n();

  printf("\ndec_ADD = "); print_true_false(dec_ADD);
  printf( " dec_SUB = "); print_true_false(dec_SUB);
  printf( " dec_INC = "); print_true_false(dec_INC);
  printf( " dec_DEC = "); print_true_false(dec_DEC);

  printf("\ndec_rop2_function= "); g(); printf("%2X",dec_rop2_function); n();
  printf( " dec_rop2_mode= "); g(); printf("%2X",dec_rop2_mode); n();

  /* dec_rop2_combine_size ?? */

  printf("\n");

}
