/*
  f-cpu/c/registers/test_registers.c - tests the registers
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Sat Jul 13 14:39:00 CEST 2002 : first test
  version Sat Jul 20 20:39:57 CEST 2002 : YG changes letter
    case for all occurences of "REG_", also replaced
    "cycle_registers" with "registers_cycle"
  version Sat Jul 27 04:23:27 CEST 2002 : YG installs stimulib

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stimulib.c> /* includes stdio */
#include <registers.c>

/* must be provided so COMPARE_VECTOR works : */
void dump_state() {
  registers_view();
}

int main(int argc, char **argv) {

  /* expected outputs: */
  UMAX expected_reg_R0;
  UMAX expected_reg_R1;
  UMAX expected_reg_R2;
  int  expected_reg_ZERO;  /* the 4 flags */
  int  expected_reg_MSB;
  int  expected_reg_LSB;
  int  expected_reg_FP;
  int  expected_reg_align;

  /* to protect from casting troubles */
  int tmp_w0_reg_nr;
  int tmp_w1_reg_nr;
  int tmp_nr_R0;
  int tmp_nr_R1;
  int tmp_nr_R2;


  open_vector_in("vect_registers.hex");

  while ((parsed = fscanf(input_vector_handler,
    "%llX %llX %X %X %X %X %X %llX %llX %llX %d %d %d %d %X\n",
    &reg_W0, &reg_W1, &reg_w0_reg_nr, &reg_w1_reg_nr,
    &reg_nr_R0, &reg_nr_R1, &reg_nr_R2,
    &expected_reg_R0,   &expected_reg_R1,   &expected_reg_R2,
    &expected_reg_ZERO, &expected_reg_MSB,  &expected_reg_LSB,
    &expected_reg_FP,   &expected_reg_align)) == 15) {

    input_vector_line ++;

    /* to avoid stupid typing/casting problems or warnings */
    reg_w0_reg_nr = tmp_w0_reg_nr;
    reg_w1_reg_nr = tmp_w1_reg_nr;
    reg_nr_R0 = tmp_nr_R0;
    reg_nr_R1 = tmp_nr_R1;
    reg_nr_R2 = tmp_nr_R2;

    /* the Xbar stage's delay is not tested yet */
    registers_cycle();

    COMPARE_VECTOR("reg_R0",    expected_reg_R0,    reg_R0,    "%.16llX")
    COMPARE_VECTOR("reg_R1",    expected_reg_R1,    reg_R1,    "%.16llX")
    COMPARE_VECTOR("reg_R2",    expected_reg_R2,    reg_R2,    "%.16llX")
    COMPARE_VECTOR("reg_ZERO",  expected_reg_ZERO,  reg_ZERO,  "%d")
    COMPARE_VECTOR("reg_MSB",   expected_reg_MSB,   reg_MSB,   "%d")
    COMPARE_VECTOR("reg_LSB",   expected_reg_LSB,   reg_LSB,   "%d")
    COMPARE_VECTOR("reg_FP",    expected_reg_FP,    reg_FP,    "%d")
    COMPARE_VECTOR("reg_align", expected_reg_align, reg_align, "%X")
  }

  close_vector_in();
  return 0;
}

