/*
  getkey.c
  Copyright (C) 2002 Thomas Geroudet  gertom_fcpu@yahoo.fr
  version: 20 July 2002 19:00

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/



#include <termios.h>
#include <stdio.h>


int kbhit();
int getch();
int getkey();

/*
---------- ---------- ---------- ---------- ---------- ----------
Function :		main : 	self test

---------- ---------- ---------- ---------- ---------- ----------
*/
/*
int main()
{
  int key;

  printf( "Press a key...\n[q] to quit (not [Q] !)\nDo *not* try [CTRL]+[s] (you've been warned !)\n" );

  while ( ( key = getkey() ) != 113 )
  {
    printf( "%i\t'%c'\n", key, key );
  }
  return ( 0 );
}
*/


/*
---------- ---------- ---------- ---------- ---------- ----------
Function :		getkey

In :			void

Out :			int :	ascii val of the pressed key

---------- ---------- ---------- ---------- ---------- ----------
*/
int getkey()
{
  int key;

  // waiting for a key to be pressed
  while( ! kbhit() );

  key = getch();

  // emptying buffer
  // some keys like arrows, etc... returns an escape sequence with 3 or 5 characters
  // i don't know what could happen if some characters remain in the buffer
  // maybe some unexpected result :-(
  while ( getch() != -1 );

  return( key );
}


/*
---------- ---------- ---------- ---------- ---------- ----------
Function :		kbhit	returns keyboard status

In :			void

Out :			int :	1 if a key has been entered
				0 if nothing happened

---------- ---------- ---------- ---------- ---------- ----------
*/
int kbhit()
{
  struct termios term, old_term;
  int fd = 0;
  int c;

  // getting term info
  tcgetattr( fd, &old_term );

  // copying term info before modifying it
  memcpy( &term, &old_term, sizeof( term ) );

  // selecting automated mode (non-canonical)
  // waiting until the first of these two events :
  // 	0.1s elapsed
  // 	key pressed
  term.c_lflag = term.c_lflag & ( ! ICANON );
  term.c_cc[ VMIN ] = 0;
  term.c_cc[ VTIME ] = 1;
  // TCSANOW means changes applies immediately
  tcsetattr( fd, TCSANOW, &term );

  // reading a character
  c = getchar();

  // restoring term info
  tcsetattr( fd, TCSANOW, &old_term );

  // if a key has been pressed, we re-put c in stdin
  if ( c != -1 )
  {
    ungetc( c, stdin );
    return( 1 );
  }
  else
  {
    return( 0 );
  }
}



/*
---------- ---------- ---------- ---------- ---------- ----------
Function :		getch	returns the ascii val of the last pressed key

In :			void

Out :			int :	ascii val of the pressed key
				-1 if there were nothing in buffer
				(non-ascii keys such as arrows, etc... returns an escape sequence)

---------- ---------- ---------- ---------- ---------- ----------
*/
int getch()
{
  int c, fd = 0;
  struct termios term, old_term;

  // getting term info
  tcgetattr( fd, &old_term );

  // copying term info before modifying it
  memcpy( &term, &old_term, sizeof( term ) );

  // selecting automated mode (non-canonical)
  // waiting until the first of these two events :
  // 	0.1s elapsed
  // 	key pressed
  term.c_lflag = term.c_lflag & ( ! ICANON );
  term.c_cc[ VMIN ] = 0; //1
  term.c_cc[ VTIME ] = 0;
  tcsetattr( fd, TCSANOW, &term );

  // reading the character
  c = getchar();

  // restoring term info
  tcsetattr( fd, TCSANOW, &old_term );

  // returning ascii val of the pressed key
  return c;
}

