/*
  f-cpu/c/eu_rop2/test_rop2.c - tests the ROP2 Execution Unit
  created Sun Jul  7 03:07:50 CEST 2002 by Yann GUIDON (whygee@f-cpu.org)
  version Sun Jul 21 09:34:47 CEST 2002 : YG adds stimulib
  version Sat Jul 27 03:35:01 CEST 2002 : enabled the pipeline and testing it

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

/* defines the constants, inputs and outputs : */
#include <eu_rop2.c>

/* includes stimulib : */
#include <stimulib.c>

/* must be provided so COMPARE_VECTOR works : */
void dump_state() {
  eu_rop2_view();
}

int main(int argc, char **argv) {
  UMAX expected_ROP2_out;
  int tmp_mode, tmp_func;

  open_vector_in("vect_rop2.hex");

  while ((parsed = fscanf(input_vector_handler, "%d %d %llX %llX %llX %llX\n",
    &tmp_func, &tmp_mode, &ROP2_in_A, &ROP2_in_B, &ROP2_in_C,
    &expected_ROP2_out)) == 6) {

    input_vector_line ++;

    /* to avoid typing/casting problems */
    ROP2_function = tmp_func;
    ROP2_mode = tmp_mode;

    /* the Xbar stage's delay is not tested yet */
    cycle_rop2 ();

    COMPARE_VECTOR("ROP2_out", expected_ROP2_out, ROP2_out, "%.16llX")
  }

  close_vector_in();
  return 0;
}
