/* 
  f-cpu/c/toplevel/toplevel.c - links all units together
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
version:  
    Jul 21 02:16:00 CEST 2002 JWS: extracted fron old fcpusim.c
Sun Jul 21 10:55:04 CEST 2002 JWS: added bypass detection info from xbar to dec.
Sun Jul 21 12:30:07 CEST 2002 JWS: added clear write_queue's
Thu Jul 25 22:04:17 CEST 2002 JWS: added ROP2 connection

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>

#include <fetcher.c>
#include <decoder.c>
#include <scheduler.c> /* mut run before the rest for correct stall !?*/
#include <registers.c>
#include <xbar.c>
#include <eu_asu.c>
#include <eu_rop2.c>
#include <eu_inc.c>

void simulate_one_cycle(void) {

/* run all the units: */

  /* (order dous not matter!) */
  if ( !stalled ) {
    fetcher_cycle ();
    decoder_cycle ();
  }
  scheduler_cycle ();
  registers_cycle ();
  xbar_cycle ();
  eu_asu_cycle ();
  eu_rop2_cycle ();
  eu_inc_cycle ();

  /* connect all the units (i.e. clock the FF's between them ) 
     some exceptions when the pipeline is stalled ! */

  if ( !stalled ) {  /* ONLY if the pipeline is not stalled: */

    /* everything comming from the fetcher and decoder must be here !!!*/

    /* to: the fetcher: */
    fet_ip = fet_nip;

    /* to: the decoder: */
    dec_instr      = fet_instr;          /* from the fetcher */
    dec_operand_2  = fet_operand_2;
    dec_operand_1  = fet_operand_1;
    dec_operand_dst= fet_operand_dst;
    xbar_use_r0    = dec_use_r0;   /* from the decoder                 */
    xbar_use_r1    = dec_use_r1;   /* if one of these are true we must */
    xbar_use_r2    = dec_use_r2;   /*      use a bypass (if avalable)  */

    /* to: scheduler: */
    sch_use_r0    = dec_use_r0;        /* from the decoder */
    sch_use_r1    = dec_use_r1;        /* true if register nr needs to be checked*/
    sch_use_r2    = dec_use_r2;        /* in the used_register tabel */
    sch_r0_reg_nr = dec_r0_reg_nr;     /* from the decoder */
    sch_r1_reg_nr = dec_r1_reg_nr; 
    sch_r2_reg_nr = dec_r2_reg_nr; 
    sch_latency   = dec_latency;       /* from the decoder (i.e.inc/dec=1 ) */
    sch_w0_port_nr=dec_w0_port_nr;     /* from the decoder */
    sch_w1_port_nr=dec_w1_port_nr;     /* used for write queue */
    sch_w0_reg_nr =dec_w0_reg_nr;      /* from the decoder */
    sch_w1_reg_nr =dec_w1_reg_nr;      /* ( reg nr 0 = don't write ) */

    /* to: the registers: */
    reg_nr_R0 = fet_operand_1;        /* from the fetcher */
    reg_nr_R1 = fet_operand_2;
    reg_nr_R2 = fet_operand_dst;

    /* to: the xbar: */
    xbar_r0_port_nr    = dec_r0_port_nr;  /* from the decoder */
    xbar_r1_port_nr    = dec_r1_port_nr;  /* dous not yet includ bypass ports !! */
    xbar_r2_port_nr    = dec_r2_port_nr;

    /* to: ASU unit: */
    asu_ADD = dec_ADD;                       /* from the decoder */
    asu_SUB = dec_SUB;
    //asu_simd = dec_simd;
    //asu_size = dec_size;

    /* to: ROP2 unit: */
    ROP2_function    = dec_rop2_function;    /* from the decoder */
    ROP2_mode        = dec_rop2_mode;
    ROP2_Combine_size= dec_rop2_combine_size;

    /* --- add more EU's here --- */
 
  }

  /* to: scheduler: */
  sch_operand_1  = fet_operand_1;    /* opcodes from fetcher */
  sch_operand_2  = fet_operand_2;    /* used for detecting bypass */
  sch_operand_dst= fet_operand_dst;
  /* if we stall the communicaton between the fetcher and the scheduler
     we won't be able to recover from a stall correctly !!!!!
     becouse the fetcher output is for the NEXT instruction, and not for
     the CURRENT (stalled) intructuin !!!! */

  /* to: registers: */
  reg_w0_reg_nr = sch_reg_w0_reg_nr; /* from the scheduler */
  reg_w1_reg_nr = sch_reg_w1_reg_nr;
  reg_W0        = xbar_reg_W0;       /* from the xbar */
  reg_W1        = xbar_reg_W1;

  /* to: the xbar: */
  xbar_reg_R0        = reg_R0;          /* from the registers */
  xbar_reg_R1        = reg_R1;
  xbar_reg_R2        = reg_R2;
  xbar_sch_bypass_r0 = sch_bypass_r0;   /* from the scheduler */
  xbar_sch_bypass_r1 = sch_bypass_r1;
  xbar_sch_bypass_r2 = sch_bypass_r2;
  /* write control: */
  xbar_w0_port_nr = sch_xbar_w0_port_nr; /* from the scheduler */
  xbar_w1_port_nr = sch_xbar_w1_port_nr;
  xbar_write_from_port[PORT_WRITE_FROM_ASU ] = asu_out0; /* from ASU unit */
  xbar_write_from_port[PORT_WRITE_FROM_ASU2] = asu_out1;
  xbar_write_from_port[PORT_WRITE_FROM_ROP2] = ROP2_out; /* from ROP2 unit */

  /* to: ASU unit: */
  asu_in_A  = xbar_read_to_port_r0[ EU_type_ASU  ] ; /* from the xbar */
  asu_in_B  = xbar_read_to_port_r1[ EU_type_ASU  ] ;

  /* to: ROP2 unit: */
  ROP2_in_A = xbar_read_to_port_r0[ EU_type_ROP2 ] ; /* from the xbar */
  ROP2_in_B = xbar_read_to_port_r1[ EU_type_ROP2 ] ;
  ROP2_in_C = xbar_read_to_port_r2[ EU_type_ROP2 ] ;

  /* --- add more EU's here --- */

}



  /* !!!!!!!! the following should be don by BIST !!!!!!!!!!! ????  */


void clear_all_units(void){
  int clear_reg_cnt;
  int clear_level_cnt;

  for (clear_reg_cnt=0;clear_reg_cnt<64;clear_reg_cnt++){
    register_value[clear_reg_cnt]=0;  
  }
  reg_w0_reg_nr = 0;  /* set all read and write ports to register 0x00 !?*/
  reg_w1_reg_nr = 0;
  reg_nr_R0 = 0;
  reg_nr_R1 = 0;
  reg_nr_R2 = 0;

  for (clear_level_cnt=0; clear_level_cnt<9; clear_level_cnt++){
    for (clear_reg_cnt=0; clear_reg_cnt<64; clear_reg_cnt++){
      sch_register_in_use[clear_level_cnt][clear_reg_cnt] = false;
    }
  }
  for (clear_level_cnt=0; clear_level_cnt<9; clear_level_cnt++){
    for (clear_reg_cnt=0; clear_reg_cnt<2; clear_reg_cnt++){
      sch_Q_write_to_reg_nr   [clear_level_cnt][clear_reg_cnt] = 0;
      sch_Q_write_from_port_nr[clear_level_cnt][clear_reg_cnt] = 0;
    }
  }

  inc_INC = false;  /* im not sure if this is all needed, or if its complete !*/
  inc_DEC = false;
  inc_ABS = false;
  inc_NEG = false;
  inc_LSB0 = false;
  inc_LSB1 = false;
  asu_ADD = false;
  asu_SUB = false;
  xbar_reg_W0 = 0;
  xbar_reg_W1 = 0;
  xbar_EU_nr = 0;

}

