/*
  f-cpu/c/scheduler/decoder.c
  c simulation of the F-CPU decoder unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com

  version:
           19 July 2002 13:30
Sun Jul 21 11:02:19 CEST 2002 JWS: cganged decoder_* into: dec_*
Sun Jul 21 12:55:37 CEST 2002 JWS: need to add queue info !!
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update
Fri Jul 26 11:08:55 CEST 2002 JWS: cleadn up, added rop2 and reg-move

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

/* defines the constants, inputs and outputs : */
#include <decoder.h>

static inline void decoder_cycle (void) {

u8   opcode;
bool imm_8bit;

  /* decode flags and imm: (this is just wires in hardware !? ) */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

  dec_imm8  = (dec_instr & 0x000FF000LL) >> 12 ;
  dec_imm16 = (dec_instr & 0x003FFFC0LL) >> 6 ;
  use_imm16 = false;

#define     IEEE_FLAG_POS  0  /* 1 bit  ??? */
#define     SIZE_FLAG_POS 22  /* 2 bits */
#define     SIMD_FLAG_POS 21  /* 1 bit  */
#define   ENDIAN_FLAG_POS 21  /* 1 bit  */
#define SATURATE_FLAG_POS 19  /* 1 bit  */
#define    CARRY_FLAG_POS 18  /* 1 bit  */
#define   STREAM_FLAG_POS 18  /* 3 bit  */
#define JMP_COND_FLAG_POS 19  /* 2 bit  */
#define JMP_NCON_FLAG_POS 21  /* 1 bit  */
#define MOV_COND_FLAG_POS 11  /* 2 bit  */
#define MOV_NCON_FLAG_POS 10  /* 1 bit  */

  dec_size     = (dec_instr >>     SIZE_FLAG_POS) & 0x03;   /* 2 bits */
  dec_simd     = (dec_instr >>     SIMD_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_endian   = (dec_instr >>   ENDIAN_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_satutare = (dec_instr >> SATURATE_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_carry    = (dec_instr >>    CARRY_FLAG_POS) & 0x01;   /* 1 bit  */
  dec_stream   = (dec_instr >>   STREAM_FLAG_POS) & 0x07;   /* 3 bit  */
  dec_jmp_cond = (dec_instr >> JMP_COND_FLAG_POS) & 0x03;   /* 2 bit  */
  dec_jmp_ncond= (dec_instr >> JMP_NCON_FLAG_POS) & 0x01;   /* 1 bits */
  dec_mov_cond = (dec_instr >> MOV_COND_FLAG_POS) & 0x03;   /* 2 bit  */
  dec_mov_ncond= (dec_instr >> MOV_NCON_FLAG_POS) & 0x01;   /* 1 bits */

  /* decode instruction: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  opcode = (dec_instr & 0xFF000000LL) >> 24 ;

  dec_r0_reg_nr = dec_operand_1;   /* dec_use_r0 = false if we don't use it */
  dec_r1_reg_nr = dec_operand_2;   /* dec_use_r1 = false if we don't use it */
  dec_r2_reg_nr = dec_operand_dst; /* dec_use_r2 = false if we don't use it */
  dec_use_r0    = false;           /* "use" = "check for bypass" !! */ 
  dec_use_r1    = false;
  dec_use_r2    = false;
  dec_w0_reg_nr = 0;
  dec_w1_reg_nr = 0;
  dec_w0_port_nr= 0;  /* don't need to clear this */
  dec_w1_port_nr= 0;  /* don't need to clear this */
  dec_latency   = 0;
  dec_read_to_EU_nr = 0; /* = none (for nop and reg move ??) */
  dec_r0_port_nr= PORT_READ_FROM_REGISTER;
  dec_r1_port_nr= PORT_READ_FROM_REGISTER;
  dec_r2_port_nr= PORT_READ_FROM_REGISTER;

  dec_ADD       = false;
  dec_SUB       = false;
  dec_INC       = false;
  dec_DEC       = false;
  dec_rop2_function = 0;
  dec_rop2_mode = ROP2_DIRECT_MODE; /* =0 */
  dec_rop2_combine_size = 0;

  switch ( opcode ) {
    case OP_ADD:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_ADD           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_use_r1        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency     = 1;
      }else{
        dec_latency     = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
      }
    break;
    case OP_ADDI:       /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_ADD           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_r1_port_nr    = PORT_READ_FROM_IMMEDIATE;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency     = 1;
      }else{
        dec_latency     = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
      }
    break;
    case OP_SUB:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_SUB           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_use_r1        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency     = 1;
      }else{
        dec_latency     = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
      }
    break;
    case OP_SUBI:       /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_SUB           = true;
      dec_read_to_EU_nr = EU_type_ASU;
      dec_use_r0        = true;
      dec_r1_port_nr    = PORT_READ_FROM_IMMEDIATE;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ASU;
      if ( dec_size == 1 ){   /* 01 is a byte on 64 bit F=CPU ??? */
        dec_latency     = 1;
      }else{
        dec_latency     = 2;
      }
      if (dec_carry){
        dec_w1_reg_nr   = dec_operand_dst +1;
        dec_w1_port_nr  = PORT_WRITE_FROM_ASU2;
      }
    break;
    case OP_AND:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
    case OP_OR:         /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
    case OP_XOR:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_read_to_EU_nr = EU_type_ROP2;
      if ( opcode== OP_AND ) dec_rop2_function = FUNCTION_AND;
      if ( opcode== OP_OR  ) dec_rop2_function = FUNCTION_OR;
      if ( opcode== OP_XOR ) dec_rop2_function = FUNCTION_XOR;
      dec_use_r0        = true;
      dec_use_r1        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_ROP2;
      dec_latency     = 1;
      if (dec_rop2_mode != ROP2_DIRECT_MODE) {
        dec_use_r2        = true;
        dec_r2_reg_nr     = dec_operand_dst ^ 1;  /* please check !! */
      }
    break;
    case OP_MOV:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      dec_use_r0        = true;
      dec_w0_reg_nr     = dec_operand_dst;
      dec_w0_port_nr    = PORT_WRITE_FROM_REGISTER;
    break;



    /* -- add more here! -- */


    case OP_NOP:        /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      /* ok, that's easy */
    break;
    default:            /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
      /* exception !! (for now: ignore) */
    break;
  }

  /* correct imm if it's 8 bit: */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( use_imm16 ) {
    dec_imm = dec_imm16;
  }else{
    dec_imm = dec_imm8;
  }

}
