/* 
  f-cpu/c/scheduler/scheduler_view.c
  shows status of scheduler unit for f-cpu simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
Sun Jul 21 12:46:24 CEST 2002 JWS: added write queue.
Mon Jul 22 15:07:09 CEST 2002 JWS: complete rewrite, along with other units

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

void scheduler_view(void){
  int reg_view_cnt;
  int level_view_cnt;

  printf(  "scheduler inputs/outputs for bypass detection:\n");
  printf(  "sch_operand_1     ="); g(); printf("%2i",sch_operand_1  ); n();
  printf("  sch_operand_2     ="); g(); printf("%2i",sch_operand_2  ); n();
  printf("  sch_operand_dst    ="); g(); printf("%2i",sch_operand_dst); n();
  printf("\n(tmp_sch_operand_1="); g(); printf("%2i",tmp_sch_operand_1  ); n();
  printf("  tmp_sch_operand_2 ="); g(); printf("%2i",tmp_sch_operand_2  ); n();
  printf("  tmp_sch_operand_dst="); g(); printf("%2i",tmp_sch_operand_dst); n();
  printf(")");
  printf("\nsch_bypass_r0     ="); g(); printf("%2X",sch_bypass_r0); n();
  printf("  sch_bypass_r1     ="); g(); printf("%2X",sch_bypass_r1); n();
  printf("  sch_bypass_r2      ="); g(); printf("%2X",sch_bypass_r2); n();
  printf("\n");

  printf("scoreboard:  ");
  for (reg_view_cnt=10;reg_view_cnt<64;reg_view_cnt++){
      if ( (reg_view_cnt % 10)==0 ){
        printf("%1i", reg_view_cnt / 10 );
      }else{    
        printf(" ");
      }
  }
  printf(" QrQr QpQp\n");
  printf("reg:");
  for (reg_view_cnt=1;reg_view_cnt<64;reg_view_cnt++){
    printf("%1i", reg_view_cnt % 10 );
  }
  printf(" 0 1  0 1 \n");

  for (level_view_cnt=0;level_view_cnt<9;level_view_cnt++){
    printf("lev%1i",level_view_cnt);
    g();
    for (reg_view_cnt=1;reg_view_cnt<64;reg_view_cnt++){
      if ( level_view_cnt == 0  ){
        n(); printf(" "); g();
      }else{
        if ( sch_register_in_use[level_view_cnt][reg_view_cnt]){
          printf("x");
        }else{    
          printf(".");
        }
      }
    }
    n(); printf(" "); g();
    printf("%2i",sch_Q_write_to_reg_nr[level_view_cnt][0]);
    printf("%2i",sch_Q_write_to_reg_nr[level_view_cnt][1]);
    n(); printf(" "); g();
    if ( level_view_cnt == 0  ){
      n(); printf("    "); g();
    }else{
      printf("%2i",sch_Q_write_from_port_nr[level_view_cnt][0]);
      printf("%2i",sch_Q_write_from_port_nr[level_view_cnt][1]);
    }
    n(); printf("\n");
  }

  printf(  "scheduler inputs:\n");
  printf(  "sch_use_r0     = "); print_true_false(sch_use_r0);
  printf("  sch_use_r1  = "); print_true_false(sch_use_r1);
  printf("  sch_use_r2  = "); print_true_false(sch_use_r2);
  printf("\nsch_r0_reg_nr  = "); g(); printf("%2i",sch_r0_reg_nr ); n();
  printf("  sch_r1_reg_nr  = "); g(); printf("%2i",sch_r1_reg_nr ); n();
  printf("  sch_r2_reg_nr  = "); g(); printf("%2i",sch_r2_reg_nr ); n();
  printf("\nsch_w0_port_nr = "); g(); printf("%2X",sch_w0_port_nr ); n();
  printf("  sch_w1_port_nr = "); g(); printf("%2X",sch_w1_port_nr ); n();
  printf("\nsch_w0_reg_nr  = "); g(); printf("%2X",sch_w0_reg_nr  ); n();
  printf("  sch_w1_reg_nr  = "); g(); printf("%2X",sch_w1_reg_nr  ); n();

  printf("\nscheduler outputs:        ");
  printf(  "sch_stalled = "); print_true_false(sch_stalled);
  printf("\nsch_xbar_w0_reg_nr  = "); g(); printf("%2i",sch_xbar_w0_reg_nr ); n();
  printf("  sch_xbar_w1_reg_nr  = "); g(); printf("%2i",sch_xbar_w1_reg_nr ); n();
  printf("\nsch_xbar_w0_port_nr = "); g(); printf("%2i",sch_xbar_w0_port_nr ); n();
  printf("  sch_xbar_w1_port_nr = "); g(); printf("%2i",sch_xbar_w1_port_nr ); n();
  printf("\nsch_reg_w0_reg_nr   = "); g(); printf("%2i",sch_reg_w0_reg_nr ); n();
  printf("  sch_reg_w1_reg_nr   = "); g(); printf("%2i",sch_reg_w1_reg_nr ); n();

  printf("\n");
}

