/*
  f-cpu/c/registers/eu_asu.c - registers for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30
  version: Sat Jul 20 19:48:53 2002 by whygee@f-cpu.org : updated things

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

   /---------- reg_w0_reg_nr   > 1..63
   | /-------- reg_w1_reg_nr   > 1..63
   | | /------ reg_nr_R0   > 0..63
   | | | /---- reg_nr_R1   > 0..63
   | | | | /-- reg_nr_R2   > 0..63
   | | | | |
   | | | | |                                  reg_W0  reg_W1
   | | | | |                                    |       |
   v v v v v                                    v       v
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%                        registers stage                           %%
 %%                                                                  %%
 %%                                                                  %%
 %%                                                                  %%
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       |        |        |       |      |        |       |       |
       v        v        v       v      v        v       v       v
   reg_align reg_ZERO reg_MSB reg_LSB reg_FP   reg_R0  reg_R1  reg_R2

*/

/* defines the constants, inputs and outputs : */
#include "registers.h"

static inline void registers_cycle(void) {

  /*
  if (reg_w0_reg_nr) { register_value[reg_w0_reg_nr] = reg_W0; }
  if (reg_w1_reg_nr) { register_value[reg_w1_reg_nr] = reg_W1; }

  if (reg_nr_R0) { reg_R0 = register_value[reg_nr_R0]; } else { reg_R0 = 0; }
  if (reg_nr_R1) { reg_R1 = register_value[reg_nr_R1]; } else { reg_R1 = 0; }
  if (reg_nr_R2) { reg_R2 = register_value[reg_nr_R2]; } else { reg_R2 = 0; }

  JWS : reading and writing the same register should be prevented by the scheduler.
  YG  : yup.
  JWS : (it's done on the Xbar)
  YG  : ??
  JWS : zero detection is also done by an other unit ?
  YG  : no need of another unit, because some bypass conditions must also be detected.
        Here is the best place to do this. However, because there is no latency
        problem (as in HW), there is no need to maintain a cache of the ZERO flag.
  JWS : Ok. now, where is the catch? it can't be that easy...
  YG  : your instinct speaks ;-)
         - the flags are missing
         - the cycle acuracy must be maintained : the register set
            has read and write latencies that must be acurately modeled !
        This last issue must be solved along with the scheduling problems of the Xbar.
        Currently the first way to do this is to put the write AFTER the read.
        I hope it will work. Sorry if i rewrite your code and modify it :
  */

  /* read : */
  if (reg_nr_R0 != 0)
    reg_R0 = register_value[reg_nr_R0];
  else
    reg_R0 = 0;

  if (reg_nr_R1 != 0)
    reg_R1 = register_value[reg_nr_R1];
  else
    reg_R1 = 0;

  if (reg_nr_R2 != 0)
    reg_R2 = register_value[reg_nr_R2];
  else
    reg_R2 = 0;

  /* the flags */
  if ((reg_nr_R0 == 0) || (reg_R0 == 0LL))
    reg_ZERO = 0;
  else
    reg_ZERO = 1;

  reg_LSB = reg_R0 & 1;

  reg_MSB = (reg_R0 >> 63) & 1;
   /* there is a big problem here ! is it the MSB
     when registers are larger than 64 bits ? */

  reg_FP = 0; /* reserved */


  /* Warning ! i have probably exchanged r0 with r2 for the flags
     ==> please check */

  /* the pointer alignment flag : */
  reg_align = reg_R1 & ((1<<LOGMAXSIZE)-1);


  /* write : */
  if (reg_w0_reg_nr != 0)
    register_value[reg_w0_reg_nr] = reg_W0;

  if (reg_w1_reg_nr != 0)
    register_value[reg_w1_reg_nr] = reg_W1;
  /* here i don't see yet how the write latency will modeled. */

}
