/*
  f-cpu/c/xbar/eu_asu.h - Xbar for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef XBAR_H
#define XBAR_H

#include <f-cpu_config.h>

/* inputs: */
UMAX xbar_reg_R0;              /* connected to register read ports */
UMAX xbar_reg_R1;
UMAX xbar_reg_R2;
UMAX xbar_write_from_port[25]; /* connected to the outputs of the EU's */
u8   xbar_W0_nr;               /* Xbar settings, generated by scheduler */
u8   xbar_W1_nr;               /* i.e. witch EU to read/write using witch R/W bus */
u8   xbar_R0_nr;               /* and when to bypass a read bus to witch write bus */
u8   xbar_R1_nr;
u8   xbar_R2_nr;
u8   xbar_EU_nr;

/* outputs : */
UMAX xbar_reg_W0;              /* connected to register write ports */
UMAX xbar_reg_W1;
UMAX xbar_read_to_port_r0[16]; /* connected to the input 0 of the EU's */
UMAX xbar_read_to_port_r1[16]; /* connected to the input 1 of the EU's */
UMAX xbar_read_to_port_r2[16]; /* connected to the input 2 of the EU's */
u8   xbar_W0_reg_nr_bis;       /* delayed xbar_W0_nr */
u8   xbar_W1_reg_nr_bis;       /* delayed xbar_W1_nr */


/* internal FF between stages: */
UMAX tmp_xbar_bus_W0;     /* delayed xbar_reg_W0 */
UMAX tmp_xbar_bus_W1;     /* delayed xbar_reg_W1 */

/* problem : they should be enums !! */

static inline void cycle_asu (void);

#endif /* XBAR_H */


















































