/* 
  f-cpu/c/xbar/xbar.c
  c simulation of the F-CPU xbar unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--
--  /---------------- xbar_W0_nr  > 0..nr_of_write_ports_on_xbar-1
--  | /-------------- xbar_W1_nr  > 0..nr_of_write_ports_on_xbar-1
--  | | /------------ xbar_R0_nr  > 0..nr_of_read__ports_on_xbar-1
--  | | | /---------- xbar_R1_nr  > 0..nr_of_read__ports_on_xbar-1
--  | | | | /-------- xbar_R2_nr  > 0..nr_of_read__ports_on_xbar-1
--  | | | | | /------ xbar_EU_nr  > 0..
--  | | | | | |    
--  | | | | | |             xbar_reg_R1
--  | | | | | |    xbar_reg_R0 | xbar_reg_R2 lots_of_EU_out_ports
--  | | | | | |         |      |      |      |||||||
--  v v v v v v         v      v      v     \|||||||/
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %% Xbar stage        |      |      |      |||||||                   %%
-- %%                 --x------x------x--<---xxxxxxx===>============\  %%
-- %%       bypass -> --x------x------x--<---xxxxxxx===>=====\      |  %%
-- %%                   |      |      |                      |      |  %%
-- %%                   |      |      \==>===xxxxxxx==       |      |  %%
-- %%                   |      \=========>===xxxxxxx==       |      |  %%
-- %%                   \================>===xxxxxxx==       |      |  %%
-- %%                                        |||||||         |      |  %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--  | |                                      |||||||         |      |
--  | |                                     \|||||||/        v      v
--  | |                          lots_of_EU_in_ports  xbar_reg_W0 xbar_reg_W1
--  | |
--  | \-------------- xbar_W0_reg_nr_bis  > 0..63
--  \---------------- xbar_W1_reg_nr_bis  > 0..63
--
-- to keep things simple (or at least managable), I gave every port a number:
-- how is this going to be implemented in a real F-CPU ?
-- correct me if I'm going in the wrong direction here...
-- 
-- write port numbers:                read port numbers:
-- (write TO a register)             (read FROM a register)
-- 00 = from data memory to regX     00 = from regX to data memeory
-- 01 = TO PC ?                      01 = FROM PC ?
-- 02 =                              02 = FROM intermediate data ?
-- 03 =                              03 = 
-- 04 = ROP2_out                     04 = ROP2_in_A
-- 05 = INC_out                      05 = ROP2_in_B
-- 06 = SHL_out                      06 = INC_in_A
-- 07 = ASU_out_A                    07 = INC_in_B
-- 08 = ASU_out_B                    08 = SHL_in_A
-- 09 = IMUL_out_A                   09 = SHL_in_B
-- 0A = IMUL_out_B                   0A = ASU_in_A
-- 0B = DIV_out                      0B = ASU_in_B
-- 0C =                              0C = IMUL_in_A
-- 0D = POPC_out                     0D = IMUL_in_B
-- 0E = SRs_out                      0E = IDIV_in_A
-- 0F =                              0F = IDIV_in_B
-- 10 =                              10 = POPC_in_A
-- 11 =                              11 = POPC_in_B
-- 12 =                              12 = SR_in_A
-- 13 =                              13 = SR_in_B
--
-- PC to/from an EU ?  -> sort of bypass !!
-- intermediate data to/from an EU !  -> sort of bypass !!
-- also register to tegister bypass for faster register movements ??
--
-- Xbar needs to claer bits in 8 / 16 / 32 bit write mode !!
--
-- Xbar has no FF's in input or output ports ? (->no variables in simulator?)
*/

/* defines the constants, inputs and outputs : */
#include <xbar.h>

static inline void xbar_cycle(void) {

  UMAX xbar_bus_R0; 
  UMAX xbar_bus_R1;
  UMAX xbar_bus_R2;
  UMAX xbar_bus_W0;
  UMAX xbar_bus_W1;


  /* Xbar stage */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

  /* copy EU output ports to write bus: */
  xbar_bus_W0 = xbar_write_from_port[xbar_W0_nr];  /* or somthing........*/
  xbar_bus_W1 = xbar_write_from_port[xbar_W1_nr];  /* or imm or pc or. ?.*/
  /* write ro registers: */
  xbar_reg_W0 = xbar_bus_W0;  /* not if imm! */
  xbar_reg_W1 = xbar_bus_W1;  /* not if imm! */

  /* read bus (with normal register read): */
  if (xbar_R0_nr==PORT_READ_FROM_REGISTER){ xbar_bus_R0 = xbar_reg_R0; }
  if (xbar_R1_nr==PORT_READ_FROM_REGISTER){ xbar_bus_R1 = xbar_reg_R1; }
  if (xbar_R2_nr==PORT_READ_FROM_REGISTER){ xbar_bus_R2 = xbar_reg_R2; }

  /* read bus (with bypass): */
  if (xbar_R0_nr==PORT_READ_FROM_BYPASS_0){ xbar_bus_R0 = xbar_bus_W0; }
  if (xbar_R0_nr==PORT_READ_FROM_BYPASS_1){ xbar_bus_R0 = xbar_bus_W1; }
  if (xbar_R1_nr==PORT_READ_FROM_BYPASS_0){ xbar_bus_R1 = xbar_bus_W0; }
  if (xbar_R1_nr==PORT_READ_FROM_BYPASS_1){ xbar_bus_R1 = xbar_bus_W1; }
  if (xbar_R2_nr==PORT_READ_FROM_BYPASS_0){ xbar_bus_R2 = xbar_bus_W0; }
  if (xbar_R2_nr==PORT_READ_FROM_BYPASS_1){ xbar_bus_R2 = xbar_bus_W1; }

  /* read bus (with delayed bypass): */
  if (xbar_R0_nr==PORT_READ_FROM_BYPASS_0_BIS){ xbar_bus_R0 = tmp_xbar_bus_W0; }
  if (xbar_R0_nr==PORT_READ_FROM_BYPASS_1_BIS){ xbar_bus_R0 = tmp_xbar_bus_W1; }
  if (xbar_R1_nr==PORT_READ_FROM_BYPASS_0_BIS){ xbar_bus_R1 = tmp_xbar_bus_W0; }
  if (xbar_R1_nr==PORT_READ_FROM_BYPASS_1_BIS){ xbar_bus_R1 = tmp_xbar_bus_W1; }
  if (xbar_R2_nr==PORT_READ_FROM_BYPASS_0_BIS){ xbar_bus_R2 = tmp_xbar_bus_W0; }
  if (xbar_R2_nr==PORT_READ_FROM_BYPASS_1_BIS){ xbar_bus_R2 = tmp_xbar_bus_W1; }


  /* copy read bus to EU input ports: */
  xbar_read_to_port_r0[xbar_EU_nr] = xbar_bus_R0;
  xbar_read_to_port_r1[xbar_EU_nr] = xbar_bus_R1;
  xbar_read_to_port_r2[xbar_EU_nr] = xbar_bus_R2;

  /* clear al other EU input ports ? -> they sould not isue ! */

  /* set writen register number ( FIFO for egister bypass ) */

  xbar_W0_reg_nr_bis=reg_nr_W0;  /* not if it was pc or imm ??*/
  xbar_W1_reg_nr_bis=reg_nr_W1;  /* don't mix xbar-port numbers and reg numbers !!*/
  /* and save its value:  */
  tmp_xbar_bus_W0=xbar_bus_W0;
  tmp_xbar_bus_W1=xbar_bus_W1;



}

