/* 
  f-cpu/c/toplevel/toplevel.c - links all units together
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com

 version:     Jul 21 02:16:00 CEST 2002 : JWS extracted fron old fcpusim.c

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>

#include <fetcher.c>
#include <decoder.c>
#include <scheduler.c>
#include <registers.c>
#include <xbar.c>
#include <eu_asu.c>
#include <eu_inc.c>

void simulate_one_cycle(void) {

/* run all the units: (order sould not matter) */

  fetcher_cycle ();
  decoder_cycle ();
  scheduler_cycle ();
  registers_cycle ();
  xbar_cycle ();
  eu_asu_cycle ();
  eu_inc_cycle ();

  /* connect all the units (i.e. clock the FF's between them ) 
     some exceptions when the pipeline is stalled ! */

  if ( !scheduler_stalled ) {

    /* fetcher unit --> register unit: */
    reg_nr_R0 = fet_op1; 
    reg_nr_R1 = fet_op2;
    reg_nr_R2 = fet_dst; /* fet_dst ^ 0x01 ?? */

    /* fetcher unit --> decoder unit: */
    decoder_instr = fet_instr;
    decoder_op2 = fet_op2;
    decoder_op1 = fet_op1;
    decoder_dst = fet_dst;

    /* xbar unit --> decoder unit: (bypass info)*/
 // decoder_W0_nr =
 // decoder_W1_nr =
 // decoder_W0_nr_bis =
 // decoder_W1_nr_bis =

    /* register unit --> xbar unit: */
    xbar_reg_R0 = reg_R0;
    xbar_reg_R1 = reg_R1;
    xbar_reg_R2 = reg_R2;

    /* decoder --> scheduler: */
    sch_need_r0_nr = decoder_need_r0_nr;
    sch_need_r1_nr = decoder_need_r1_nr;
    sch_need_r2_nr = decoder_need_r2_nr;
    sch_need_cycles= decoder_need_cycles;
    sch_need_w0_nr = decoder_need_w0_nr;
    sch_need_w1_nr = decoder_need_w1_nr;


    /* Xbar unit --> ASU EU: */
    asu_in_A = xbar_read_to_port_r0[ EU_type_ASU ] ;
    asu_in_B = xbar_read_to_port_r1[ EU_type_ASU ] ;
    /* decoder unit --> ASU EU: */
    asu_ADD = decoder_ADD;
    asu_SUB = decoder_SUB;
 //   asu_simd = decoder_simd;
 //   asu_size = decoder_size;
    /* Xbar unit --> INC EU: */
    /* Xbar unit --> ASU EU: */
  }

  /* Xbar unit --> register unit: */  
  reg_W0 = xbar_reg_W0; 
  reg_W1 = xbar_reg_W1;

  /* ASU EU --> Xbar unit */
  xbar_write_from_port[PORT_WRITE_FROM_ASU]  = asu_out0;
  xbar_write_from_port[PORT_WRITE_FROM_ASU2] = asu_out1;

}



  /* !!!!!!!! the following should be don by BIST !!!!!!!!!!! ????  */


void clear_all_units(void){
  int clear_reg_cnt;
  int clear_level_cnt;

  for (clear_reg_cnt=0;clear_reg_cnt<64;clear_reg_cnt++){
    register_value[clear_reg_cnt]=0;  
  }
  reg_nr_W0 = 0;  /* set all read and write ports to register 0x00 !?*/
  reg_nr_W1 = 0;
  reg_nr_R0 = 0;
  reg_nr_R1 = 0;
  reg_nr_R2 = 0;

  for (clear_level_cnt=0; clear_level_cnt<7; clear_level_cnt++){
    for (clear_reg_cnt=1; clear_reg_cnt<64; clear_reg_cnt++){
      register_in_use[clear_level_cnt][clear_reg_cnt] = false;
    }
  }

  inc_INC = false;
  inc_DEC = false;
  inc_ABS = false;
  inc_NEG = false;
  inc_LSB0 = false;
  inc_LSB1 = false;

  asu_ADD = false;
  asu_SUB = false;

  xbar_W0_nr = 0;
  xbar_W1_nr = 0;
  xbar_R0_nr = 0;
  xbar_R1_nr = 0;
  xbar_R2_nr = 0;
  xbar_EU_nr = 0;
  fet_ip = 0;
}

