/* 
  f-cpu/c/scheduler/scheduler_view.c
  shows status of scheduler unit for f-cpu simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

void scheduler_view(void){
  int reg_view_cnt;
  int level_view_cnt;
  printf("scoreboard:       ");
  for (reg_view_cnt=10;reg_view_cnt<64;reg_view_cnt++){
      if ( (reg_view_cnt % 10)==0 ){
        printf("%1i", reg_view_cnt / 10 );
      }else{    
        printf(" ");
      }
  }
  printf("  W W\n");

  printf("register:");
  for (reg_view_cnt=1;reg_view_cnt<64;reg_view_cnt++){
    printf("%1i", reg_view_cnt % 10 );
  }
  printf("  0 1\n");

  for (level_view_cnt=0;level_view_cnt<8;level_view_cnt++){
    printf("level %1i--",level_view_cnt);
    g();
    for (reg_view_cnt=1;reg_view_cnt<64;reg_view_cnt++){
      if ( register_in_use[level_view_cnt][reg_view_cnt]){
        printf("x");
      }else{    
        printf(".");
      }
    }
    n(); printf("  "); g();
    if ( write_bus_in_use[level_view_cnt][0]){ printf("x"); }else{ printf("."); }
    n(); printf(" "); g();
    if ( write_bus_in_use[level_view_cnt][1]){ printf("x"); }else{ printf("."); }
    n(); printf("\n");
  }

  printf("scheduler_stalled = "); print_true_false(scheduler_stalled);
  printf("\n");
}



