/*
  f-cpu/c/scheduler/scheduler.h - scheduler ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef SCHEDULER_H
#define SCHEDULER_H

#include <f-cpu_config.h>

#define true     1
#define false    0

/* inputs: */       /* information from decoder: */ 
u8 sch_need_r0_nr;  /* 0 = register not needed (register 0 dous not stall) */
u8 sch_need_r1_nr;  /* 0 = register not needed (register 0 dous not stall) */
u8 sch_need_r2_nr;  /* 0 = register not needed (register 0 dous not stall) */
u8 sch_need_cycles; /* needed cycles for execution (i.e. inc/dec=1 ) */
u8 sch_need_w0_nr;  /* needed result register nr (or 0) */
u8 sch_need_w1_nr;  /* needed result register nr (or 0) */

/* outputs: */
bool scheduler_stalled; /* pipeline is stalled (i.e registers not ready)*/
                        /* pipeline can only stall in one place ? */

/* internal: */
bool register_in_use[8][64]; /* register 0..63, 7 level deep FIFO */
bool write_bus_in_use[8][2]; /* writebus 0..1 , 7 level deep FIFO */

/* problem : they should be enums !! */

static inline void decoder_cycle(void);

#endif /* SCHEDULER_H */
