/* 
  f-cpu/c/scheduler/decoder.c
  c simulation of the F-CPU decoder unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--

--                /-------- decoder_op2   
--                | /------ decoder_op1  /------ decoder_W0_nr
--                | | /---- decoder_dst  | /---- decoder_W1_nr
--                | | |                  | |
--  decoder_instr | | |                  | |  /------ decoder_W0_nr_bis
--        |       | | |                  | |  | /---- decoder_W1_nr_bis
--        v       v v v                  v v  v v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                         decoder (first stage)                    %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--   |   | | |        |         |
--   |   | | |        |         \-- decoder_imm > 16 bit
--   |   | | |        |
--   |   | | |        \-- flags
--   |   | | |
--   |   | | \-- decoder_ADD > add instruction ( 1 cycle delaied for xbar )
--   |   | \---- decoder_SUB > sub instruction ( 1 cycle delaied for xbar )
--   |   \------ ...etc...
--   |  
--   \-- decoder_R0_nr  > 0..nr_of_read__ports_on_xbar-1
--   \-- decoder_R1_nr  > 0..nr_of_read__ports_on_xbar-1
--   \-- decoder_R2_nr  > 0..nr_of_read__ports_on_xbar-1
--   \-- decoder_EU_nr  >
--
-- decoder_op2 decoder_op1 decoder_dst are included in decoder_instr.
*/

/* defines the constants, inputs and outputs : */
#include <decoder.h>

static inline void decoder_cycle (void) {

u8   opcode;
bool imm_8bit;

  /* set imm: */  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  decoder_imm = (decoder_instr & 0x003FFFC0LL) >> 6 ;



  /* decode instruction: */  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  opcode = (decoder_instr & 0xFF000000LL) >> 24 ;
  imm_8bit = false;
  decoder_ADD = false;
  decoder_SUB = false;
  decoder_INC = false;
  decoder_DEC = false;
  decoder_R0_nr = 0;
  decoder_R1_nr = 0; /* 0 = none ? */
  decoder_R2_nr = 0;

  decoder_R0_nr=PORT_READ_FROM_REGISTER;
  decoder_R1_nr=PORT_READ_FROM_REGISTER;
  decoder_R2_nr=PORT_READ_FROM_REGISTER;

  decoder_need_r0_nr = 0;
  decoder_need_r1_nr = 0;
  decoder_need_r2_nr = 0;
  decoder_need_cycles= 0;
  decoder_need_w0_nr = 0;
  decoder_need_w1_nr = 0;

  if ( opcode==OP_INC ) {
    decoder_INC=true;
    decoder_EU_nr=EU_type_INC;
  }
  if ( opcode==OP_DEC ) {
    decoder_DEC=true;
    decoder_EU_nr=EU_type_INC;
  }
  if ( opcode==OP_ADD ) {
    decoder_ADD=true;
    decoder_EU_nr=EU_type_ASU;

    decoder_need_r0_nr = decoder_op1;
    decoder_need_r1_nr = decoder_op2;
    decoder_need_r2_nr = 0;
    decoder_need_cycles= 2; /* 1 cycle for 8 bit !, look at flags here ! */
    decoder_need_w0_nr = decoder_dst;
    decoder_need_w1_nr = 0; /* or decoder_dst+1 for carry */
    if (decoder_need_w1_nr==64){
      /* do not write carry (change flags!), or execute exeption ?? */
    }
  }
  if ( opcode==OP_ADDI ) {
    decoder_ADD=true;
    decoder_R0_nr=PORT_READ_FROM_REGISTER;
    decoder_R1_nr=PORT_READ_FROM_IMMEDIATE;
    decoder_EU_nr=EU_type_ASU;
  }
  if ( opcode==OP_SUB ) {
    decoder_SUB=true;
    decoder_EU_nr=EU_type_ASU;
  }
  if ( opcode==OP_SUBI ) {
    decoder_SUB=true;
    decoder_R0_nr=PORT_READ_FROM_REGISTER;
    decoder_R1_nr=PORT_READ_FROM_IMMEDIATE;
    decoder_EU_nr=EU_type_ASU;
  }

  /* check if bypas is needed: */  
  /* WARNING: operand 3 != destination !!?? (use buddy register (XOR 0x01) ) */
  /* WARNING: no bypass if register nr == 0 ?? */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( decoder_op1 == decoder_W0_nr ) decoder_R0_nr = PORT_READ_FROM_BYPASS_0;
  if ( decoder_op1 == decoder_W1_nr ) decoder_R0_nr = PORT_READ_FROM_BYPASS_1;
  if ( decoder_op2 == decoder_W0_nr ) decoder_R1_nr = PORT_READ_FROM_BYPASS_0;
  if ( decoder_op2 == decoder_W1_nr ) decoder_R1_nr = PORT_READ_FROM_BYPASS_1;
  if ( decoder_dst == decoder_W0_nr ) decoder_R2_nr = PORT_READ_FROM_BYPASS_0;
  if ( decoder_dst == decoder_W1_nr ) decoder_R2_nr = PORT_READ_FROM_BYPASS_1;
  /* check if delayed bypas is needed: */  
  if ( decoder_op1 == decoder_W0_nr_bis ) decoder_R0_nr = PORT_READ_FROM_BYPASS_0_BIS;
  if ( decoder_op1 == decoder_W1_nr_bis ) decoder_R0_nr = PORT_READ_FROM_BYPASS_1_BIS;
  if ( decoder_op2 == decoder_W0_nr_bis ) decoder_R1_nr = PORT_READ_FROM_BYPASS_0_BIS;
  if ( decoder_op2 == decoder_W1_nr_bis ) decoder_R1_nr = PORT_READ_FROM_BYPASS_1_BIS;
  if ( decoder_dst == decoder_W0_nr_bis ) decoder_R2_nr = PORT_READ_FROM_BYPASS_0_BIS;
  if ( decoder_dst == decoder_W1_nr_bis ) decoder_R2_nr = PORT_READ_FROM_BYPASS_1_BIS;
  /* we still do a bypass, even if we 2nd or 3rd operand is not needed !? */



  /* correct imm if it's 8 bit: */  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if ( imm_8bit ) {
    decoder_imm = (decoder_instr & 0x000FF000LL) >> 12 ;
  }
  
 
}







