/*
  f-cpu/c/registers/registers.h - ASU register ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30
  version: Sat Jul 20 19:58:01 CEST 2002 : YG added ports
  version:     Jul 21 02:06:00 CEST 2002 : JWS separated inputs / outputs

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#ifndef REGISTERS_H
#define REGISTERS_H

#include <f-cpu_config.h>

/* inputs: */
UMAX reg_W0;    /* 2 write ports */
UMAX reg_W1;
u8   reg_nr_W0; /* 2 write ports addresses */
u8   reg_nr_W1;
u8   reg_nr_R0; /* 3 read ports addresses */
u8   reg_nr_R1;
u8   reg_nr_R2;

/* outputs: */
UMAX reg_R0;    /* 3 read ports */
UMAX reg_R1;
UMAX reg_R2;
bool reg_ZERO;  /* the 4 flags */
bool reg_MSB;
bool reg_LSB;
bool reg_FP;
u8   reg_align;

/* internal: */
UMAX register_value[64];
  /* register_value[0] should never be addressed/used/written to */

static inline void cycle_registers (void);

#endif /* REGISTERS_H */
