/* 
  f-cpu/c/fcpusim/fcpusim.c - F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30
  version:     Jul 21 02:26:00 CEST 2002 : JWS extracted from old fcpusim.c

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

#include <toplevel.c>
#include <getkey.c>

#include <fetcher_view.c>
#include <registers_view.c>
#include <scheduler_view.c>
#include <xbar_view.c>
#include <eu_inc_view.c>
#include <eu_asu_view.c>

void g(void){
  /* if (use_colors){ */
  printf("%c[1;33;44m",0x1B);
}

void n(void){
  /* if (use_colors){ */
  printf("%c[0;37;40m",0x1B);
}

void print_true_false( bool print_treu_false_input ){
  g();
  if ( print_treu_false_input ){
    printf("True ");
  }else{
    printf("False");
  }
  n();
}

void status_view(void){
  printf("\n");
  printf("________________________________________");
  printf("_______________________________________\n");
  printf("status after cycle ");
  g(); printf("%d" , cycle_counter); n();
  printf(" :\n");
  if (view == "f"){ fetcher_view(); }
  if (view == "r"){ registers_view(); }
  if (view == "s"){ scheduler_view(); }
  if (view == "x"){ xbar_view(); }
  if (view == "a"){ eu_asu_view(); }
  if (view == "i"){ eu_inc_view(); }
}

void menu(void){
  int do_next_cycle;
  do {
    status_view();
    printf("Fetcher Registers Scheduler Xbar Asu Inc <enter>=next_cycle Quit ");
    c = getkey();
    printf( "\n" );
    do_next_cycle = 0;
    if  (c==10 )           { do_next_cycle = 1; }
    if ((c=='f')|(c=='F')) { view = "f"; } /* fetcher */
    if ((c=='r')|(c=='R')) { view = "r"; } /* registers */
    if ((c=='s')|(c=='S')) { view = "s"; } /* scheduler */
    if ((c=='x')|(c=='X')) { view = "x"; } /* xbar */
    if ((c=='a')|(c=='A')) { view = "a"; } /* asu */
    if ((c=='i')|(c=='I')) { view = "i"; } /* inc */
    if ((c=='q')|(c=='Q')) { quit_fcpusim = 1; do_next_cycle = 1; }
//  if (c>' ') { scanf("%c",&c); } /* enter after command */
  } while (do_next_cycle==0);
}


int main(int argc, char **argv) {

  printf("\n\n\n\n\n");
  printf("       F-CPU Simulator      (GNU General Public License)\n");
  printf(" (c) Yann GUIDON (YG) whygee@f-cpu.org\n");
  printf(" (c) Jaap Stolk (JWS) jwstolk@yahoo.com\n");
  printf(" (C) Thomas Geroudet  gertom_fcpu@yahoo.fr\n");
  printf("\n");
  printf("WARNING: only some parts work !!  read jaap.txt and source :-) \n");
  printf("\n");

  quit_fcpusim = 0;

  /* now lets see if this CPU runs! */
  cycle_counter=0;

  printf("starting BIST ...(just enter \"0\"(=NOP) for these 5 instructions)\n"); 
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  printf("... Done BIST.\n");

  /* fill the registers by hand, as we do not have a LOAD yet.. */
  /* (this will not take a cycle, as no cycle is simulated) */
  register_value[10] = 0x0012312312312312ll;  
  register_value[20] = 0x0001231231231231ll;  

  printf("                                  try this one: add r10,r20,r30 = 0x%8X \n",
       (OP_ADD << 24) | (10 << 12) | (20 << 6) | (30) ); 

  /* keep running !: */
  do {
    simulate_one_cycle(); cycle_counter++;
    menu();
  } while (quit_fcpusim == 0);


}
