/*
  f-cpu/c/eu_asu/eu_asu.h - ASU Execution Unit ports for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Sat Jul 13 22:22:00 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef EU_ASU_H
#define EU_ASU_H

#include <f-cpu_config.h>

#define SIMD_MAX 0 /* move this to configure ! */
#define SIMD_32  1
#define SIMD_16  2
#define SIMD_8   3
#define true     1
#define false    0

/* inputs and outputs : */

/* external FF of ASI EU: */
UMAX ASU_in_A;   /* the 2 operands */
UMAX ASU_in_B;
UMAX ASU_out;    /* the result */
bool ASU_ADD;
bool ASU_SUB;
bool ASU_wrcarry;
/* write_carry to next register */
bool ASU_simd;
u8   ASU_size;

/* internal FF between stages: */
UMAX tmp_ASU_in_A; /*mayby some more bits for carrys etc. */
UMAX tmp_ASU_in_B; /*mayby some more bits for carrys etc. */
bool tmp_ASU_ADD;
bool tmp_ASU_SUB;
bool tmp_ASU_wrcarry;
bool tmp_ASU_simd;
u8   tmp_ASU_size;

/* problem : they should be enums !! */

static inline void cycle_asu (void);

#endif /* EU_ASU_H */
