/* 
  f-cpu/c/eu_asu/eu_asu.c - ASU Execution Unit for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version Sat Jul 13 22:22:00 CEST 2002 : first test

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
--
--   /---------- ASU_AND     > std_ulogic
--   | /-------- ASU_SUB     > std_ulogic
--   | | /------ ASU_wrcarry > std_ulogic
--   | | | /---- ASU_simd    > std_ulogic
--   | | | | /-- ASU_size    > SIMD_8 / SIMD_16 / SIMD_32 / SIMD_MAX
--   | | | | |
--   | | | | |                          ASU_in_A       ASU_in_B
--   | | | | |                             |              |
--   v v v v v                             v              v
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- %%                        ASU EU stage 1                            %%
-- %%                   do: 8 bit SIMD ADD / SUB  (MAC?)               %%
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--   | | | | |   tmp_ASU_ADD       :       |              |           |
--   | | | | |   tmp_ASU_SUB       :       |              |           |
--   | | | | |   tmp_ASU_wrcarry   ?  tmp_ASU_in_A   tmp_ASU_in_B     |
--   | | | | |   tmp_ASU_simd      :       |              |           |
--   v v v v v   tmp_ASU_size      v       v              v           |
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% |
-- %%               ASU EU stage 2 (only for > 8bit !)             %% |
-- %%      finish 16 / 32 bit SIMD and 64 bit ADD / SUB (MAC?)     %% |
-- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% |
--                           |                                    |   |
--                           v                                    v   v
--                     ASU_carray_out                            ASU_out
--
-- if non-simd+8_bit posible ??
-- add reset signal ??
-- FIXME: we need to enable / disable each stage for writeing to ASU-out
--        to prevent write conflict. ?? (look at SIMD_8bit signal!?)
--     Q: Can we check the high bits for 0, and do 64 bit in 1 stage ?
--        ( 2 - 4 = -2   in one stage ? )
*/

/* defines the constants, inputs and outputs : */
#include <eu_asu.h>

static inline void cycle_asu (void) {

UMAX ASU_result; 

  /* ASU EU stage 2 (only for > 8bit !) (run this BEFORE stage 1!) */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if (tmp_ASU_ADD){
    ASU_result = tmp_ASU_in_A + tmp_ASU_in_B;
  }else{

    if (tmp_ASU_SUB){
      ASU_result = tmp_ASU_in_A - tmp_ASU_in_B;
    }

  }

  if (tmp_ASU_ADD | tmp_ASU_SUB){
    ASU_out = ASU_result;
  }
  /* SIMD version not yet implemented !! */
  /* carry not implemented !! */


  /* ASU EU stage 1 */
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  if (ASU_size==SIMD_8){
    /* do it all in one stage, and skip the next: */
    if (ASU_ADD){
      ASU_result  = tmp_ASU_in_A + tmp_ASU_in_B;
      tmp_ASU_ADD = false;  /* skip the next stage */
    }
    if (ASU_SUB){
      ASU_result  = tmp_ASU_in_A - tmp_ASU_in_B;
      tmp_ASU_SUB = false;  /* skip the next stage */
    }
    if (ASU_ADD | ASU_SUB){
      ASU_out = ASU_result;
    }
  }else{
    /* we need two stages to do this: */
    tmp_ASU_in_A   = ASU_in_A;
    tmp_ASU_in_B   = ASU_in_B;
    tmp_ASU_ADD    = ASU_ADD;
    tmp_ASU_SUB    = ASU_SUB;
    tmp_ASU_wrcarry= ASU_wrcarry;
    tmp_ASU_simd   = ASU_simd;
    tmp_ASU_size   = ASU_size;
  }

  if ( !(ASU_ADD | ASU_SUB) ){
      tmp_ASU_ADD = false;  /* clear ASU pipeline */
      tmp_ASU_SUB = false;  /* clear ASU pipeline */
  }
}
