f-cpu/configuration/opcodes.m4
created Sun Aug 19 17:54:28 2001 by whygee@f-cpu.org
adapted from :
   f-cpu/include/f-cpu_opcodes.h
   created Sat Jul 14 23:26:36 2001 by whygee@f-cpu.org
Mon Jul 29 02:29:33 CEST 2002 JWS: added some INC and ASU opcodes.

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

********************WARNING!************************
This file contains the definition of the opcode
values, reflecting the most recent work.
All thes values are subject to changes.
They operate on 8-bit values that may be contiguous
(and must, in some cases). The #defines will be
optimized and reorganised later. Don't rely on their
values !!!
****************************************************

check if the necessary files are already processed :
m4_ifdef(`__DEF_OP_FUNCTION_AND',
  `m4_errprint(`
 `__DEF_OP_FUNCTION_AND' is not yet included.
 Please include the necessary file.
')')


##################### MOVE #####################

  "do nothing" (split from (c)move) :

m4_define(`__DEF_OP_NOP',	`0')
m4_define(`__DEF_OP_MOV',	`1')
m4_define(`__DEF_OP_CMOV',	`2')

 (5 opcodes left here)

 these 2 opcodes require a 4-bit shift field, but 2 only are
 available from the flag field so we use 2 LSB from the opcode.
 We need 8 opcodes for these 2 :

m4_define(`__DEF_OP_LOADCONS',	`8')
m4_define(`__DEF_OP_LOADCONSX',	`m4_eval(__DEF_OP_LOADCONS | 4)')


##################### ROP2 #####################

  ROP2 uses a 3-bit field in the opcode => 8 opcodes.
  MUX and COMBINE overlap this 8-opcode field, too, but
  only a specific opcode is legal for MUX :

m4_define(`__DEF_OP_ROP2',	`16')
m4_define(`__DEF_OP_MUX',	`__DEF_OP_ROP2')
m4_define(`__DEF_OP_AND',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_AND)')
m4_define(`__DEF_OP_ANDN',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_ANDN)')
m4_define(`__DEF_OP_XOR',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_XOR)')
m4_define(`__DEF_OP_OR',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_OR)')
m4_define(`__DEF_OP_NOR',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_NOR)')
m4_define(`__DEF_OP_XNOR',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_XNOR)')
m4_define(`__DEF_OP_ORN',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_ORN)')
m4_define(`__DEF_OP_NAND',	`m4_eval(__DEF_OP_ROP2 | __DEF_FUNCTION_NAND)')

  imm8 eats the useful mode bits : we can't encode MUX or COMBINE
  with immediate data, MUXI is not possible.

m4_define(`__DEF_OP_ROP2I',	`m4_eval(__DEF_OP_ROP2 | 8)')
m4_define(`__DEF_OP_ANDI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_AND)')
m4_define(`__DEF_OP_ANDNI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_ANDN)')
m4_define(`__DEF_OP_XORI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_XOR)')
m4_define(`__DEF_OP_ORI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_OR)')
m4_define(`__DEF_OP_NORI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_NOR)')
m4_define(`__DEF_OP_XNORI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_XNOR)')
m4_define(`__DEF_OP_ORNI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_ORN)')
m4_define(`__DEF_OP_NANDI',	`m4_eval(__DEF_OP_ROP2I | __DEF_FUNCTION_NAND)')

##################### ... #####################

  !! WARNING !! that's only for early tests, it will be changed later
  (the opcodes belong to different, unfinished units)

m4_define(`__DEF_OP_INC',   `100')
m4_define(`__DEF_OP_DEC',   `101')
m4_define(`__DEF_OP_INCI',  `102')
m4_define(`__DEF_OP_DECI',  `103')
m4_define(`__DEF_OP_ADD',   `104')
m4_define(`__DEF_OP_SUB',   `105')
m4_define(`__DEF_OP_ADDI',  `106')
m4_define(`__DEF_OP_SUBI',  `107')
m4_define(`__DEF_OP_MUL',   `108')
