/* 
  f-cpu/c/eu_imu/eu_imu.c - IMU Execution Unit for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 
Sun Jul 28 12:30:01 CEST 2002 JWS: created
Mon Jul 29 15:08:32 CEST 2002 JWS: added cycle and view

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
   size:      low output:  high output:
             (latencu_w0) (latencu_w1)
   8 bit          3           4
  16 bit          4           5
  32 bit          5           5
  64 bit          6           6

 the simulator dous the whole comutation in the first cycle,
 and delays the output(s).
 the 64bit * 64bit = 128bit  is done in 32bit blocks.
 no simd support yet !!
*/

/* defines the constants, inputs and outputs : */
#include <eu_imu.h>

void eu_imu_view(void){
  printf("IMU EU inputs:\n");
  printf("imu_in_A   = %s%16llX%s  ", display_color, imu_in_A, display_normal );
  printf("imu_in_B   = %s%16llX%s\n", display_color, imu_in_B, display_normal );
  printf("imu_size   = %s%d%s\n",     display_color, imu_size, display_normal );
  printf("imu_simd   = %s\n",         display_bool[imu_simd] );
  printf("imu_high   = %s\n",         display_bool[imu_high] );
  printf("IMU EU outputs:\n");
  printf("imu_out0   = %s%16llX%s  ", display_color, imu_out0, display_normal );
  printf("imu_out1   = %s%16llX%s\n", display_color, imu_out1, display_normal );
}

static inline void eu_imu_cycle(void) {

  UMAX low;
  UMAX hig;

  imu_out_low[LAT_IMU_64_H-1] = 0;
  imu_out_hig[LAT_IMU_64_H-1] = 0;

  switch ( imu_size ) {
    case SIMD_MAX:
      /* A_low * B_low: */
      low = (imu_in_A & 0x00000000FFFFFFFFll) * (imu_in_B & 0x00000000FFFFFFFFll);
      imu_out_low[LAT_IMU_64_L-1] = low;
      /* A_hig * B_hig: */
      hig = ((imu_in_A & 0xFFFFFFFF00000000ll) >> 32) * ((imu_in_B & 0xFFFFFFFF00000000ll) >> 32);
      imu_out_hig[LAT_IMU_64_H-1] = hig;
      /* A_hig * B_low: */
      low = ((imu_in_A & 0xFFFFFFFF00000000ll) >> 32) * (imu_in_B & 0x00000000FFFFFFFFll);
      hig =  (low & 0xFFFFFFFF00000000ll) >> 32 ;
      low =  (low & 0x00000000FFFFFFFFll) << 32 ;
      if ( (imu_out_low[LAT_IMU_64_L-1] & 0x8000000000000000ll) && (low & 0x8000000000000000ll)){
        imu_out_hig[LAT_IMU_64_H-1] += 1;
      }
      imu_out_low[LAT_IMU_64_L-1] += low;
      imu_out_hig[LAT_IMU_64_H-1] += hig;
      /* A_low * B_hig: */
      low =  (imu_in_A & 0x00000000FFFFFFFFll) * ((imu_in_B & 0xFFFFFFFF00000000ll) >> 32);
      hig =  (low & 0xFFFFFFFF00000000ll) >> 32 ;
      low =  (low & 0x00000000FFFFFFFFll) << 32 ;
      if ( (imu_out_low[LAT_IMU_64_L-1] & 0x8000000000000000ll) && (low & 0x8000000000000000ll)){
        imu_out_hig[LAT_IMU_64_H-1] += 1;
      }
      imu_out_low[LAT_IMU_64_L-1] += low;
      imu_out_hig[LAT_IMU_64_H-1] += hig;
    break;
    case SIMD_32:
      low = (imu_in_A & 0x00000000FFFFFFFFll) * (imu_in_B & 0x00000000FFFFFFFFll);
      hig = (low & 0xFFFFFFFF00000000ll) >> 32;
      low =  low & 0x00000000FFFFFFFFll ;
      imu_out_low[LAT_IMU_32_L-1] = low;
      imu_out_hig[LAT_IMU_32_H-1] = hig;
    break;
    case SIMD_16:
      low = (imu_in_A & 0x000000000000FFFFll) * (imu_in_B & 0x000000000000FFFFll);
      hig = (low & 0x00000000FFFF0000ll) >> 16;
      low =  low & 0x000000000000FFFFll ;
      imu_out_low[LAT_IMU_16_L-1] = low;
      imu_out_hig[LAT_IMU_16_H-1] = hig;
    break;
    case SIMD_8:
      low = (imu_in_A & 0x00000000000000FFll) * (imu_in_B & 0x00000000000000FFll);
      hig = (low & 0x000000000000FF00ll) >> 8;
      low =  low & 0x00000000000000FFll ;
      imu_out_low[LAT_IMU_8_L -1] = low;
      imu_out_hig[LAT_IMU_8_H -1] = hig;
    break;
  }

  /* delay output: */
  imu_out0 = imu_out_low[0];
  imu_out1 = imu_out_hig[0];
  for (low=0; low<(LAT_IMU_64_H-1); low++){
    imu_out_low[low] = imu_out_low[low+1]; 
    imu_out_hig[low] = imu_out_hig[low+1];
  }

}
