--------------------------------------------------------------------------
-- f-cpu/vhdl/eu_rop2/test_rop2.vhdl - Yet Another ROP2 Testbench for the F-CPU
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
--
-- created sam dec  1 05:17:51 GMT 2001
-- version jeu dec  6 17:35:53 GMT 2001
-- version lun dec 10 02:33:00 GMT 2001 : added rand() and explicit functional
--    testing. Missing : logarithmic vector generation but rand() is enough now.
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- This is a little testbench for the ROP2 set of units. Nothing wonderful
-- but this one should work with Vanilla and require less efforts to
-- understand (than the first one), since the parser has been removed :-)
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text I/O
    use IEEE.std_logic_textio.all;
    use std.textio.all;
-- local functions
LIBRARY work;
    USE work.FCPU_config.ALL;
    USE work.eu_rop2_xbar;
    USE work.eu_rop2;
    USE work.random.all;


Entity test_rop2 is
  -- empty : no external connexion.
end test_rop2;

Architecture arch1 of test_rop2 is

  component eu_rop2_xbar
    port (
      ROP2_function : in Std_ulogic_vector(2 downto 0);
      ROP2_function_bit0,
      ROP2_function_bit1,
      ROP2_function_bit2,
      ROP2_function_bit3 : out Std_ulogic_vector((MAXSIZE *2)-1 downto 0)
    );
  end component;

  component eu_rop2
    port (
      ROP2_in_A,
      ROP2_in_B,
      ROP2_in_C : in F_VECTOR;
      ROP2_function_bit0,
      ROP2_function_bit1,
      ROP2_function_bit2,
      ROP2_function_bit3 : in Std_ulogic_vector((MAXSIZE *2)-1 downto 0);
      ROP2_mode : in Std_ulogic_vector(1 downto 0);
      ROP2_out : out F_VECTOR
    );
  end component;

  signal l_ROP2_function : Std_ulogic_vector(2 downto 0);
  signal l_ROP2_function_bit0, l_ROP2_function_bit1, l_ROP2_function_bit2,
    l_ROP2_function_bit3 : Std_ulogic_vector((MAXSIZE *2)-1 downto 0);
  signal l_ROP2_in_A, l_ROP2_in_B, l_ROP2_in_C, l_ROP2_out : F_VECTOR;
  signal l_ROP2_mode : Std_ulogic_vector(1 downto 0);

begin   --  arch1 of test_rop2

-- Components under test :
  xbar: component eu_rop2_xbar port map (
      ROP2_function => l_ROP2_function,
      ROP2_function_bit0 => l_ROP2_function_bit0,
      ROP2_function_bit1 => l_ROP2_function_bit1,
      ROP2_function_bit2 => l_ROP2_function_bit2,
      ROP2_function_bit3 => l_ROP2_function_bit3
  );

  rop2: component eu_rop2 port map (
      ROP2_in_A => l_ROP2_in_A,
      ROP2_in_B => l_ROP2_in_B,
      ROP2_in_C => l_ROP2_in_C,
      ROP2_function_bit0 => l_ROP2_function_bit0,
      ROP2_function_bit1 => l_ROP2_function_bit1,
      ROP2_function_bit2 => l_ROP2_function_bit2,
      ROP2_function_bit3 => l_ROP2_function_bit3,
      ROP2_mode  => l_ROP2_mode,
      ROP2_out => l_ROP2_out
    );

-- test vectors :
  testbench : process is
    variable k : integer;
    variable lout : line;

    -- this helps keep the code short :
    procedure step_vector (
      mode           : Std_ulogic_vector(2 downto 0);
      expected_value : F_VECTOR) is
    begin  -- step_vector
      l_ROP2_function <= mode;
      wait for 1 ns;
      write(lout, string'(" mode : "));
      write(lout, mode);
      write(lout, string'(" out:"));
      write(lout, l_ROP2_out);
      writeline(output, lout);
      if l_ROP2_out /= expected_value then
        write(lout, string'("     expected : "));
        write(lout, expected_value);
        writeline(output, lout);
        write(lout, string'(" ***************  ERROR !!! ***************** "));
        writeline(output, lout);
        wait for 1 ns;
        assert l_ROP2_out = expected_value
          report "unexpected result"
          severity FAILURE;
      end if;
      wait for 1 ns;
    end step_vector;

    function combine_and (
      data : F_VECTOR)
    return Std_ulogic_vector is
      variable t : F_VECTOR := (others => '0');
      variable i : natural;
    begin
      for i in 0 to MAXSIZE-1 loop
        if data((i*8)+7 downto i*8)  = X"FF" then
              t((i*8)+7 downto i*8) := X"FF";
        end if;
      end loop;  -- i
      return t;
    end;

    function combine_or (
      data : F_VECTOR)
    return Std_ulogic_vector is
      variable t : F_VECTOR := (others => '0');
      variable i : natural;
    begin
      for i in 0 to MAXSIZE-1 loop
        if data((i*8)+7 downto i*8) /= X"00" then
              t((i*8)+7 downto i*8) := X"FF";
        end if;
      end loop;  -- i
      return t;
    end;


  begin
    for k in 0 to 3 loop 
       -- as much as your paranoia, before a cleaner solution is designed

      l_ROP2_in_A <= rand(l_ROP2_in_A);
      l_ROP2_in_B <= rand(l_ROP2_in_B);  -- sorry, no time to do something else.
      l_ROP2_in_C <= rand(l_ROP2_in_C);  -- stay tuned.

-- break this glas in case of emergency :
--      l_ROP2_in_A <= X"5555555555555555";
--      l_ROP2_in_B <= X"3333333333333333";
--      l_ROP2_in_C <= X"FEDCBA9876543210";

      wait for 1 ns;
      writeline(output, lout);
      write(lout, string'("A = "));
      write(lout, l_ROP2_in_A);
      writeline(output, lout);
      write(lout, string'("B = "));
      write(lout, l_ROP2_in_B);
      writeline(output, lout);
      write(lout, string'("C = "));
      write(lout, l_ROP2_in_C);
      writeline(output, lout);

--    test the MUX
      l_ROP2_mode <= ROP2_MUX_MODE;
      write(lout, string'(" * MUX mode"));
      writeline(output, lout);
      wait for 1 ns;
      write(lout, string'("  out="));
      write(lout, l_ROP2_out);
      writeline(output, lout);

      assert l_ROP2_out = ((l_ROP2_in_C  and l_ROP2_in_B)
                   or (not(l_ROP2_in_C) and l_ROP2_in_A))
        report "unexpected result"
        severity FAILURE;
      wait for 1 ns;

--    ROP2 in "Direct mode" :

      l_ROP2_mode <= ROP2_DIRECT_MODE;
      write(lout, string'(" * Direct mode"));
      writeline(output, lout);
      step_vector(ROP2_AND ,     l_ROP2_in_A and     l_ROP2_in_B);
      step_vector(ROP2_ANDN,     l_ROP2_in_A and not(l_ROP2_in_B));
      step_vector(ROP2_XOR ,     l_ROP2_in_A xor     l_ROP2_in_B);
      step_vector(ROP2_OR  ,     l_ROP2_in_A or      l_ROP2_in_B);
      step_vector(ROP2_NOR , not(l_ROP2_in_A or      l_ROP2_in_B));
      step_vector(ROP2_XNOR, not(l_ROP2_in_A xor     l_ROP2_in_B));
      step_vector(ROP2_ORN ,     l_ROP2_in_A or  not(l_ROP2_in_B));
      step_vector(ROP2_NAND, not(l_ROP2_in_A and     l_ROP2_in_B));

--    ROP2 in "Combine AND mode" :

      l_ROP2_mode <= ROP2_AND_MODE;
      write(lout, string'(" * Combine AND mode"));
      writeline(output, lout);
      step_vector(ROP2_AND , combine_and(     l_ROP2_in_A and     l_ROP2_in_B));
      step_vector(ROP2_ANDN, combine_and(     l_ROP2_in_A and not(l_ROP2_in_B)));
      step_vector(ROP2_XOR , combine_and(     l_ROP2_in_A xor     l_ROP2_in_B));
      step_vector(ROP2_OR  , combine_and(     l_ROP2_in_A or      l_ROP2_in_B));
      step_vector(ROP2_NOR , combine_and( not(l_ROP2_in_A or      l_ROP2_in_B)));
      step_vector(ROP2_XNOR, combine_and( not(l_ROP2_in_A xor     l_ROP2_in_B)));
      step_vector(ROP2_ORN , combine_and(     l_ROP2_in_A or  not(l_ROP2_in_B)));
      step_vector(ROP2_NAND, combine_and( not(l_ROP2_in_A and     l_ROP2_in_B)));

--    ROP2 in "Combine OR mode" :

      l_ROP2_mode <= ROP2_OR_MODE;
      write(lout, string'(" * Combine OR mode"));
      writeline(output, lout);
      step_vector(ROP2_AND , combine_or(     l_ROP2_in_A and     l_ROP2_in_B));
      step_vector(ROP2_ANDN, combine_or(     l_ROP2_in_A and not(l_ROP2_in_B)));
      step_vector(ROP2_XOR , combine_or(     l_ROP2_in_A xor     l_ROP2_in_B));
      step_vector(ROP2_OR  , combine_or(     l_ROP2_in_A or      l_ROP2_in_B));
      step_vector(ROP2_NOR , combine_or( not(l_ROP2_in_A or      l_ROP2_in_B)));
      step_vector(ROP2_XNOR, combine_or( not(l_ROP2_in_A xor     l_ROP2_in_B)));
      step_vector(ROP2_ORN , combine_or(     l_ROP2_in_A or  not(l_ROP2_in_B)));
      step_vector(ROP2_NAND, combine_or( not(l_ROP2_in_A and     l_ROP2_in_B)));
    end loop;  -- k
    wait;  -- stop the simulation counter.
  end process;

end;   --  arch1 of test_rop2
