;;- Machine description for GNU compiler, F-CPU, devik@cdi.cz


;;- Instruction patterns.  When multiple patterns apply,
;;- the first one in the file is chosen.
;;-
;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.
;;-
;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

(define_attr "type"
   "other,add,loadcons,move"
     (const_string "other"))

(define_insn "addhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (plus:HI (match_operand:HI 1 "register_operand" "r,r")
		  (match_operand:HI 2 "regimm8_operand" "r,i")))]
  ""
  "@
  add.d %1,%2,%0
  addi.d %c2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (plus:SI (match_operand:SI 1 "register_operand" "r,r")
		  (match_operand:SI 2 "regimm8_operand" "r,i")))]
  ""
  "@
  add.q %1,%2,%0
  addi.q %c2,%1,%0"
  [(set_attr "type" "add")])

(define_insn "adddi3"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (plus:DI (match_operand:DI 1 "register_operand" "r,r")
		  (match_operand:DI 2 "regimm8_operand" "r,i")))]
  ""
  "@
  add %2,%1,%0
  addi %c2,%1,%0"
  [(set_attr "type" "add")])

;;############# Compares
;; copy operands to temp vars
(define_expand "cmpdi"
 [(set (cc0) (compare (match_operand:DI 0 "general_operand" "")
		 (match_operand:DI 1 "general_operand" "")))]
 ""
 {
 fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE;
 })
(define_expand "cmphi"
 [(set (cc0) (compare (match_operand:HI 0 "general_operand" "")
		 (match_operand:HI 1 "general_operand" "")))]
 ""
 {
 fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE;
 })

(define_expand "beq"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (EQ); }")

(define_expand "bne"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (NE); }")

(define_expand "blt"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (LT); }")

(define_expand "ble"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (LE); }")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (GT); }")

(define_expand "bge"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (GE); }")

(define_expand "bltu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (LTU); }")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (LEU); }")

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (GTU); }")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (GEU); }")

(define_expand "bunordered"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (UNORDERED); }")

(define_expand "bordered"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "{ operands[1] = fcpu_emit_conditional_branch (ORDERED); }")

;; TODO: STORE_FLAG_VALUE ??
(define_insn "*cmpne"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (ne:DI (match_operand:DI 1 "register_operand" "r")
	  (match_operand:DI 2 "register_operand" "r")))]
 ""
 "xor %2,%1,%0")

(define_insn "*cmpleu"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (leu:DI (match_operand:DI 1 "register_operand" "r")
	  (match_operand:DI 2 "register_operand" "r")))]
 ""
 "cmple %2,%1,%0")

(define_insn "*cmplu"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (ltu:DI (match_operand:DI 1 "register_operand" "r")
	  (match_operand:DI 2 "register_operand" "r")))]
 ""
 "cmpl %2,%1,%0")

;; TODO: these two are not defined in fcpu !
(define_insn "*cmple"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (le:DI (match_operand:DI 1 "register_operand" "r")
	  (match_operand:DI 2 "register_operand" "r")))]
 ""
 "cmples %2,%1,%0")

(define_insn "*cmpl"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (lt:DI (match_operand:DI 1 "register_operand" "r")
	  (match_operand:DI 2 "register_operand" "r")))]
 ""
 "cmpls %2,%1,%0")

;; TODO: these two are not defined in fcpu !
(define_insn "*cmpleh"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (le:DI (match_operand:HI 1 "register_operand" "r")
	  (match_operand:HI 2 "register_operand" "r")))]
 ""
 "cmples.d %2,%1,%0")

(define_insn "*cmplh"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (lt:DI (match_operand:HI 1 "register_operand" "r")
	  (match_operand:HI 2 "register_operand" "r")))]
 ""
 "cmpls.d %2,%1,%0")

(define_insn "*condbrn"
 [(set (pc) (if_then_else (ne:CC (match_operand:DI 0 "register_operand" "r")
			 (const_int 0)) 
		 (match_operand:DI 1 "general_operand" "")
		 (pc)))]
 ""
 "jmp_direct_nz %0,%l1")
 
(define_insn "*condbr"
 [(set (pc) (if_then_else (eq:CC (match_operand:DI 0 "register_operand" "r")
			 (const_int 0)) 
		 (match_operand:DI 1 "general_operand" "")
		 (pc)))]
 ""
 "jmp_direct_z %0,%l1")

;;############# Constant block inserts (loadcons.N)

(define_insn "*loadcons0si"
 [(set (zero_extract:SI (match_operand:SI 0 "register_operand" "+r")
		 (const_int 16) (const_int 0))
	 (match_operand:SI 1 "immediate_operand" "i"))]
 ""
 "loadcons.0 %c1,%0")

(define_insn "*loadcons0di"
 [(set (zero_extract:DI (match_operand:DI 0 "register_operand" "+r")
		 (const_int 16) (const_int 0))
	 (match_operand:DI 1 "immediate_operand" "i"))]
 ""
 "loadcons.0 %c1,%0")

;; ############# Expanded moves; generates intermediates for memory
;; references and generates constant loads too

(define_expand "movqi" 
 [(set (match_operand:QI 0 "nonimmediate_operand" "")
       (match_operand:QI 1 "general_operand" ""))]
 ""
 "fcpu_expand_move (QImode, operands); DONE;")

(define_expand "movhi" 
 [(set (match_operand:HI 0 "nonimmediate_operand" "")
       (match_operand:HI 1 "general_operand" ""))]
 ""
 "fcpu_expand_move (HImode, operands); DONE;")

(define_expand "movsi" 
 [(set (match_operand:SI 0 "nonimmediate_operand" "")
       (match_operand:SI 1 "general_operand" ""))]
 ""
 "fcpu_expand_move (SImode, operands); DONE;")
 
(define_expand "movdi"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  "fcpu_expand_move (DImode, operands); DONE;")


;;############# Atomic moves

(define_insn "*movsi"
  [(set (match_operand:SI 0 "regmemzero_operand" "=r,m,r,r,m")
	(match_operand:SI 1 "regmemzero_operand" "r,r,m,i,i"))]
  ""
  "@
  move.q %1,%0
  store.q %0,%1
  load.q %1,%0
  move r0,%0
  store.q %0,r0")

(define_insn "*movdi"
  [(set (match_operand:DI 0 "regmemzero_operand" "=r,m,r,r,m")
	(match_operand:DI 1 "regmemzero_operand" "r,r,m,i,i"))]
  ""
  "@
  move %1,%0
  store %0,%1
  load %1,%0
  move r0,%0
  store %0,r0")

(define_insn "*movhi"
  [(set (match_operand:HI 0 "regmemzero_operand" "=r,m,r,r,m")
	(match_operand:HI 1 "regmemimm16_operand" "r,r,m,i,O"))]
  ""
  "@
  move.w %1,%0
  store.w %0,%1
  load.w %1,%0
  loadcons.0 %c1,%0
  store.w %0,r0")

(define_insn "*movqi"
  [(set (match_operand:QI 0 "regmemzero_operand" "=r,m,r,r,m")
	(match_operand:QI 1 "regmemimm8_operand" "r,r,m,i,O"))]
  ""
  "@
  move.b %1,%0
  store.b %0,%1
  load.b %1,%0
  loadcons.0 %c1,%0
  store.b %0,r0")

;;############# Loop
(define_expand "doloop_end"
 [(use (match_operand 0 "" ""))        ; loop pseudo
 (use (match_operand 1 "" ""))        ; iterations; zero if unknown
 (use (match_operand 2 "" ""))        ; max iterations
 (use (match_operand 3 "" ""))        ; loop level
 (use (match_operand 4 "" ""))]       ; label
 ""
 {
 emit_jump_insn (gen_doloop_end_internal (operands[4], operands[0],
		 operands[0]));
 DONE;
 })

(define_insn "doloop_end_internal"
  [(set (pc)
	(if_then_else (ne (match_operand:DI 1 "register_operand" "r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:DI 2 "register_operand" "=1")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:DI 3 "=X"))]
  ""
  "loop_direct %l0,%1")

;;############# Extending
(define_insn "extendsidi2"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (sign_extend:DI (match_operand:SI 1 "register_operand" "r")))]
 ""
 "widen %1,%0")
(define_insn "extendhidi2"
 [(set (match_operand:DI 0 "register_operand" "=r")
	 (sign_extend:DI (match_operand:HI 1 "register_operand" "r")))]
 ""
 "widen.d %1,%0")

;;############# Shifts
(define_insn "ashldi3"
 [(set (match_operand:DI 0 "register_operand" "=r,r")
	 (ashift:DI (match_operand:DI 1 "register_operand" "r,r")
	  (match_operand:QI 2 "regimm8_operand" "i,r")))]
 "" "@
 shiftil %c2,%1,%0
 shiftl %2,%1,%0")
(define_insn "ashlsi3"
 [(set (match_operand:SI 0 "register_operand" "=r,r")
	 (ashift:SI (match_operand:SI 1 "register_operand" "r,r")
	  (match_operand:QI 2 "regimm8_operand" "i,r")))]
 "" "@
 shiftil.q %c2,%1,%0
 shiftl.q %2,%1,%0")
(define_insn "ashlhi3"
 [(set (match_operand:HI 0 "register_operand" "=r,r")
	 (ashift:HI (match_operand:HI 1 "register_operand" "r,r")
	  (match_operand:QI 2 "regimm8_operand" "i,r")))]
 "" "@
 shiftil.d %c2,%1,%0
 shiftl.d %2,%1,%0")

;;############# Fallback constant loading using ASM macro
(define_insn "*bigconstdi"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(match_operand:DI 1 "bigimm_operand" "M,i"))]
  ""
  "@
  bseti log2(%c1),r0,%0
  loadcons %c1,%0"
  [(set_attr "type" "loadcons")])

;;(define_expand "jump"
;; [(set (match_dup 1) (label_ref (match_operand:QI 0 "" "")))
;;  (set (pc) (match_dup 1))]
;;  ""
;;  "operands[1]=gen_reg_rtx(Pmode);")

;; TODO: how to replace it with indirect jump ??
(define_insn "jump"
 [(set (pc) (label_ref (match_operand 0 "" "")))]
  ""
  "jmp_direct %l0")
   
(define_insn "indirect_jump"
  [(set (pc) (match_operand:QI 0 "register_operand" "r"))]
  ""
  "jmp %0")

(define_insn "nop" [(const_int 0)] "" "nop")

(define_expand "call"
  [(call (match_operand:QI 0 "memory_operand" "m") (match_operand:QI 1 "" ""))
  (clobber (reg:DI 63))]
  ""
  "operands[0]=force_reg(Pmode,XEXP(operands[0],0));")

(define_insn "*call"
  [(call (match_operand:DI 0 "register_operand" "r")
	 (match_operand:QI 1 "general_operand" "g"))]
  ""
  "jmp %0,ra")

(define_expand "call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:QI 1 "memory_operand" "m")
	      (match_operand:QI 2 "general_operand" "g")))
  (clobber (reg:DI 63))]
  ""
  "operands[1]=force_reg(Pmode,XEXP(operands[1],0));")

(define_insn "*call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:DI 1 "register_operand" "r")
	      (match_operand:QI 2 "general_operand" "g")))]
  ""
  "jmp %1,ra")

(define_function_unit "adder" 1 0 
 (eq_attr "type" "add") 3 0)
(define_function_unit "loadcons" 1 0
 (eq_attr "type" "loadcons") 0 4)
(define_function_unit "move" 1 0
 (eq_attr "type" "move") 0 4)
(define_function_unit "other" 1 0
 (eq_attr "type" "other") 0 2)
