/* Definitions of target machine for GNU compiler.  F-CPU version.
   devik@cdi.cz
 */

#include "config.h"
#include "system.h"
#include "rtl.h"
#include "function.h"
#include "output.h"
#include "tree.h"
#include "expr.h"
#include "regs.h"
#include "flags.h"
#include "hard-reg-set.h"
#include "tm_p.h"
#include "target.h"
#include "target-def.h"
#include "insn-config.h"
#include "recog.h"

extern const char *reg_names[];
rtx cmp_op0=0, cmp_op1=0;

/* table of relations for compares and branches */
static const char *const cmp_tab[] = {
    "gt", "gt", "eq", "eq", "ge", "ge", "lt", "lt", "ne", "ne",
    "le", "le" };

static bool elxsi_assemble_integer PARAMS ((rtx, unsigned int, int));
static void elxsi_output_function_prologue PARAMS ((FILE *, HOST_WIDE_INT));
static void elxsi_output_function_epilogue PARAMS ((FILE *, HOST_WIDE_INT));

/* Initialize the GCC target structure.  */
#undef TARGET_ASM_BYTE_OP
#define TARGET_ASM_BYTE_OP NULL
#undef TARGET_ASM_ALIGNED_HI_OP
#define TARGET_ASM_ALIGNED_HI_OP NULL
#undef TARGET_ASM_ALIGNED_SI_OP
#define TARGET_ASM_ALIGNED_SI_OP NULL
#undef TARGET_ASM_INTEGER
#define TARGET_ASM_INTEGER elxsi_assemble_integer

#undef TARGET_ASM_FUNCTION_PROLOGUE
#define TARGET_ASM_FUNCTION_PROLOGUE elxsi_output_function_prologue
#undef TARGET_ASM_FUNCTION_EPILOGUE
#define TARGET_ASM_FUNCTION_EPILOGUE elxsi_output_function_epilogue

struct gcc_target targetm = TARGET_INITIALIZER;

/* Target hook for assembling integer objects.  The ELXSI assembler
   syntax uses a suffix to indicate the size of data, so we can't use
   the usual string hooks.  */

static bool
elxsi_assemble_integer (x, size, aligned_p)
     rtx x;
     unsigned int size;
     int aligned_p;
{
  if (aligned_p)
    switch (size)
      {
      case 1:
      case 2:
      case 4:
	fputs ("\t.data\t", asm_out_file);
	output_addr_const (asm_out_file, x);
	fprintf (asm_out_file, "{%d}\n", size * BITS_PER_UNIT);
	return true;
      }
  return default_assemble_integer (x, size, aligned_p);
}

/* Generate the assembly code for function entry.  FILE is a stdio
   stream to output the code to.  SIZE is an int: how many units of
   temporary storage to allocate.

   Refer to the array `regs_ever_live' to determine which registers to
   save; `regs_ever_live[I]' is nonzero if register number I is ever
   used in the function.  This function is responsible for knowing
   which registers should not be saved even if used.  */

static void
elxsi_output_function_prologue (file, size)
     FILE *file;
     HOST_WIDE_INT size;
{
  register int regno;
  register int cnt = 0;

  /* the below two lines are a HACK, and should be deleted, but
     for now are very much needed (1.35) */
  if (frame_pointer_needed)
    regs_ever_live[61] = 1, call_used_regs[61] = 0;
  call_used_regs[63] = 0;

  for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)
    if (regs_ever_live[regno] && !call_used_regs[regno])
      cnt += 8;

  //if (size + cnt)
  //  fprintf (file, "\tmadd %d,sp,sp\n", -size - cnt);

//  cnt = 0;
  for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)
    if (regs_ever_live[regno] && !call_used_regs[regno])
      fprintf (file, "\tstore -8,sp,%s\n", reg_names[regno]);

  if (frame_pointer_needed)
    fprintf (file, "\tadd fp,%d,fp\n", size + cnt);
}

/* This function generates the assembly code for function exit.
   Args are as for output_function_prologue ().

   The function epilogue should not depend on the current stack
   pointer!  It should use the frame pointer only.  This is mandatory
   because of alloca; we also take advantage of it to omit stack
   adjustments before returning. */

static void
elxsi_output_function_epilogue (file, size)
     FILE *file;
     HOST_WIDE_INT size;
{
  register int regno;
  register int cnt = 0;

  /* this conditional is ONLY here because there is a BUG;
     EXIT_IGNORE_STACK is ignored itself when the first part of
     the condition is true! (at least in version 1.35) */
  /* the 8*10 is for 64 bits of .r5 - .r14 */
  if (current_function_calls_alloca || size >= (256 - 8 * 10))
    {
      /* use .r4 as a temporary! Ok for now.... */
      fprintf (file, "\tld.64\t.r4,.r14\n");

      for (regno = FIRST_PSEUDO_REGISTER-1; regno >= 0; --regno)
	if (regs_ever_live[regno] && !call_used_regs[regno])
	  cnt += 8;

      for (regno = 0; regno < FIRST_PSEUDO_REGISTER; ++regno)
	if (regs_ever_live[regno] && !call_used_regs[regno])
	  fprintf (file, "\tld.64\t.r%d,[.r14]%d\n", regno,
		   -((cnt -= 8) + 8) - 4 - size);

      fprintf (file, "\tld.64\t.sp,.r4\n\texit\t0\n");
    }
  else
    {
      for (regno = 0; regno < FIRST_PSEUDO_REGISTER; ++regno)
	if (regs_ever_live[regno] && !call_used_regs[regno])
	  fprintf (file, "\tload 8,sp,%s\n", reg_names[regno]);

      fprintf (file, "\tjmp ra\n", size + cnt);
    }
}

/* type is the index into the above table */
/* s is "" for signed, or "u" for unsigned */
const char *
cmp_jmp (s, type, where)
     const char *s;
     int type;
     rtx where;
{
    rtx br_ops[3];
    char template[50];
    const char *f = "";
    const char *bits = "64";
    if (GET_MODE (cmp_op0) == SFmode) f = "f", bits = "32";
    if (GET_MODE (cmp_op0) == DFmode) f = "f";
    br_ops[0] = where;
    br_ops[1] = cmp_op0;
    br_ops[2] = cmp_op1;
    if (cmp_op1)
	sprintf(template, "%scmp%s.br.%s\t%%1,%%2:j%s\t%%l0",
		f, s, bits, cmp_tab[type]);
    else if (*f)
	sprintf(template, "fcmp.br.%s\t%%1,=0:j%s\t%%l0",
		bits, cmp_tab[type]);
    else if (*s) /* can turn the below in to a jmp ... */
	sprintf(template, "cmpu.br.64\t%%1,=0:j%s\t%%l0", s);
    else
	sprintf(template, "jmp.%s\t%%1,%%l0", cmp_tab[type+1]);
    output_asm_insn(template, br_ops);
    return "";
}

const char *
cmp_set (s, type, reg)
     const char *s, *type;
     rtx reg;
{
    rtx br_ops[3];
    char template[50];
    const char *f = "";
    const char *bits = "64";
    if (GET_MODE (cmp_op0) == SFmode) f = "f", bits = "32";
    else if (GET_MODE (cmp_op0) == DFmode) f = "f";
    else if (GET_MODE (cmp_op0) == SImode) bits = "32";
    else if (GET_MODE (cmp_op0) == HImode) bits = "16";
    else if (GET_MODE (cmp_op0) == QImode) bits = "8";
    br_ops[0] = reg;
    br_ops[1] = cmp_op0;
    br_ops[2] = cmp_op1;
    if (cmp_op1)
	sprintf(template, "%scmp%s.%s\t%%0,%%1,%%2:%s",
		f, s, bits, type);
    else
	sprintf(template, "%scmp%s.%s\t%%0,%%1,=0:%s",
		f, s, bits, type);
    output_asm_insn(template, br_ops);
    return "";
}

void
print_operand_address (file, addr)
     FILE *file;
     register rtx addr;
{
  register rtx reg1, reg2, breg, ireg;
  rtx offset;

  switch (GET_CODE (addr))
    {

    case MEM:
      if (GET_CODE (XEXP (addr, 0)) == REG)
        fprintf (file, "%s", reg_names[REGNO (addr)]);
      else abort();
      break;

    case REG:
      fprintf (file, "[%s]", reg_names[REGNO (addr)]);
      break;

    case PLUS:
      reg1 = 0;	reg2 = 0;
      ireg = 0;	breg = 0;
      offset = 0;
      if (GET_CODE (XEXP (addr, 0)) == REG)
	{
	  offset = XEXP (addr, 1);
	  addr = XEXP (addr, 0);
	}
      else if (GET_CODE (XEXP (addr, 1)) == REG)
	{
	  offset = XEXP (addr, 0);
	  addr = XEXP (addr, 1);
	}
      fprintf (file, "[%s]", reg_names[REGNO (addr)]);
      output_address (offset);
      break;

    default:
      output_addr_const (file, addr);
    }
}

/* test for memory addressed by register */
int
indmem_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (memory_operand (op, mode) && GET_CODE(XEXP(op,0)) == REG);
}

int
regzero_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)==0));
}
int
imm8_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (CONSTANT_P(op) && INTVAL(op)>=0 && INTVAL(op)<=255);
}
int
regimm8_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) ||
			(CONSTANT_P(op) && INTVAL(op)>=0 && INTVAL(op)<=255));
}
int
regmemzero_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)==0) ||
		    indmem_operand(op, mode));
}
int
regmemimm16_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)>=0 && INTVAL(op)<=0xffff) ||
		    indmem_operand(op, mode));
}
int
regmemimm8_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)>=0 && INTVAL(op)<=0xff) ||
		    indmem_operand(op, mode));
}
/* loadcons immediate not handled be fcpu_expand_move */
bigimm_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (CONSTANT_P(op) && (INTVAL(op)<0 || INTVAL(op)>0xffff));
}


void                   
fcpu_expand_move (mode, ops)
	enum machine_mode mode;
	rtx ops[];           
{
	/* can't copy directly to MEM pointed by NONREG */
	if (GET_CODE (ops[0]) == MEM && GET_CODE(XEXP(ops[0],0)) != REG)
		ops[0] = gen_rtx_MEM(mode,force_reg(Pmode,XEXP(ops[0],0)));
	
	/* also can't copy from MEM pointed by NONREG */
	if (GET_CODE (ops[1]) == MEM && GET_CODE(XEXP(ops[1],0)) != REG)
		ops[1] = gen_rtx_MEM(mode,force_reg(Pmode,XEXP(ops[1],0)));

	/* generate constant */
	if (GET_CODE (ops[1]) == CONST_INT && GET_CODE (ops[0]) == REG && GET_MODE_SIZE(mode) > 2) {
		long long x = INTVAL(ops[1]);
		if (x >= 0 && x <= 0xffff) {
			if (GET_MODE_SIZE(mode) > 2) /* clear reg optionally */
				emit_insn(gen_rtx_SET(mode,ops[0],GEN_INT(0)));
			ops[0] = gen_rtx_ZERO_EXTRACT(mode,ops[0],GEN_INT(16),GEN_INT(0));
		} else {
			/* hmm how to emit ?? */
			/* let's ignore it and handle in .md */
		}
	}
	
	/* if the first were MEM and second NONREG then use other register */
	if (GET_CODE (ops[0]) == MEM && GET_CODE (ops[1]) != REG)
		ops[1] = force_reg(mode,ops[1]);

	/* ok can generate direct move */
	emit_insn(gen_rtx_SET(VOIDmode,ops[0],ops[1]));
}

struct fcpu_compare fcpu_compare;

rtx
fcpu_emit_conditional_branch (code)
	enum rtx_code code;
{
	enum rtx_code cmp_code, branch_code;
	enum machine_mode cmp_mode, branch_mode = VOIDmode;
	rtx op0 = fcpu_compare.op0, op1 = fcpu_compare.op1;
	rtx tem;
	cmp_mode = DImode;

	/* The general case: fold the comparison code to the types of compares
	   that we have, choosing the branch as necessary.  */
	switch (code)
	{
		case NE:  case LE:  case LT:  case LEU:  case LTU: case UNORDERED:
			/* We have these compares: */
			cmp_code = code, branch_code = NE;
			break;

		case EQ: case ORDERED: case GE:  case GT: case GEU:  case GTU:
			/* These must be reversed.  */
			cmp_code = reverse_condition (code), branch_code = EQ;
			break;

		default:
			abort ();
	}

	/* ??? We mark the the branch mode to be CCmode to prevent the
	   compare and branch from being combined, since the compare 
	   insn follows IEEE rules that the branch does not.  */
	branch_mode = CCmode;

	/* The following optimizations are only for signed compares.  */
	if (code != LEU && code != LTU && code != GEU && code != GTU)
	{
		/* Whee.  Compare and branch against 0 directly.  */
		if (op1 == const0_rtx)
			cmp_code = NIL, branch_code = code;

	}

	if (!regzero_operand (op0, DImode))
		op0 = force_reg (DImode, op0);
	if (!regzero_operand (op1, DImode))
		op1 = force_reg (DImode, op1);


	/* Emit an initial compare instruction, if necessary.  */
	tem = op0;
	if (cmp_code != NIL)
	{
		tem = gen_reg_rtx (cmp_mode);
		emit_move_insn (tem, gen_rtx_fmt_ee (cmp_code, cmp_mode, op0, op1));
	}

	/* Zero the operands.  */
	memset (&fcpu_compare, 0, sizeof (fcpu_compare));

	/* Return the branch comparison.  */
	return gen_rtx_fmt_ee (branch_code, branch_mode, tem, CONST0_RTX (cmp_mode));
}
