;;- Machine description for GNU compiler, F-CPU, devik@cdi.cz


;;- Instruction patterns.  When multiple patterns apply,
;;- the first one in the file is chosen.
;;-
;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.
;;-
;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

(define_attr "type"
   "other,add,loadcons,move,mul,div,rot,inc,logic,logic2,loadaddr,fpu,lsu"
     (const_string "other"))
;; TODO: define fast path when adding 8bits
(define_function_unit "adder" 1 0 
 (eq_attr "type" "add") 3 0)
(define_function_unit "loadcons" 1 0
 (eq_attr "type" "loadcons") 1 0)
(define_function_unit "move" 1 0
 (eq_attr "type" "move") 1 0)
(define_function_unit "other" 1 0
 (eq_attr "type" "other") 2 0)
(define_function_unit "mul" 1 0
 (eq_attr "type" "mul") 7 0)
(define_function_unit "div" 1 1
 (eq_attr "type" "div") 40 40)
(define_function_unit "rot" 1 0
 (eq_attr "type" "rot") 2 0)
(define_function_unit "inc" 1 0
 (eq_attr "type" "inc") 2 0)
;; TODO: logic is now 2 cycles .. ?
(define_function_unit "logic" 1 0
 (eq_attr "type" "logic") 2 0)
;; second port of LOGIC unit - implements "combine"
(define_function_unit "logic2" 1 0
 (eq_attr "type" "logic2") 3 0)
;; it is actually 3 but we need to prefetch soon
(define_function_unit "loadaddr" 1 0
 (eq_attr "type" "loadaddr") 5 0)
;; catch-all for FP operations -MR
(define_function_unit "fpu" 1 0
 (eq_attr "type" "fpu") 8 0)
(define_function_unit "lsu" 1 0
 (eq_attr "type" "lsu") 3 0)

;; experimental complex insns; these seems to work well

(define_insn "*nor_nand"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 3 "binary_operator" [
        (match_operator 4 "unary_operator" [(match_operand 1 "register_operand" "r")])
	(match_operator 5 "unary_operator" [(match_operand 2 "register_operand" "r")])
	]))]
 "GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  mode_check(operands,0,1,2,3) && 
  mode_check(operands,0,4,5,0) &&
  (GET_CODE(operands[3]) == IOR || GET_CODE(operands[3]) == AND) &&
  GET_CODE(operands[5]) == NOT && GET_CODE(operands[4]) == NOT"
  { 
  return GET_CODE(operands[3]) == IOR ? "nand.%s0 %2,%1,%0":"nor.%s0 %2,%1,%0";
  }
  [(set_attr "type" "logic")])

(define_insn "*nor_nand_zext"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 6 "unary_operator" [(match_operator 3 "binary_operator" [
        (match_operator 4 "unary_operator" [(match_operand 1 "register_operand" "r")])
	(match_operator 5 "unary_operator" [(match_operand 2 "register_operand" "r")])
	])]))]
 "zero_extend_insn_ok(operands,6,2) &&
  mode_check(operands,3,4,5,1) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (GET_CODE(operands[3]) == IOR || GET_CODE(operands[3]) == AND) &&
  GET_CODE(operands[5]) == NOT && GET_CODE(operands[4]) == NOT"
  { 
  return GET_CODE(operands[3]) == IOR ? "nand.%s1 %2,%1,%0":"nor.%s1 %2,%1,%0";
  }
  [(set_attr "type" "logic")])

;; the third operand is inverted
;; orni/andni don't make much sense -MR
(define_insn "*orn_andn"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 3 "binary_operator" [
        (match_operator 4 "unary_operator" [(match_operand 1 "register_operand" "r")])
	(match_operand 2 "register_operand" "r")
	]))]
 "mode_check(operands,0,1,2,3) &&
  mode_check(operands,0,4,0,0) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (GET_CODE(operands[3]) == IOR || GET_CODE(operands[3]) == AND) &&
  GET_CODE(operands[4]) == NOT"
  { 
  return GET_CODE(operands[3]) == IOR ? "orn.%s0 %1,%2,%0":"andn.%s0 %1,%2,%0";
  }
  [(set_attr "type" "logic")])

(define_insn "*orn_andn_zext"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 5 "unary_operator" [(match_operator 3 "binary_operator" [
        (match_operator 4 "unary_operator" [(match_operand 1 "register_operand" "r")])
	(match_operand 2 "register_operand" "r")
	])]))]
 "mode_check(operands,1,2,3,4) &&
  zero_extend_insn_ok(operands,5,2) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (GET_CODE(operands[3]) == IOR || GET_CODE(operands[3]) == AND) &&
  GET_CODE(operands[4]) == NOT"
  { 
  return GET_CODE(operands[3]) == IOR ? "orn.%s1 %1,%2,%0":"andn.%s1 %1,%2,%0";
  }
  [(set_attr "type" "logic")])

(define_insn "*xnor"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 4 "unary_operator" [
       (match_operator 3 "binary_operator" [(match_operand 1 "register_operand" "r")
	(match_operand 2 "regimm9s_operand" "ri")])]))]
 "mode_check(operands,0,1,3,4) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (GET_MODE(operands[0]) == GET_MODE(operands[2]) || GET_CODE(operands[2]) == CONST_INT) &&
  (GET_CODE(operands[3]) == XOR) && GET_CODE(operands[4]) == NOT"
  "xnor%i2.%s0 %2,%1,%0"
  [(set_attr "type" "logic")])

(define_insn "*xnor_zext"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 5 "unary_operator" [
     (match_operator 4 "unary_operator" [
       (match_operator 3 "binary_operator" [(match_operand 1 "register_operand" "r")
	(match_operand 2 "regimm9s_operand" "ri")])])]))]
 "zero_extend_insn_ok(operands,5,0) && mode_check(operands,1,3,4,1) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (GET_MODE(operands[1]) == GET_MODE(operands[2]) || GET_CODE(operands[2]) == CONST_INT) &&
  (GET_CODE(operands[3]) == XOR) && GET_CODE(operands[4]) == NOT"
  "xnor%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

;; This is in fcpu-arith but zero-extending of xor $n promotes
;; zero_extend as second parameter - handle the case here
(define_insn "*xor_zext"
 [(set (match_operand 0 "register_operand" "=r")
       (match_operator 3 "binary_operator" [
     		(match_operator 4 "unary_operator" [
			(match_operand 1 "register_operand" "r")])
	(match_operand 2 "regimm9s_operand" "ri")]))]
 "zero_extend_insn_ok(operands,4,0) && mode_check(operands,0,3,4,0) &&
  (GET_MODE(operands[0]) == GET_MODE(operands[2]) || GET_CODE(operands[2]) == CONST_INT) &&
  GET_CODE(operands[3]) == XOR"
  "xor%i2.%s1 %2,%1,%0"
  [(set_attr "type" "logic")])

;; Mux is hard to define (result in paired register as in case of divr)
;; It is not often used so ignore it for now
;;(define_insn "*muxsi"
;; [(set (subreg:SI (match_operand:DI 0 "register_operand" "=r") 0)
;;     (ior:SI (and:SI 
;;	   (match_operand:SI 1 "register_operand" "r")
;;	   (match_operand:SI 2 "register_operand" "r"))
;;        (and:SI (not:SI (match_dup 1))
;;	     (match_operand 3 "register_operand" "r"))
;;	))]
;; "" "xmux.32 %1,%3,%2,%0"
;;  [(set_attr "type" "logic")])
;;
;;(define_insn "*mux"
;; [(set (match_operand 0 "register_operand" "=r")
;;     (match_operator 4 "binary_operator" [
;;        (match_operator 5 "binary_operator" [
;;	   (match_operand 1 "register_operand" "r")
;;	   (match_operand 2 "register_operand" "r")])
;;        (match_operator 6 "binary_operator" [
;;	   (match_operator 7 "unary_operator" [
;;	     (match_operand 3 "register_operand" "r")]) 
;;	   (match_operand 8 "register_operand" "r")])
;;	]))]
;; "GET_MODE(operands[0]) == GET_MODE(operands[1]) &&
;;  GET_MODE(operands[0]) == GET_MODE(operands[2]) &&
;;  GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
;;  GET_MODE(operands[0]) == GET_MODE(operands[4]) &&
;;  GET_MODE(operands[0]) == GET_MODE(operands[5]) &&
;;  GET_MODE(operands[0]) == GET_MODE(operands[6]) &&
;;  GET_MODE(operands[0]) == GET_MODE(operands[7]) &&
;;  GET_MODE(operands[0]) == GET_MODE(operands[8]) &&
;;  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
;;  (REGNO(operands[3]) == REGNO(operands[1]) ||
;;   REGNO(operands[3]) == REGNO(operands[2])) &&
;;  GET_CODE(operands[4]) == IOR &&
;;  GET_CODE(operands[5]) == AND &&
;;  GET_CODE(operands[7]) == NOT &&
;;  GET_CODE(operands[6]) == AND"
;;  {
;;  if (REGNO(operands[3]) == REGNO(operands[1]))
;;  	return "mux.%s0 %3,%8,%2,%0";
;;  else 
;;	return "mux.%s0 %3,%8,%1,%0";
;;  }
;;  [(set_attr "type" "logic")])

;; looping
;; TODO: doesn't work often - need redesign .. but ...
;;(define_insn "decrement_and_branch_until_zero"
;;  [
;;    (set (pc) (if_then_else
;;	       (ge (plus:SI (match_operand:SI 0 "register_operand" "+r") (const_int -1))
;;	       (const_int 0))
;;        (label_ref (match_operand 1 "target_operand" "r"))
;;        (pc)))
;;    (set (match_dup 0) (plus:SI (match_dup 0) (const_int -1)))
;;    ]
;;    ""
;;    "loop_direct %0,%l1")

;;############# Compares
;; copy operands to temp vars
(define_expand "cmpdi"
 [(set (cc0) (compare (match_operand:DI 0 "general_operand" "")
		 (match_operand:DI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })
(define_expand "cmpsi"
 [(set (cc0) (compare (match_operand:SI 0 "general_operand" "")
		 (match_operand:SI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })
(define_expand "cmphi"
 [(set (cc0) (compare (match_operand:HI 0 "general_operand" "")
		 (match_operand:HI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })
(define_expand "cmpqi"
 [(set (cc0) (compare (match_operand:QI 0 "general_operand" "")
		 (match_operand:QI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })

(define_expand "movqicc"
  [(set (match_operand:QI 0 "register_operand" "")
	(if_then_else:QI (match_operand 1 "comparison_operator" "")
			 (match_operand:QI 2 "register_operand" "")
			 (match_operand:QI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,QImode))==NULL) FAIL;
  })
(define_expand "movhicc"
  [(set (match_operand:HI 0 "register_operand" "")
	(if_then_else:HI (match_operand 1 "comparison_operator" "")
			 (match_operand:HI 2 "register_operand" "")
			 (match_operand:HI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,HImode))==NULL) FAIL;
  })
(define_expand "movdicc"
  [(set (match_operand:DI 0 "register_operand" "")
	(if_then_else:DI (match_operand 1 "comparison_operator" "")
			 (match_operand:DI 2 "register_operand" "")
			 (match_operand:DI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,DImode))==NULL) FAIL;
  })
(define_expand "movsicc"
  [(set (match_operand:SI 0 "register_operand" "")
	(if_then_else:SI (match_operand 1 "comparison_operator" "")
			 (match_operand:SI 2 "register_operand" "")
			 (match_operand:SI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,SImode))==NULL) FAIL;
  })
(define_expand "movdfcc"
  [(set (match_operand:DF 0 "register_operand" "")
	(if_then_else:DF (match_operand 1 "comparison_operator" "")
			 (match_operand:DF 2 "register_operand" "")
			 (match_operand:DF 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,DFmode))==NULL) FAIL;
  })
(define_expand "movsfcc"
  [(set (match_operand:SF 0 "register_operand" "")
	(if_then_else:SF (match_operand 1 "comparison_operator" "")
			 (match_operand:SF 2 "register_operand" "")
			 (match_operand:SF 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,SFmode))==NULL) FAIL;
  })

;; ##################### Conditional moves
;; conditional move with zero test is performed on full 64 bit register
(define_insn "*movcc"
  [(set (match_operand 0 "register_operand" "=r,r")
	(if_then_else (match_operator 4 "comparison_operator" [
			  (match_operand:DI 1 "register_operand" "r,r") 
				(const_int 0)])
		      (match_operand 2 "register_operand" "0,r")
		      (match_operand 3 "register_operand" "r,0")))]
  "(GET_CODE(operands[4]) == NE || GET_CODE(operands[4]) == EQ) &&
    GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
    GET_MODE(operands[0]) == GET_MODE(operands[2]) &&
    GET_MODE(operands[0]) == GET_MODE(operands[3])"
  "@
  move%C4.%s0 %1,%3,%0
  move%c4.%s0 %1,%2,%0"
  [(set_attr "type" "move")])

;; this it better one, tests LSB so that it is mode independent and faster
(define_insn "*movcclsb"
  [(set (match_operand 0 "register_operand" "=r,r")
	(if_then_else (match_operator 4 "comparison_operator" [
			  (zero_extract (match_operand 1 "register_operand" "r,r") 
			   (const_int 1) (const_int 0))
				(const_int 0)])
		      (match_operand 2 "register_operand" "0,r")
		      (match_operand 3 "register_operand" "r,0")))]
  "(GET_CODE(operands[4]) == NE || GET_CODE(operands[4]) == EQ) &&
    GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
    GET_MODE(operands[0]) == GET_MODE(operands[2]) &&
    GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
    (GET_MODE_SIZE(GET_MODE(operands[1])) <= 8 || GET_MODE(operands[1]) == VOIDmode)"
  "@
  move%E4.%s0 %1,%3,%0
  move%e4.%s0 %1,%2,%0"
  [(set_attr "type" "move")])

;;(define_insn "*test"
;; [(set (match_operand:DI 0 "register_operand" "r")
;;	 (zero_extend:DI (plus:SI 
;;			  (match_operand:DI 0 "register_operand" "r")
;;			  (match_operand:DI 0 "register_operand" "r")

;; ##################### Conditional branches
;; here are jumps using LSB, fast, mode independent
(define_insn "*condbrlsb"
 [(set (pc) (if_then_else (match_operator 2 "comparison_operator" [
			 (zero_extract (match_operand 0 "register_operand" "r") 
				 (const_int 1) (const_int 0))
			 (const_int 0)])
		 (match_operand:DI 1 "target_operand" "r")
		 (pc)))]
 "GET_CODE(operands[2]) == NE || GET_CODE(operands[2]) == EQ"
 "jmp%e2 %0,%1")

;; this is only valid for DI mode and is slower
(define_insn "*condbrzero"
 [(set (pc) (if_then_else (match_operator 2 "comparison_operator" [ 
			 (match_operand:DI 0 "register_operand" "r")
			 (const_int 0)]) 
		 (match_operand:DI 1 "target_operand" "r")
		 (pc)))]
 "GET_CODE(operands[2]) == NE || GET_CODE(operands[2]) == EQ"
 "jmp%c2 %0,%1")
 

;; Truncation
;;(define_expand "truncdisi2" 
;; [(set (match_operand:SI 0 "register_operand" "r")
;;     (truncate:SI (match_operand:DI 1 "register_operand" "r")))]
;; "" "")
;;(define_expand "truncdihi2" 
;; [(set (match_operand:HI 0 "register_operand" "r")
;;     (truncate:HI (match_operand:DI 1 "register_operand" "r")))]
;; "" "")
;;(define_expand "truncdiqi2" 
;; [(set (match_operand:QI 0 "register_operand" "r")
;;     (truncate:QI (match_operand:DI 1 "register_operand" "r")))]
;; "" "")
;;(define_expand "truncsihi2" 
;; [(set (match_operand:HI 0 "register_operand" "r")
;;     (truncate:HI (match_operand:SI 1 "register_operand" "r")))]
;; "" "")
;;(define_expand "truncsiqi2" 
;; [(set (match_operand:QI 0 "register_operand" "r")
;;     (truncate:QI (match_operand:SI 1 "register_operand" "r")))]
;; "" "")
;;(define_expand "trunchiqi2" 
;; [(set (match_operand:QI 0 "register_operand" "r")
;;     (truncate:HI (match_operand:HI 1 "register_operand" "r")))]
;; "" "")
;;
;;(define_insn "*trunc"
;; [(set (match_operand 0 "register_operand" "=r")
;;     (truncate (match_operand 1 "register_operand" "r")))]
;; "" "move.%s0 %1,%0 // trunc %s1 => %s0")


;; ############# Expanded moves; generates intermediates for memory
;; references and generates constant loads too
(define_expand "movqi" 
 [(set (match_operand:QI 0 "nonimmediate_operand" "")
       (match_operand:QI 1 "general_operand" ""))]
 ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (QImode, operands); DONE;}")

(define_expand "movhi" 
 [(set (match_operand:HI 0 "nonimmediate_operand" "")
       (match_operand:HI 1 "general_operand" ""))]
 ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (HImode, operands); DONE;}")

(define_expand "movsi" 
 [(set (match_operand:SI 0 "nonimmediate_operand" "")
       (match_operand:SI 1 "general_operand" ""))]
 ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (SImode, operands); DONE;}")
 
(define_expand "movdi"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (DImode, operands); DONE;}")

(define_expand "movsf" 
 [(set (match_operand:SF 0 "nonimmediate_operand" "")
       (match_operand:SF 1 "nonimmediate_operand" ""))]
 ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (SFmode, operands); DONE;}")
 
(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "nonimmediate_operand" ""))]
  ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (DFmode, operands); DONE;}")

;; handles constant parts loading for CONST_INT immediates 
(define_insn "*loadcons"
 [(set (match_operator 3 "ternary_operator"  [
		 (match_operand 0 "register_operand" "+r") 
		 (match_operand 4 "immediate_operand" "i")
		 (match_operand 1 "immediate_operand" "i")])
	 (match_operand 2 "imm16_operand" "i"))]
 "(INTVAL(operands[1]) & 15) == 0 && GET_CODE(operands[3]) == ZERO_EXTRACT &&
  INTVAL(operands[1]) < GET_MODE_SIZE(GET_MODE(operands[0]))*8 &&
  (INTVAL(operands[4]) & 15) == 0 && 
  (INTVAL(operands[4]) == 16 ||
   INTVAL(operands[4]) == GET_MODE_SIZE(GET_MODE(operands[0]))*8-INTVAL(operands[1]))"
  {
  return INTVAL(operands[4]) > 16 ? "loadconsx.%d1 %2,%0":"loadcons.%d1 %2,%0";
  }
  [(set_attr "type" "loadcons")])


;; Memory loads combined with zero_extend
(define_insn "*load_zext"
  [(set (match_operand 0 "register_operand" "=r")
	(match_operator 2 "unary_operator" [
	 	(match_operand 1 "memory_operand" "m")]))]
  "zero_extend_insn_ok(operands,2,0)"
  "load%k1.%s1 %1,%0 //zext"
  [(set_attr "type" "lsu")])

;; ############# Atomic moves
;; These handle reg->reg, reg->mem, mem->reg, 0->mem, 16bit const->reg 
;; see that we use regmemimm16s_operand, "16s" means signed while
;; "16" only means range -32768...65535

(define_insn "*movdi"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,m,a,r,m")
	(match_operand:DI 1 "regmemimm16s_operand" "r,r,m,i,O"))]
  "GET_CODE(operands[0]) != MEM || (GET_CODE(operands[1]) != MEM 
    && (operands[1] == const0_rtx || REG_P(operands[1])))"
  "@
  move.%s0 %1,%0
  store%k0.%s1 %0,%1
  load%k1.%s0 %1,%0
  loadconsx.0 %1,%0
  store%k0.%s1 %0,r0")

(define_insn "*movsi"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,m,a,r,m")
	(match_operand:SI 1 "regmemimm16s_operand" "r,r,m,i,O"))]
  "GET_CODE(operands[0]) != MEM || (GET_CODE(operands[1]) != MEM 
    && (operands[1] == const0_rtx || REG_P(operands[1])))"
  "@
  move.32 %1,%0
  store%k0.32 %0,%1
  load%k1.32 %1,%0
  loadconsx.0 %1,%0
  store%k0.32 %0,r0")

(define_insn "*movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,m,a,r,m")
	(match_operand:HI 1 "regmemimm16_operand" "r,r,m,i,O"))]
  "GET_CODE(operands[0]) != MEM || GET_CODE(operands[1]) != MEM"
  "@
  move.16 %1,%0
  store%k0.16 %0,%1
  load%k1.16 %1,%0
  loadcons.0 %1,%0
  store%k0.16 %0,r0")

(define_insn "*movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=r,m,a,r,m")
	(match_operand:QI 1 "regmemimm8_operand" "r,r,m,i,O"))]
  "GET_CODE(operands[0]) != MEM || GET_CODE(operands[1]) != MEM"
  "@
  move.8 %1,%0
  store%k0.8 %0,%1
  load%k1.8 %1,%0
  loadcons.0 %1,%0
  store%k0.8 %0,r0")

(define_insn "*movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=r,m,a")
	(match_operand:DF 1 "nonimmediate_operand" "r,r,m"))]
  "GET_CODE(operands[0]) != MEM || GET_CODE(operands[1]) != MEM"
  "@
  move.64 %1,%0
  store%k0.64 %0,%1
  load%k1.64 %1,%0")

(define_insn "*movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=r,m,a")
	(match_operand:SF 1 "nonimmediate_operand" "r,r,m"))]
  "GET_CODE(operands[0]) != MEM || GET_CODE(operands[1]) != MEM"
  "@
  move.32 %1,%0
  store%k0.32 %0,%1
  load%k1.32 %1,%0")

;; TEST TImode
(define_expand "divmodsi4"
  [ (clobber (match_dup 4))
    (parallel [
   (set (subreg:SI (match_dup 4) 0) 
        (div:SI (match_operand:SI 1 "register_operand" "r")
                (match_operand:SI 2 "register_operand" "r")))
   (set (subreg:SI (match_dup 4) 8)
        (mod:SI (match_dup 1) (match_dup 2)))
   ])
   (set (match_operand:SI 0 "register_operand" "=r") 
	(subreg:SI (match_dup 4) 0))
   (set (match_operand:SI 3 "register_operand" "=r") 
	(subreg:SI (match_dup 4) 8))]
  "" {
	operands[4] = gen_reg_rtx(TImode);
})

(define_insn "*divmodsi4"
 [ (set (subreg:SI (match_operand:TI 0 "register_operand" "r") 0)
        (div:SI (match_operand:SI 1 "register_operand" "r")
                (match_operand:SI 2 "register_operand" "r")))
   (set (subreg:SI (match_dup 0) 8)
        (mod:SI (match_dup 1) (match_dup 2)))]
  "" "divrs.32 %2,%1,%0")

;;############# Bitop constant load - only set bits
;; no sense for HI/QI, they use loadcons.0
(define_insn "*bitconst"
  [(set (match_operand 0 "register_operand" "=r")
	(match_operand 1 "immediate_operand" "i"))]
  "(GET_MODE(operands[0]) == DImode || GET_MODE(operands[0]) == SImode)
    && bitable_operand(operands[1],GET_MODE(operands[0]))"
  "bseti.%s0 %b1,r0,%0"
  [(set_attr "type" "logic")])

;;############# LABEL_REF constants
(define_insn "*labelcons"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(match_operand:DI 1 "immediate_operand" "i"))]
  "GET_CODE(operands[1])==LABEL_REF"
  "loadaddri %1-.-4,%0 // maybe it should be loadaddrdi"
  [(set_attr "type" "loadaddr")])

;;############# Fallback constant loading using ASM macro
(define_insn "*symconst"
  [(set (match_operand 0 "register_operand" "=r")
	(match_operand 1 "immediate_operand" "i"))]
  "GET_CODE(operands[1]) == SYMBOL_REF || GET_CODE(operands[1]) == CONST"
  "loadcons %1,%0"
  [(set_attr "type" "loadcons")])

;; splitting above
(define_split 
  [(set (match_operand:DI 0 "register_operand" "")
	(match_operand:DI 1 "immediate_operand" ""))]
  "(GET_CODE(operands[1]) == SYMBOL_REF || GET_CODE(operands[1]) == CONST) && 0"
  [(set (match_dup 0) (const_int 0))
   (set (zero_extract:DI (match_dup 0) (const_int 16) (const_int 0))
	  (match_dup 1))
   (set (zero_extract:DI (match_dup 0) (const_int 16) (const_int 16))
              (match_dup 1))]
   "")
 

(define_insn "jump_internal"
  [(set (pc)
    (match_operand:DI 0 "target_operand" "r"))]
  ""
  "jmp %0")

(define_expand "jump"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  "" {
  if (reload_in_progress || reload_completed) FAIL;
  emit_insn (gen_jump_internal (gen_rtx_LABEL_REF (DImode, operands[0])));
  DONE;
})

(define_insn "indirect_jump"
  [(set (pc) (match_operand:DI 0 "register_operand" "r"))]
  ""
  "jmp %0")

;; TODO: hmm this is not well optimized
(define_insn "tablejump"
  [ (set (pc) (plus:DI (pc)
	     (sign_extend:DI (match_operand:SI 0 "register_operand" "r"))
	     ))
      (use (label_ref (match_operand 1 "" "")))
      ]
  "" "widen.32 %0,%0\n\tloadaddr %0,%0\n.LSW%r1:\n\tjmp %0")

(define_expand "prologue"
 [(const_int 1)]
 "" "fcpu_expand_prologue (); DONE;")

(define_expand "epilogue"
 [(const_int 1)]
 "" "fcpu_expand_epilogue (); DONE;")

(define_insn "nop" [(const_int 0)] "" "nop")

(define_expand "call"
  [(call (match_operand:QI 0 "memory_operand" "m") (match_operand:QI 1 "" ""))
  (clobber (reg:DI 63))]
  ""
  "operands[0]=force_reg(Pmode,XEXP(operands[0],0));")

(define_insn "return_internal"
  [(return)
   (use (reg:SI 63))]
  ""
  "jmp r63")

(define_insn "*call"
  [(call (match_operand:DI 0 "register_operand" "r")
	 (match_operand:QI 1 "general_operand" "g"))]
  ""
  "jmp %0,r63")

(define_expand "call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:QI 1 "memory_operand" "m")
	      (match_operand:QI 2 "general_operand" "g")))
  (clobber (reg:DI 63))]
  ""
  "operands[1]=force_reg(Pmode,XEXP(operands[1],0));")

(define_insn "*call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:DI 1 "register_operand" "r")
	      (match_operand:QI 2 "general_operand" "g")))]
  ""
  "jmp %1,r63")


(define_split
 [(set (match_operand:DI 0 "register_operand" "")
       (match_operator:DI 1 "binary_operator" [
	    (zero_extend:DI (match_operand:SI 2 "" ""))
	    (match_operand:DI 3 "" "")]))
  (clobber (match_operand:DI 4 "register_operand" ""))
 ]
 "0"
 [(set (subreg:SI (match_dup 4) 0) (match_dup 2))
  (set (match_dup 0) (match_op_dup 1 [(match_dup 4) (match_dup 3)]))]
 "")

;; eliminate extra zero_extends
(define_peephole2
 [(set (match_operand 0 "register_operand" "")
	 (match_operand 1 "" ""))
  (set (match_operand:DI 2 "register_operand" "")
       (zero_extend:DI (match_dup 0)))]
 "0"
 [(set (match_dup 0) (match_dup 1))
  (set (match_dup 2) (subreg:DI (match_dup 0) 0))]
 "")


(include "fcpu-arith.md")
