/* Definitions of target machine for GNU compiler.  F-CPU version.
   devik@cdi.cz
*/

/* Functions used in the md file. */

#ifdef RTX_CODE
#define DECL_IMMXOP(suff) \
 extern int imm ## suff ## _operand PARAMS ((rtx op, enum machine_mode mode)); \
 extern int regimm ## suff ## _operand PARAMS ((rtx op, enum machine_mode mode)); \
 extern int regmemimm ## suff ## _operand PARAMS ((rtx op, enum machine_mode mode));

DECL_IMMXOP (8)
DECL_IMMXOP (8s)
DECL_IMMXOP (8u)
DECL_IMMXOP (9s)
DECL_IMMXOP (9x)
DECL_IMMXOP (16)
DECL_IMMXOP (16s)
DECL_IMMXOP (16u)
DECL_IMMXOP (0)
#undef DECL_IMMXOP

extern void print_operand_address PARAMS ((FILE *, rtx));
extern void print_operand PARAMS ((FILE *, rtx, const char));

extern int fcpu_need_fp_p PARAMS ((void));
extern int fcpu_init_fp_off PARAMS ((void));
extern int fcpu_const_ok_for_letter_p PARAMS ((HOST_WIDE_INT,char));

extern int zero_extend_insn_ok PARAMS ((rtx[],int,int));
extern int mode_check PARAMS ((rtx[],int op1,int op2,int op3,int op4));

extern int target_operand PARAMS ((rtx op, enum machine_mode mode));
extern int bitable_operand PARAMS ((rtx op, enum machine_mode mode));
extern int bigimm_operand PARAMS ((rtx op, enum machine_mode mode));

extern int ternary_operator PARAMS ((rtx op, enum machine_mode mode));
extern int binary_operator PARAMS ((rtx op, enum machine_mode mode));
extern int unary_operator PARAMS ((rtx op, enum machine_mode mode));

extern void fcpu_expand_epilogue PARAMS ((void));
extern void fcpu_expand_prologue PARAMS ((void));
extern void fcpu_expand_move PARAMS ((enum machine_mode, rtx[]));
extern int fcpu_is_legitimate_address PARAMS ((enum machine_mode, rtx));
extern rtx fcpu_emit_conditional_branch PARAMS ((enum rtx_code code));
extern void fcpu_emit_scc PARAMS ((enum rtx_code code,rtx[]));
extern rtx fcpu_expand_cmove PARAMS ((rtx op[], enum machine_mode mode));
extern int ffz_big PARAMS ((unsigned HOST_WIDE_INT x));
#endif /* RTX_CODE */

