divert(-1)
dnl             1        2      3    4   5    6    7     8    9       10
dnl binop_imm8(insn_name,mode,rtlop,asm,type,suff,zext1,zext2,zext_pr,arg)
dnl Templates prepared for zero extension needs to follow example below
dnl arg 2 is like :SI or void for zext pattern
define(`binop2',`(define_insn "$1"
  [(set (match_operand$2 0 "register_operand" "=r")
	 $7($3$2 (match_operand$2 1 "register_operand" "r")
		  (match_operand$2 2 "$10" "ri"))$8)]
  "ZEXT($9,2)"
  "$4%i2.%s1 %2,%1,%0"
  [(set_attr "type" "$5")])
')		
define(`unop2',`(define_insn "$1"
  [(set (match_operand$2 0 "register_operand" "=r")
	 $7($3$2 (match_operand$2 1 "register_operand" "r"))$8)]
  "ZEXT($9,0)"
  "$4.%s1 %1,%0"
  [(set_attr "type" "$5")])
')
define(`notx2',`(define_insn "$1"
  [(set (match_operand$2 0 "register_operand" "=r")
	 $7($3$2 (match_operand$2 1 "register_operand" "r"))$8)]
  "ZEXT($9,0)"
  "nor.%s1 r0,%1,%0"
  [(set_attr "type" "$5")])
')

dnl logic operations with single-bit constants
define(`binop_bit',`(define_insn "$1i"
    [(set (match_operand$2 0 "register_operand" "=r")
	($3$2 (match_operand$2 1 "register_operand" "r")
	    (match_operand$2 2 "bitable_operand" "i")))]
    "INTVAL(operands[2]) > 0"
    "$4i$6 %b2,%1,%0"
    [(set_attr "type" "$5")])
(define_insn "$1"
    [(set (match_operand$2 0 "register_operand" "=r")
	($3$2
	    (ashift$2 (const_int 1)
		(match_operand$2 2 "register_operand" "r"))
	    (match_operand$2 1 "register_operand" "r")))]
    ""
    "$4$6 %2,%1,%0"
    [(set_attr "type" "$5")])
')
dnl logic operations with negated single-bit constants
define(`binop_nbit',`(define_insn "$1"
    [(set (match_operand$2 0 "register_operand" "=r")
	($3$2
	    (rotate$2 (const_int -2)
		(match_operand$2 2 "register_operand" "r"))
	    (match_operand$2 1 "register_operand" "r")))]
    ""
    "$4$6 %2,%1,%0"
    [(set_attr "type" "$5")])
')
dnl mul, signed div & rem need special syntactic treatment -MR
define(`binop_muldiv',`(define_insn "$1"
  [(set (match_operand$2 0 "register_operand" "=r,r")
	 $7($3$2 (match_operand$2 1 "register_operand" "r,r")
		  (match_operand$2 2 "$10" "r,i"))$8)]
  "ZEXT($9,2)" "@
  $4s.%s1 %2,%1,%0
  $4i.%s1 %2,%1,%0"
  [(set_attr "type" "$5")])
')
dnl Like binop but specialized for plus op (convertible to add,sub,inc,dec)
define(`plusop',`(define_insn "$1"
  [(set (match_operand$2 0 "register_operand" "=r,r")
	 $7(plus$2 (match_operand$2 1 "register_operand" "r,r")
		  (match_operand$2 2 "$10" "r,i"))$8)]
  "ZEXT($9,2)" {
  if (which_alternative == 0) return "add.%s1 %2,%1,%0";
  if (INTVAL(operands[2])==1) return "inc.%s1 %1,%0";
  if (INTVAL(operands[2])==-1) return "dec.%s1 %1,%0";
  if (INTVAL(operands[2])<0) return "subi.%s1 $%n2,%1,%0";
  return "addi.%s1 %2,%1,%0"; }
  [(set_attr "type" "add,inc")]) ;; TODO! FIXME
')
dnl Like binop but specialized for lshift as MULT
define(`lshop',`(define_insn "$1"
  [(set (match_operand$2 0 "register_operand" "=r")
	 $7(mult$2 (match_operand$2 1 "register_operand" "r")
		  (match_operand$2 2 "$10" "i"))$8)]
  "exact_log2(INTVAL(operands[2]))>=0 && zero_extend_insn_ok(operands,$9,0)" 
  "shiftli.%s1 %b2,%1,%0"
  [(set_attr "type" "rot")])
')
dnl conds(condition)
define(`conds',`(define_expand "b$1"
  [(set (pc) (if_then_else (match_dup 1)
	(label_ref (match_operand 0 "" "")) (pc)))]
  "" "{ operands[1] = fcpu_emit_conditional_branch (translit(`$1', `a-z', `A-Z')); }")
(define_expand "s$1"
  [(set (match_operand:QI 0 "register_operand" "")
	(const_int 0))]
  ""
  { fcpu_emit_scc (translit(`$1', `a-z', `A-Z'),operands); DONE; })
')
dnl integer_extruncs(from,to,suff)
define(`int_extr',`(define_insn "extend`'translit(`$1',`A-Z',`a-z')`'translit(`$2',`A-Z',`a-z')2"
  [(set (match_operand:$2 0 "register_operand" "=r")
               (sign_extend:$2 (match_operand:$1 1 "register_operand" "r")))]
   "" "widen.$3 %1,%0")
(define_insn "zero_extend`'translit(`$1',`A-Z',`a-z')`'translit(`$2',`A-Z',`a-z')2"
   [(set (match_operand:$2 0 "register_operand" "=r")
                 (zero_extend:$2 (match_operand:$1 1 "register_operand" "r")))]
   "" "move.$3 %1,%0\t// zero_extend")
')

dnl FP stuff
define(`ifcvt',`(define_insn "float`'translit(`$1',`A-Z',`a-z')`'translit(`$2',`A-Z',`a-z')2"
    [(set (match_operand:$2 0 "register_operand" "=r")
	(float:$2 (match_operand:$1 1 "register_operand" "r")))]
    ""
    "int2$3.%s1 %1,%0")
(define_insn "fix`'translit(`$2',`A-Z',`a-z')`'translit(`$1',`A-Z',`a-z')2"
    [(set (match_operand:$1 0 "register_operand" "=r")
	(fix:$1 (match_operand:$2 1 "register_operand" "r")))]
    ""
    "$3`'2int.%s0 %1,%0")
')

dnl             1        2      3    4   5    6    7     8    9       10
dnl binop_imm8(insn_name,mode,rtlop,asm,type,suff,zext1,zext2,zext_pr,arg)
dnl             1  2    3     4    5   6    7   8
dnl for_modesx(op,ipfx,isfx,rtlop,asm,type,arg,zext,[modes..])
define(`for_modesx',`dnl
	divert(0)indir($1,$2`'translit($9,`A-Z',`a-z')$3,`:$9',$4,$5,$6,$10,`',`',0,`$7')
ifelse($8,0,`',indir($1,`*$2_zext',`',$4,$5,$6,$10,`(match_operator $8 "unary_operator" [',`])',$8,`$7')
)dnl
divert(-1)ifelse($#,10, ,`for_modesx(`$1',$2,$3,$4,$5,$6,`$7',0,shift(shift(shift(shift(shift(shift(shift(shift(shift(shift($@)))))))))))))')')

define(`ZEXT',`ifelse($1,0,`',zero_extend_insn_ok(operands,$1,$2))')
define(`allmodes',`DI,.64,SI,.32,HI,.16,QI,.8')
define(`nonQmodes',`DI,.64,SI,.32,HI,.16')
define(`fpmodes',`DF,.64,SF,.32')
# Standard arithmetic
for_modesx(``binop2'',umin,3,umin,min,inc,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',umax,3,umax,max,inc,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',smin,3,smin,mins,inc,regimm8s_operand,3,allmodes)
for_modesx(``binop2'',smax,3,smax,maxs,inc,regimm8s_operand,3,allmodes)

for_modesx(``unop2'',neg,2,neg,neg,inc,0,2,allmodes)
for_modesx(``unop2'',abs,2,abs,abs,inc,0,2,allmodes)
for_modesx(``notx2'',one_cmpl,2,not,not,logic,0,2,allmodes)
for_modesx(``unop2'',ffs,2,ffs,lsb1,logic,0,2,allmodes)

for_modesx(``lshop'',*ashlmul,3,dummy,dummy,dummy,bitable_operand,3,allmodes)

for_modesx(``binop2'',ashl,3,ashift,shiftl,rot,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',ashr,3,ashiftrt,shiftra,rot,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',lshr,3,lshiftrt,shiftr,rot,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',rotl,3,rotate,rotl,rot,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',rotr,3,rotatert,rotr,rot,regimm8u_operand,3,allmodes)

for_modesx(``binop2'',and,3,and,and,logic,regimm9s_operand,3,allmodes)
for_modesx(``binop2'',ior,3,ior,or,logic,regimm9s_operand,3,allmodes)
for_modesx(``binop2'',xor,3,xor,xor,logic,regimm9s_operand,3,allmodes)

dnl TODO: define zext for these too
for_modes(``binop_bit'',*btst,3,and,btst,logic,0,0,allmodes)
for_modes(``binop_bit'',*bset,3,ior,bset,logic,0,0,allmodes)
for_modes(``binop_bit'',*bchg,3,xor,bchg,logic,0,0,allmodes)
for_modes(``binop_nbit'',*bclr,3,and,bclr,logic,0,0,allmodes)

divert(0)
;; We need to be able to handle many immediates here. We can generate
;; addi,subi,inc and dec depending on imm value. Failing to provide
;; this leads to loading unnecessary constants to registers especially
;; during strength reduce. devik.
divert(-1)
for_modesx(``plusop'',add,3,dummy,dummy,dummy,regimm9x_operand,3,allmodes)
for_modesx(``binop2'',sub,3,minus,sub,add,regimm8u_operand,3,allmodes)

# is F-CPU saturation unsigned ? YES
for_modesx(``binop2'',*addus,3,us_plus,adds,add,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',*subus,3,us_minus,subs,add,regimm8u_operand,3,allmodes)

for_modesx(``binop2'',*gtu,3,gtu,cmpg,inc,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',*leu,3,leu,cmple,inc,regimm8u_operand,3,allmodes)
for_modesx(``binop2'',*gt,3,gt,cmpgs,inc,regimm8s_operand,3,allmodes)
for_modesx(``binop2'',*le,3,le,cmples,inc,regimm8s_operand,3,allmodes)

dnl these need special treatment -MR
for_modesx(``binop_muldiv'',mul,3,mult,mul,mul,regimm8s_operand,3,allmodes)
for_modesx(``binop_muldiv'',div,3,div,div,div,regimm8s_operand,3,allmodes)
for_modesx(``binop_muldiv'',mod,3,mod,rem,div,regimm8s_operand,3,allmodes)
for_modesx(``binop2'',udiv,3,udiv,div,div,register_operand,3,allmodes)
for_modesx(``binop2'',umod,3,umod,rem,div,register_operand,3,allmodes)

dnl FP arithmetic
for_modesx(``binop2'',add,3,plus,fadd,fpu,register_operand,3,fpmodes)
for_modesx(``binop2'',sub,3,minus,fsub,fpu,register_operand,3,fpmodes)
for_modesx(``binop2'',mul,3,mult,fmul,fpu,register_operand,3,fpmodes)
for_modesx(``binop2'',div,3,div,fdiv,fpu,register_operand,3,fpmodes)

divert(0)
conds(eq)
conds(ne)
conds(le)
conds(leu)
conds(lt)
conds(ltu)
conds(gt)
conds(gtu)
conds(ge)
conds(geu)
conds(ordered)
conds(unordered)
int_extr(SI,DI,32)
int_extr(HI,DI,16)
int_extr(QI,DI,8)
int_extr(HI,SI,16)
int_extr(QI,SI,8)
int_extr(QI,HI,8)
ifcvt(QI,SF,f)
ifcvt(HI,SF,f)
ifcvt(SI,SF,f)
ifcvt(DI,SF,f)
ifcvt(QI,DF,d)
ifcvt(HI,DF,d)
ifcvt(SI,DF,d)
ifcvt(DI,DF,d)
