;;- Machine description for GNU compiler, F-CPU, devik@cdi.cz


;;- Instruction patterns.  When multiple patterns apply,
;;- the first one in the file is chosen.
;;-
;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.
;;-
;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

(define_attr "type"
   "other,add,loadcons,move,mul,div,rot,inc,logic,logic2,loadaddr"
     (const_string "other"))
(define_function_unit "adder" 1 0 
 (eq_attr "type" "add") 3 0)
(define_function_unit "loadcons" 1 0
 (eq_attr "type" "loadcons") 1 0)
(define_function_unit "move" 1 0
 (eq_attr "type" "move") 1 0)
(define_function_unit "other" 1 0
 (eq_attr "type" "other") 2 0)
(define_function_unit "mul" 1 0
 (eq_attr "type" "mul") 7 0)
(define_function_unit "div" 1 1
 (eq_attr "type" "div") 40 40)
(define_function_unit "rot" 1 0
 (eq_attr "type" "rot") 2 0)
(define_function_unit "inc" 1 0
 (eq_attr "type" "inc") 2 0)
(define_function_unit "logic" 1 0
 (eq_attr "type" "logic") 2 0)
;; second port of LOGIC unit - implements "combine"
(define_function_unit "logic2" 1 0
 (eq_attr "type" "logic2") 3 0)
;; it is actually 3 but we need to prefetch soon
(define_function_unit "loadaddr" 1 0
 (eq_attr "type" "loadaddr") 5 0)

;; experimental complex insns

(define_insn "*nor_nand"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 3 "binary_operator" [
        (match_operator 4 "unary_operator" [(match_operand 1 "register_operand" "r")])
	(match_operator 5 "unary_operator" [(match_operand 2 "register_operand" "r")])
	]))]
 "GET_MODE(operands[0]) == GET_MODE(operands[1]) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  GET_MODE(operands[0]) == GET_MODE(operands[2]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[4]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[5]) &&
  (GET_CODE(operands[3]) == IOR || GET_CODE(operands[3]) == AND) &&
  GET_CODE(operands[5]) == NOT && GET_CODE(operands[4]) == NOT"
  { 
  return GET_CODE(operands[3]) == IOR ? "nand.%s0 %2,%1,%0":"nor.%s0 %2,%1,%0";
  }
  [(set_attr "type" "logic")])

(define_insn "*orn_andn"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 3 "binary_operator" [
        (match_operator 4 "unary_operator" [(match_operand 1 "register_operand" "r")])
	(match_operand 2 "regimm8_operand" "ri")
	]))]
 "GET_MODE(operands[0]) == GET_MODE(operands[1]) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (GET_MODE(operands[0]) == GET_MODE(operands[2]) || GET_CODE(operands[2]) == CONST_INT) &&
  GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[4]) &&
  (GET_CODE(operands[3]) == IOR || GET_CODE(operands[3]) == AND) &&
  GET_CODE(operands[4]) == NOT"
  { 
  return GET_CODE(operands[3]) == IOR ? "orn%i2.%s0 %2,%1,%0":"andn%i2.%s0 %2,%1,%0";
  }
  [(set_attr "type" "logic")])

(define_insn "*nxor"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 4 "unary_operator" [
       (match_operator 3 "binary_operator" [(match_operand 1 "register_operand" "r")
	(match_operand 2 "regimm8_operand" "ri")])]))]
 "GET_MODE(operands[0]) == GET_MODE(operands[1]) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (GET_MODE(operands[0]) == GET_MODE(operands[2]) || GET_CODE(operands[2]) == CONST_INT) &&
  GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[4]) &&
  (GET_CODE(operands[3]) == XOR) && GET_CODE(operands[4]) == NOT"
  "nxor%i2.%s0 %2,%1,%0"
  [(set_attr "type" "logic")])

;;(define_insn "*muxsi"
;; [(set (subreg:SI (match_operand:DI 0 "register_operand" "=r") 0)
;;     (ior:SI (and:SI 
;;	   (match_operand:SI 1 "register_operand" "r")
;;	   (match_operand:SI 2 "register_operand" "r"))
;;        (and:SI (not:SI (match_dup 1))
;;	     (match_operand 3 "register_operand" "r"))
;;	))]
;; "" "xmux.32 %1,%3,%2,%0"
;;  [(set_attr "type" "logic")])

(define_insn "*mux"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 4 "binary_operator" [
        (match_operator 5 "binary_operator" [
	   (match_operand 1 "register_operand" "r")
	   (match_operand 2 "register_operand" "r")])
        (match_operator 6 "binary_operator" [
	   (match_operator 7 "unary_operator" [
	     (match_operand 3 "register_operand" "r")]) 
	   (match_operand 8 "register_operand" "r")])
	]))]
 "GET_MODE(operands[0]) == GET_MODE(operands[1]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[2]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[4]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[5]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[6]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[7]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[8]) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (REGNO(operands[3]) == REGNO(operands[1]) ||
   REGNO(operands[3]) == REGNO(operands[2])) &&
  GET_CODE(operands[4]) == IOR &&
  GET_CODE(operands[5]) == AND &&
  GET_CODE(operands[7]) == NOT &&
  GET_CODE(operands[6]) == AND"
  {
  if (REGNO(operands[3]) == REGNO(operands[1]))
  	return "mux.%s0 %3,%8,%2,%0";
  else 
	return "mux.%s0 %3,%8,%1,%0";
  }
  [(set_attr "type" "logic")])
(define_insn "*mux2"
 [(set (match_operand 0 "register_operand" "=r")
     (match_operator 4 "binary_operator" [
        (match_operator 5 "binary_operator" [
	  (match_operator 7 "unary_operator" [
	   (match_operand 1 "register_operand" "r")])
	   (match_operand 2 "register_operand" "r")])
        (match_operator 6 "binary_operator" [
	   (match_operand 3 "register_operand" "r")
	   (match_operand 8 "register_operand" "r")])
	]))]
 "GET_MODE(operands[0]) == GET_MODE(operands[1]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[2]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[4]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[5]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[6]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[7]) &&
  GET_MODE(operands[0]) == GET_MODE(operands[8]) &&
  GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
  (REGNO(operands[1]) == REGNO(operands[3]) ||
   REGNO(operands[1]) == REGNO(operands[8])) &&
  GET_CODE(operands[4]) == IOR &&
  GET_CODE(operands[5]) == AND &&
  GET_CODE(operands[7]) == NOT &&
  GET_CODE(operands[6]) == AND"
  {
  if (REGNO(operands[3]) == REGNO(operands[1]))
  	return "mux.%s0 %1,%8,%2,%0";
  else 
	return "mux.%s0 %1,%8,%3,%0";
  }
  [(set_attr "type" "logic")])

;; looping

(define_insn "decrement_and_branch_until_zero"
  [
    (set (pc) (if_then_else
	       (ge (plus:SI (match_operand:SI 0 "register_operand" "+r") (const_int -1))
	       (const_int 0))
        (label_ref (match_operand 1 "target_operand" "r"))
        (pc)))
    (set (match_dup 0) (plus:SI (match_dup 0) (const_int -1)))
    ]
    ""
    "loop_direct %0,%l1")

;;############# Compares
;; copy operands to temp vars
(define_expand "cmpdi"
 [(set (cc0) (compare (match_operand:DI 0 "general_operand" "")
		 (match_operand:DI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })
(define_expand "cmpsi"
 [(set (cc0) (compare (match_operand:SI 0 "general_operand" "")
		 (match_operand:SI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })
(define_expand "cmphi"
 [(set (cc0) (compare (match_operand:HI 0 "general_operand" "")
		 (match_operand:HI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })
(define_expand "cmpqi"
 [(set (cc0) (compare (match_operand:QI 0 "general_operand" "")
		 (match_operand:QI 1 "general_operand" "")))]
 "" { fcpu_compare.op0 = operands[0];
 fcpu_compare.op1 = operands[1];
 DONE; })

(define_expand "movqicc"
  [(set (match_operand:QI 0 "register_operand" "")
	(if_then_else:QI (match_operand 1 "comparison_operator" "")
			 (match_operand:QI 2 "register_operand" "")
			 (match_operand:QI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,QImode))==NULL) FAIL;
  })
(define_expand "movhicc"
  [(set (match_operand:HI 0 "register_operand" "")
	(if_then_else:HI (match_operand 1 "comparison_operator" "")
			 (match_operand:HI 2 "register_operand" "")
			 (match_operand:HI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,HImode))==NULL) FAIL;
  })
(define_expand "movdicc"
  [(set (match_operand:DI 0 "register_operand" "")
	(if_then_else:DI (match_operand 1 "comparison_operator" "")
			 (match_operand:DI 2 "register_operand" "")
			 (match_operand:DI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,DImode))==NULL) FAIL;
  })
(define_expand "movsicc"
  [(set (match_operand:SI 0 "register_operand" "")
	(if_then_else:SI (match_operand 1 "comparison_operator" "")
			 (match_operand:SI 2 "register_operand" "")
			 (match_operand:SI 3 "register_operand" "")))]
  ""
  { if ((operands[1] = fcpu_expand_cmove(operands,SImode))==NULL) FAIL;
  })

;; conditional move
(define_insn "*movcc"
  [(set (match_operand 0 "register_operand" "=r,r")
	(if_then_else (match_operator 4 "comparison_operator" [
			  (match_operand 1 "register_operand" "r,r") 
				(const_int 0)])
		      (match_operand 2 "register_operand" "0,r")
		      (match_operand 3 "register_operand" "r,0")))]
  "(GET_CODE(operands[4]) == NE || GET_CODE(operands[4]) == EQ) &&
    GET_MODE_SIZE(GET_MODE(operands[0])) <= 8 &&
    GET_MODE(operands[0]) == GET_MODE(operands[2]) &&
    GET_MODE(operands[0]) == GET_MODE(operands[3]) &&
    (GET_MODE_SIZE(GET_MODE(operands[1])) <= 8 || GET_MODE(operands[1]) == VOIDmode)"
  "@
  move%C4.%s0 %1,%3,%0
  move%c4.%s0 %1,%2,%0"
  [(set_attr "type" "move")])

;;(define_insn "*condbrn"
;; [(set (pc) (if_then_else (ne (match_operand 0 "register_operand" "r")
;;			 (const_int 0)) 
;;		 (match_operand:DI 1 "general_operand" "")
;;		 (pc)))]
;; ""
;; "jmp_direct_nz %0,%l1")
;; 
;;(define_insn "*condbr"
;; [(set (pc) (if_then_else (eq (match_operand 0 "register_operand" "r")
;;			 (const_int 0)) 
;;		 (match_operand:DI 1 "general_operand" "")
;;		 (pc)))]
;; ""
;; "jmp_direct_z %0,%l1")

;; this VOIDmode cmp is based on assumption that each 
;; insn nullifies all high bits
(define_insn "*condbrni"
 [(set (pc) (if_then_else (ne (match_operand 0 "register_operand" "r")
			 (const_int 0)) 
		 (match_operand:DI 1 "target_operand" "r")
		 (pc)))]
 ""
 "jmpnz %0,%1")
 
(define_insn "*condbri"
 [(set (pc) (if_then_else (eq (match_operand 0 "register_operand" "r")
			 (const_int 0)) 
		 (match_operand:DI 1 "target_operand" "r")
		 (pc)))]
 ""
 "jmpz %0,%1")

;; Truncation
(define_expand "truncdisi2" 
 [(set (match_operand:SI 0 "register_operand" "r")
     (truncate:SI (match_operand:DI 1 "register_operand" "r")))]
 "" "")
(define_expand "truncdihi2" 
 [(set (match_operand:HI 0 "register_operand" "r")
     (truncate:HI (match_operand:DI 1 "register_operand" "r")))]
 "" "")
(define_expand "truncdiqi2" 
 [(set (match_operand:QI 0 "register_operand" "r")
     (truncate:QI (match_operand:DI 1 "register_operand" "r")))]
 "" "")
(define_expand "truncsihi2" 
 [(set (match_operand:HI 0 "register_operand" "r")
     (truncate:HI (match_operand:SI 1 "register_operand" "r")))]
 "" "")
(define_expand "truncsiqi2" 
 [(set (match_operand:QI 0 "register_operand" "r")
     (truncate:QI (match_operand:SI 1 "register_operand" "r")))]
 "" "")
(define_expand "trunchiqi2" 
 [(set (match_operand:QI 0 "register_operand" "r")
     (truncate:HI (match_operand:HI 1 "register_operand" "r")))]
 "" "")

(define_insn "*trunc"
 [(set (match_operand 0 "register_operand" "=r")
     (truncate (match_operand 1 "register_operand" "r")))]
 "" "move.%s0 %1,%0 // trunc %s1 => %s0")


;; ############# Expanded moves; generates intermediates for memory
;; references and generates constant loads too
(define_expand "movqi" 
 [(set (match_operand:QI 0 "nonimmediate_operand" "")
       (match_operand:QI 1 "general_operand" ""))]
 ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (QImode, operands); DONE;}")

(define_expand "movhi" 
 [(set (match_operand:HI 0 "nonimmediate_operand" "")
       (match_operand:HI 1 "general_operand" ""))]
 ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (HImode, operands); DONE;}")

(define_expand "movsi" 
 [(set (match_operand:SI 0 "nonimmediate_operand" "")
       (match_operand:SI 1 "general_operand" ""))]
 ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (SImode, operands); DONE;}")
 
(define_expand "movdi"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  "if (!(reload_completed||reload_in_progress)){
  fcpu_expand_move (DImode, operands); DONE;}")

(define_insn "movcc"
  [(set (match_operand:CC 0 "register_operand" "=r")
	(match_operand:CC 1 "register_operand" "r"))]
  "" "move %1 %0  // CCmode")

;; What about DMOVE ?
;;(define_peephole
;; [(set (match_operand 0 "register_operand" "=r")
;;             (match_operand 1 "register_operand" "r"))
;;    (set (match_operand 2 "register_operand" "=r")
;;             (match_operand 3 "register_operand" "r"))]
;;
;;    ""
;;    "dmove %1,%0,%3,%2")

;; combine two independent moves to parallel move
;; and use dmove insn for it :) THIS IS EXPERIMENTAL
;;(define_peephole2
;; [(set (match_operand 0 "register_operand" "=r")
;;             (match_operand 1 "register_operand" "r"))
;;    (set (match_operand 2 "register_operand" "=r")
;;             (match_operand 3 "register_operand" "r"))]
;;
;;    "GET_MODE(operands[0])==GET_MODE(operands[1]) &&
;;    GET_MODE(operands[2])==GET_MODE(operands[3]) &&
;;    GET_MODE_SIZE(GET_MODE(operands[0]))<=8 &&
;;    GET_MODE_SIZE(GET_MODE(operands[2]))<=8"
;; [(parallel [(set (match_dup 0) (match_dup 1))
;; (set (match_dup 2) (match_dup 3))])]
;;    "PUT_MODE(operands[0],DImode);
;;    PUT_MODE(operands[1],DImode);
;;    PUT_MODE(operands[2],DImode);
;;    PUT_MODE(operands[3],DImode); ")
;;
;;(define_insn "*movdid"
;;  [(set (match_operand:DI 0 "register_operand" "=r")
;;	(match_operand:DI 1 "register_operand" "r"))
;;   (set (match_operand:DI 2 "register_operand" "=r")
;;	(match_operand:DI 3 "register_operand" "r"))
;;  ]
;;  "" "dmove %1,%0,%3,%2")

;;(define_insn "*movqid"
;;  [(set (match_operand:QI 0 "register_operand" "=r")
;;	(match_operand:QI 1 "register_operand" "r"))
;;   (set (match_operand:QI 2 "register_operand" "=r")
;;	(match_operand:QI 3 "register_operand" "r"))
;;  ]
;;  "" "dmove.b %1,%0,%3,%2")
;;(define_insn "*movhid"
;;  [(set (match_operand:HI 0 "register_operand" "=r")
;;	(match_operand:HI 1 "register_operand" "r"))
;;   (set (match_operand:HI 2 "register_operand" "=r")
;;	(match_operand:HI 3 "register_operand" "r"))
;;  ]
;;  "" "dmove.q %1,%0,%3,%2")


;;############# Atomic moves

(define_insn "*movsi"
  [(set (match_operand:SI 0 "regmemzero_operand" "=r,m,r,r,m")
	(match_operand:SI 1 "regmemzero_operand" "r,r,m,i,i"))]
  ""
  "@
  move.32 %1,%0
  store%k0.32 %0,%1
  load%k1.32 %1,%0
  move.32 r0,%0
  store%k0.32 %0,r0")

(define_insn "*movdi"
  [(set (match_operand:DI 0 "regmemzero_operand" "=r,m,a,r,m")
	(match_operand:DI 1 "regmemzero_operand" "r,r,m,i,i"))]
  ""
  "@
  move.64 %1,%0
  store%k0.64 %0,%1
  load%k1.64 %1,%0
  move.64 r0,%0
  store%k0.64 %0,r0")

(define_insn "*movhi"
  [(set (match_operand:HI 0 "regmemzero_operand" "=r,m,r,r,m")
	(match_operand:HI 1 "regmemimm16_operand" "r,r,m,i,O"))]
  ""
  "@
  move.16 %1,%0
  store%k0.16 %0,%1
  load%k1.16 %1,%0
  loadcons.0 %1,%0
  store%k0.16 %0,r0")

(define_insn "*movqi"
  [(set (match_operand:QI 0 "regmemzero_operand" "=r,m,r,r,m")
	(match_operand:QI 1 "regmemimm8_operand" "r,r,m,i,O"))]
  ""
  "@
  move.8 %1,%0
  store%k0.8 %0,%1
  load%k1.8 %1,%0
  loadcons.0 %1,%0
  store%k0.8 %0,r0")

;;############# Constant block inserts (loadcons.N)

(define_insn "*loadcons0si"
 [(set (zero_extract:SI (match_operand:SI 0 "register_operand" "+r")
		 (const_int 16) (const_int 0))
	 (match_operand:SI 1 "immediate_operand" "i"))]
 "" "loadcons.0 %1,%0")
(define_insn "*loadcons1si"
 [(set (zero_extract:SI (match_operand:SI 0 "register_operand" "+r")
		 (const_int 16) (const_int 16))
	 (match_operand:SI 1 "immediate_operand" "i"))]
 "" "loadcons.1 %1,%0")

(define_insn "*loadcons0di"
 [(set (zero_extract:DI (match_operand:DI 0 "register_operand" "+r")
		 (const_int 16) (const_int 0))
	 (match_operand:DI 1 "immediate_operand" "i"))]
 "" "loadcons.0 %1,%0")
(define_insn "*loadcons1di"
 [(set (zero_extract:DI (match_operand:DI 0 "register_operand" "+r")
		 (const_int 16) (const_int 16))
	 (match_operand:DI 1 "immediate_operand" "i"))]
 "" "loadcons.1 %1,%0")

;; TEST TImode
(define_expand "divmodsi4"
  [ (clobber (match_dup 4))
    (parallel [
   (set (subreg:SI (match_dup 4) 0) 
        (div:SI (match_operand:SI 1 "register_operand" "r")
                (match_operand:SI 2 "register_operand" "r")))
   (set (subreg:SI (match_dup 4) 8)
        (mod:SI (match_dup 1) (match_dup 2)))
   ])
   (set (match_operand:SI 0 "register_operand" "=r") 
	(subreg:SI (match_dup 4) 0))
   (set (match_operand:SI 3 "register_operand" "=r") 
	(subreg:SI (match_dup 4) 8))]
  "" {
	operands[4] = gen_reg_rtx(TImode);
})

(define_insn "*divmodsi4"
 [ (set (subreg:SI (match_operand:TI 0 "register_operand" "r") 0)
        (div:SI (match_operand:SI 1 "register_operand" "r")
                (match_operand:SI 2 "register_operand" "r")))
   (set (subreg:SI (match_dup 0) 8)
        (mod:SI (match_dup 1) (match_dup 2)))]
  "" "divrs.32 %2,%1,%0")

;;############# Loop
;;(define_expand "doloop_end"
;; [(use (match_operand 0 "" ""))        ; loop pseudo
;; (use (match_operand 1 "" ""))        ; iterations; zero if unknown
;; (use (match_operand 2 "" ""))        ; max iterations
;; (use (match_operand 3 "" ""))        ; loop level
;; (use (match_operand 4 "" ""))]       ; label
;; ""
;; {
;; emit_jump_insn (gen_doloop_end_internal (operands[4], operands[0],
;;		 operands[0]));
;; DONE;
;; })
;;
;;(define_insn "doloop_end_internal"
;;  [(set (pc)
;;	(if_then_else (ne (match_operand:DI 1 "register_operand" "r")
;;			  (const_int 1))
;;		      (label_ref (match_operand 0 "" ""))
;;		      (pc)))
;;   (set (match_operand:DI 2 "register_operand" "=1")
;;	(plus:DI (match_dup 1)
;;		 (const_int -1)))
;;   (clobber (match_scratch:DI 3 "=X"))]
;;  ""
;;  "loop_direct %l0,%1")


;;############# Bitop constant load
(define_insn "*bitconstdi"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(match_operand:DI 1 "bitable_operand" "M,i"))]
  ""
  "@
  bseti.64 %b1,r0,%0
  bclrni.64 %b1,r0,%0"
  [(set_attr "type" "logic")])

(define_insn "*bitconstsi"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(match_operand:SI 1 "bitable_operand" "M,i"))]
  ""
  "@
  bseti.32 %b1,r0,%0
  bclrni.32 %b1,r0,%0"
  [(set_attr "type" "logic")])

;;############# LABEL_REF constants
(define_insn "*labelcons"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(match_operand:DI 1 "immediate_operand" "i"))]
  "GET_CODE(operands[1])==LABEL_REF"
  "loadaddri %1-.,%0 // maybe it should be loadaddrdi"
  [(set_attr "type" "loadaddr")])

;;############# Fallback constant loading using ASM macro
(define_insn "*bigconstdi"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(match_operand:DI 1 "bigimm_operand" "i"))]
  ""
  "loadcons.64 %1,%0"
  [(set_attr "type" "loadcons")])

(define_insn "*bigconst"
  [(set (match_operand 0 "register_operand" "=r")
	(match_operand 1 "immediate_operand" "i"))]
  ""
  "loadcons.32 %1,%0"
  [(set_attr "type" "loadcons")])

;;(define_insn "*loadconsxhi"
;; [(set (strict_low_part (subreg:HI (match_operand:SI 0 "register_operand" "+r")
;;		 0))
;;	 (match_operand:HI 1 "immediate_operand" "i"))]
;; "" "loadcons.1 %1,%0")
;;(define_split
;; [(set (match_operand:SI 0 "register_operand" "")
;;             (match_operand:SI 1 "immediate_operand" ""))]
;; ""
;; [(set (subreg:HI (match_dup 0) 2) (match_dup 1))
;; (set (strict_low_part (subreg:HI (match_dup 0) 0)) (match_dup 2))]
;;  "operands[2]=GEN_INT(INTVAL(operands[1])&0xffff);
;;   operands[1]=GEN_INT((INTVAL(operands[1])>>16)&0xffff);")
 

(define_insn "jump_internal"
  [(set (pc)
    (match_operand:DI 0 "target_operand" "r"))]
  ""
  "jmp %0")

(define_expand "jump"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  "" {
  if (reload_in_progress || reload_completed) FAIL;
  emit_insn (gen_jump_internal (gen_rtx_LABEL_REF (DImode, operands[0])));
  DONE;
})



;;(define_expand "jump"
;; [(set (match_dup 1) (label_ref (match_operand:QI 0 "" "")))
;;  (set (pc) (match_dup 1))]
;;  ""
;;  "operands[1]=gen_reg_rtx(Pmode);")

;; TODO: how to replace it with indirect jump ??
;;(define_insn "jump"
;; [(set (pc) (label_ref (match_operand 0 "" "")))]
;;  ""
;;  "jmp_direct %l0")
   
(define_insn "indirect_jump"
  [(set (pc) (match_operand:DI 0 "register_operand" "r"))]
  ""
  "jmp %0")

(define_insn "tablejump"
  [ (set (pc) (plus:DI (pc)
	     (sign_extend:DI (match_operand:SI 0 "register_operand" "r"))
	     ))
      (use (label_ref (match_operand 1 "" "")))
      ]
  "" "widen.32 %0,%0\n.LSW%r1:\tloadaddr %0,%0; jmp %0")

;;(define_insn "*tj"
;; [(set (pc) (match_operand:DI 0 "register_operand" "r"))
;;       (use (label_ref (match_operand 1 "" "")))
;; ] "" "jmp %0")
;;
;;(define_insn "get_reladdr"
;; [(set (match_operand:DI 0 "register_operand" "=r,r") 
;;     (plus:DI (pc) (match_operand:DI 1 "nonmemory_operand" "r,i")))]
;; ""
;; "@
;; loadaddr %1,%0
;; loadaddri %1,%0")

;;(define_insn "indirect_jump"
;;  [(set (pc) (match_operand:QI 0 "register_operand" "r"))]
;;  ""
;;  "jmp %0")

(define_expand "prologue"
 [(const_int 1)]
 "" "fcpu_expand_prologue (); DONE;")

(define_expand "epilogue"
 [(const_int 1)]
 "" "fcpu_expand_epilogue (); DONE;")

(define_insn "nop" [(const_int 0)] "" "nop")

(define_expand "call"
  [(call (match_operand:QI 0 "memory_operand" "m") (match_operand:QI 1 "" ""))
  (clobber (reg:DI 63))]
  ""
  "operands[0]=force_reg(Pmode,XEXP(operands[0],0));")

;;(define_insn "return"
;;  [(return)]
;;  "reload_completed && compute_frame_size (get_frame_size (), (long *)0) == 0"
;;  "jmp r63")

(define_insn "return_internal"
  [(return)
   (use (reg:SI 63))]
  ""
  "jmp r63")

(define_insn "*call"
  [(call (match_operand:DI 0 "register_operand" "r")
	 (match_operand:QI 1 "general_operand" "g"))]
  ""
  "jmp %0,ra")

(define_expand "call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:QI 1 "memory_operand" "m")
	      (match_operand:QI 2 "general_operand" "g")))
  (clobber (reg:DI 63))]
  ""
  "operands[1]=force_reg(Pmode,XEXP(operands[1],0));")

(define_insn "*call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:DI 1 "register_operand" "r")
	      (match_operand:QI 2 "general_operand" "g")))]
  ""
  "jmp %1,ra")

(include "fcpu-arith.md")
