/* Definitions of target machine for GNU compiler.  F-CPU version.
   devik@cdi.cz
 */

#include "config.h"
#include "system.h"
#include "rtl.h"
#include "function.h"
#include "output.h"
#include "tree.h"
#include "expr.h"
#include "regs.h"
#include "flags.h"
#include "hard-reg-set.h"
#include "tm_p.h"
#include "target.h"
#include "target-def.h"
#include "insn-config.h"
#include "recog.h"
#include "toplev.h"

extern const char *reg_names[];

static void elxsi_output_function_prologue PARAMS ((FILE *, HOST_WIDE_INT));
static void elxsi_output_function_epilogue PARAMS ((FILE *, HOST_WIDE_INT));
static bool fcpu_cannot_modify_jumps_p PARAMS((void));

#if 0
#undef TARGET_ASM_FUNCTION_PROLOGUE
#define TARGET_ASM_FUNCTION_PROLOGUE elxsi_output_function_prologue
#undef TARGET_ASM_FUNCTION_EPILOGUE
#define TARGET_ASM_FUNCTION_EPILOGUE elxsi_output_function_epilogue
#endif
#undef TARGET_CANNOT_MODIFY_JUMPS_P
#define TARGET_CANNOT_MODIFY_JUMPS_P fcpu_cannot_modify_jumps_p

/* we need scratch register for jumps so no jumps after reload are possible */
static bool
fcpu_cannot_modify_jumps_p ()
{
	  return (reload_in_progress || reload_completed);
}

struct gcc_target targetm = TARGET_INITIALIZER;


/* Generate the assembly code for function entry.  FILE is a stdio
   stream to output the code to.  SIZE is an int: how many units of
   temporary storage to allocate.

   Refer to the array `regs_ever_live' to determine which registers to
   save; `regs_ever_live[I]' is nonzero if register number I is ever
   used in the function.  This function is responsible for knowing
   which registers should not be saved even if used.  */

static void
elxsi_output_function_prologue (file, size)
     FILE *file;
     HOST_WIDE_INT size;
{
  register int regno;
  register int cnt = 0;

  /* the below two lines are a HACK, and should be deleted, but
     for now are very much needed (1.35) */
  if (frame_pointer_needed)
    regs_ever_live[61] = 1, call_used_regs[61] = 0;
  call_used_regs[63] = 0;

  for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)
    if (regs_ever_live[regno] && !call_used_regs[regno])
      cnt += 8;

  for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)
    if (regs_ever_live[regno] && !call_used_regs[regno])
      fprintf (file, "\tstore $-8,r62,%s\n", reg_names[regno]);

  if (frame_pointer_needed)
    fprintf (file, "\taddi $%d,fp,fp\n", (int)(size + cnt));
}

/* returns valid postmodify of addr by offset. Because
   called afted reload it handles case of big offset */
static rtx reload_modifyptr(rtx addr,int offset)
{
    rtx off = GEN_INT(offset);
    
    if (offset < -255 || offset > 255) {
	rtx tmp = gen_rtx_REG(Pmode,1); /* use RV as intermediate */
	emit_move_insn(tmp,off);
	off = tmp;
    }
    return gen_rtx_POST_MODIFY(Pmode,addr,gen_rtx_PLUS(Pmode,addr,off));
}

void fcpu_expand_epilogue()
{
    int regno,mknote = 0;
    int cnt = 0;
    rtx lastsrc = NULL, sp = gen_rtx_REG(Pmode,62);
    int sz = ((get_frame_size() + 3) & ~3);
    
    for (regno = 1; regno < FIRST_PSEUDO_REGISTER; regno++) {
	int rn = regno == 63 ? 61 : regno == 61 ? 63 : regno;
	if (regs_ever_live[rn] && !call_used_regs[rn]) {
	    if (lastsrc) 
		emit_move_insn(lastsrc,gen_rtx_MEM(DImode,
			    gen_rtx_POST_MODIFY(Pmode,sp,
		    	gen_rtx_PLUS(Pmode,sp,GEN_INT(8)))));
	    else 
		emit_move_insn(sp,gen_rtx_PLUS(Pmode,sp,GEN_INT(8)));
	    
	    lastsrc = gen_rtx_REG(DImode,rn);
	}
    }
    if (!lastsrc) {
	lastsrc = gen_rtx_REG(DImode,0); mknote = 1;
    }
    /* deallocate locals here */
    if (sz || !mknote)
	lastsrc = emit_move_insn(lastsrc,gen_rtx_MEM(DImode,
		    reload_modifyptr(sp,sz)));

    if (mknote && sz)
	/* ensure that it will not be optimized away */
	REG_NOTES (lastsrc) = gen_rtx_EXPR_LIST (REG_INC, sp, 0);
    
    emit_jump_insn (gen_return_internal ());
}
        
void fcpu_expand_prologue()
{
    int regno;
    int cnt = 0;
    rtx sp = gen_rtx_REG(Pmode,62);
    int sz = ((get_frame_size() + 3) & ~3);
    
    if (frame_pointer_needed)
	regs_ever_live[61] = 1, call_used_regs[61] = 0;

    /* local variables space */
    if (sz) {
	rtx insn = emit_move_insn(gen_rtx_REG(DImode,0),
		gen_rtx_MEM(DImode,reload_modifyptr(sp,-sz)));
	/* ensure that it will not be optimized away */
	REG_NOTES (insn) = gen_rtx_EXPR_LIST (REG_INC, sp, 0);
    }
    
    /* save all used regs; start with FP */
    call_used_regs[63] = 0;
    for (regno = FIRST_PSEUDO_REGISTER-1; regno > 0; regno--) {
	int rn = regno == 63 ? 61 : regno == 61 ? 63 : regno;
	if (regs_ever_live[rn] && !call_used_regs[rn]) {
	    rtx r = gen_rtx_POST_MODIFY(Pmode,sp,
		    	gen_rtx_PLUS(Pmode,sp,GEN_INT(-8)));
	    
	    emit_move_insn(gen_rtx_MEM(DImode,r),gen_rtx_REG(DImode,rn));
	}
    }
}

/* This function generates the assembly code for function exit.
   Args are as for output_function_prologue ().

   The function epilogue should not depend on the current stack
   pointer!  It should use the frame pointer only.  This is mandatory
   because of alloca; we also take advantage of it to omit stack
   adjustments before returning. */

static void
elxsi_output_function_epilogue (file, size)
     FILE *file;
     HOST_WIDE_INT size;
{
  register int regno;
  register int cnt = 0;

  /* this conditional is ONLY here because there is a BUG;
     EXIT_IGNORE_STACK is ignored itself when the first part of
     the condition is true! (at least in version 1.35) */
  /* the 8*10 is for 64 bits of .r5 - .r14 */
  if (current_function_calls_alloca || size >= (256 - 8 * 10))
    {
      /* use .r4 as a temporary! Ok for now.... */
      fprintf (file, "\tld.64\t.r4,.r14\n");

      for (regno = FIRST_PSEUDO_REGISTER-1; regno >= 0; --regno)
	if (regs_ever_live[regno] && !call_used_regs[regno])
	  cnt += 8;

      for (regno = 0; regno < FIRST_PSEUDO_REGISTER; ++regno)
	if (regs_ever_live[regno] && !call_used_regs[regno])
	  fprintf (file, "\tld.64\t.r%d,[.r14]%d\n", regno,
		   (int)(-((cnt -= 8) + 8) - 4 - size));

      fprintf (file, "\tld.64\t.sp,.r4\n\texit\t0\n");
    }
  else
    {
      for (regno = 0; regno < FIRST_PSEUDO_REGISTER; ++regno)
	if (regs_ever_live[regno] && !call_used_regs[regno])
	  fprintf (file, "\tload $8,r62,%s\n", reg_names[regno]);

      fprintf (file, "\tjmp r63\n");
    }
}

static const char *
fcpu_branch_zero_code (x)
     enum rtx_code x;
{
    switch (x) {
	case EQ: return "z";
	case NE: return "nz";
	default: abort();
    }
}

void
print_operand (file, x, code)
     FILE *file;
     rtx x;
     const char code;
{
    /* print just address register from memory reference */
    if (code == 'r' && GET_CODE (x) == MEM && GET_CODE (XEXP (x, 0)) == REG)	
	fprintf (file, "%s", reg_names[REGNO (XEXP (x, 0))]);
    
    /* label number */
    else if (code == 'r' && GET_CODE (x) == CODE_LABEL)
	fprintf (file, "%d", XINT(x,5));

    /* register size in bits */
    else if (code == 's' && GET_CODE (x) == REG)
	fprintf (file, "%d", GET_MODE_SIZE(GET_MODE(x))*8);
    
    /* prints "i" if x is constant, else nothing (with j, don't do it for 0) */
    else if (code == 'i' || code == 'j') {
	if (GET_CODE (x) == CONST_INT && (x != const0_rtx || code == 'i'))
	    fprintf (file,"i");
    }

    /* prints "r0" if x is const 0 */
    else if (code == 'o' && x == const0_rtx)
	fprintf (file, "r0");

    /* comparison (eq/ne -> z/nz) code of an operator x */
    else if (code == 'c')
	fprintf (file, "%s", fcpu_branch_zero_code(GET_CODE(x)));
    /* comparison (eq/ne -> nz/z) code of an operator x */
    else if (code == 'C')
	fprintf (file, "%s", fcpu_branch_zero_code(reverse_condition(GET_CODE(x))));

    /* register name output */
    else if (GET_CODE (x) == REG)	
	fprintf (file, "%s", reg_names[REGNO (x)]);	

    else if (GET_CODE (x) == MEM) {
	rtx addr = XEXP (x, 0);
	/* output post dec/inc */
	if (GET_CODE(addr) == POST_MODIFY) {
	    int size;
	    rtx plus = XEXP (addr, 1);
	    
	    if (GET_CODE (plus) != PLUS) 
		abort();
	    if (code == 'k') {
		fprintf (file, "i"); return;
	    }
	    addr = XEXP (addr, 0); /* to print it later */
	    if (GET_CODE (XEXP (plus,1)) == CONST_INT) {
		/* const modify */
		size = INTVAL (XEXP (plus,1));
		if (size > 255 || size < -255) 
		    abort();
	    
		fprintf (file, "$%d,", size);
	    } else {
		/* register modify */
		if (!REG_P(XEXP (plus,1))) 
		    abort();
		fprintf (file, "%s,", reg_names[REGNO (XEXP (plus,1))]);
	    }	
	}
	/* see below */
	if (code != 'k')
	    output_address (addr);
    }

    /* output log2 if single bit is one or zero */
    else if (GET_CODE (x) == CONST_INT && code == 'b') {
	int b = exact_log2(INTVAL(x));
	if (b < 0) 
	    b = ffz_big(INTVAL(x)); 
	if (b < 0) 
	    abort();
	fprintf (file, "$%d", b); 
    }	
    else {
	/*if (!CONSTANT_P(x)) abort();*/
	putc ('$', file); 
	output_addr_const (file, x); 
    }
}

void
print_operand_address (file, addr)
     FILE *file;
     register rtx addr;
{
    if (GET_CODE (addr) == POST_INC)
	fprintf (file, "$%d", reg_names[REGNO (addr)]);
    
    /* only one indirection level supported */
    if (GET_CODE (addr) != REG)
	abort();

    /* [%s] would be probably nicer */
    fprintf (file, "%s", reg_names[REGNO (addr)]); 
}

/* test for memory addressed by register */
int
indmem_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
    	enum rtx_code c;
	if (!memory_operand (op, mode))
	    return 0;
	c = GET_CODE(XEXP(op,0));
	return (c == REG || c == POST_MODIFY);
}

int
regzero_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)==0));
}
int
imm8_operand (op, mode)
	rtx op;
	enum machine_mode mode ATTRIBUTE_UNUSED;
{
	return (CONSTANT_P(op) && INTVAL(op)>=-128 && INTVAL(op)<=255);
}
int
regimm8_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) ||
			(CONSTANT_P(op) && INTVAL(op)>=-128 && INTVAL(op)<=255));
}
int
regmemzero_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)==0) ||
		    indmem_operand(op, mode));
}
int
regmemimm16_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)>=-32768 && INTVAL(op)<=0xffff) ||
		    indmem_operand(op, mode));
}
int
regmemimm8_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || 
			(CONSTANT_P(op) && INTVAL(op)>=-128 && INTVAL(op)<=0xff) ||
		    indmem_operand(op, mode));
}

int
binary_operator (op, mode)
    rtx op;
    enum machine_mode mode;
{
    return ((mode == VOIDmode || GET_MODE (op) == mode)
	    && GET_RTX_CLASS (GET_CODE (op)) == 'c');
}
int
unary_operator (op, mode)
    rtx op;
    enum machine_mode mode;
{
    return ((mode == VOIDmode || GET_MODE (op) == mode)
	    && GET_RTX_CLASS (GET_CODE (op)) == '1');
}


/* loadcons immediate not handled be fcpu_expand_move */
int bigimm_operand (op, mode)
	rtx op;
	enum machine_mode mode ATTRIBUTE_UNUSED;
{
	return (CONSTANT_P(op) && (INTVAL(op)<0 || INTVAL(op)>0xffff));
}
/* reg or constants for PLUS: -255 ... 255 */
int regimm9_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	return (register_operand (op, mode) || (GET_CODE(op) == CONST_INT && 
		(INTVAL(op) >= -255 && INTVAL(op) <= 255)));
}

int fcpu_is_label(rtx op);
int fcpu_is_label(op)
	rtx op;
{
	switch (GET_CODE (op)) {
		case LABEL_REF:
		case SYMBOL_REF:
			return 1;
		default: break;
	}
	return 0;
}

/* register or label_refs and symbol_refs before reload */
int target_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
	if (mode != DImode)
		return 0;

	if ((GET_MODE (op) == DImode || GET_MODE (op) == VOIDmode)
			&& fcpu_is_label (op))
	      return ! reload_completed;

        return register_operand (op, mode);
}
/* constant which can be loaded by bitop (has one 1 or one 0 bit inside) */
int bitable_operand (op, mode)
	rtx op;
	enum machine_mode mode;
{
    	int log;
	if (GET_CODE(op) != CONST_INT) 
	    return 0;
    	log = exact_log2(INTVAL(op) & GET_MODE_MASK(mode));
	if (log < 0) 
	    log = exact_log2((~INTVAL(op)) & GET_MODE_MASK(mode));
	return log >= 0;
}
int
ffz_big (x)
	unsigned HOST_WIDE_INT x;
{
    	int log = 0;
    	while (x & 1) {
	    	x >>= 1;
		log++;
	}
	return (unsigned)log >= sizeof(x)*8 ? -1 : log;
}

void                   
fcpu_expand_move (mode, ops)
	enum machine_mode mode;
	rtx ops[];           
{
	/* can't copy directly to MEM pointed by NONREG */
	if (GET_CODE (ops[0]) == MEM && GET_CODE(XEXP(ops[0],0)) != REG)
		ops[0] = gen_rtx_MEM(mode,force_reg(Pmode,XEXP(ops[0],0)));
	
	/* also can't copy from MEM pointed by NONREG */
	if (GET_CODE (ops[1]) == MEM && GET_CODE(XEXP(ops[1],0)) != REG)
		ops[1] = gen_rtx_MEM(mode,force_reg(Pmode,XEXP(ops[1],0)));

	/* generate big nonzero constant */
	if (GET_CODE (ops[1]) == CONST_INT && GET_CODE (ops[0]) == REG && 
		GET_MODE_SIZE(mode) > 2 && INTVAL(ops[1]) != 0 && 0) {
		long long x = INTVAL(ops[1]);
		if (x >= 0 && x <= 0xffff) {
			if (GET_MODE_SIZE(mode) > 2) /* clear reg optionally */
				emit_insn(gen_rtx_SET(mode,ops[0],GEN_INT(0)));
			ops[0] = gen_rtx_ZERO_EXTRACT(mode,ops[0],GEN_INT(16),GEN_INT(0));
		} else {
			/* hmm how to emit ?? */
			/* let's ignore it and handle in .md */
		}
	}
	
	/* if the first were MEM and second NONREG then use other register */
	if (GET_CODE (ops[0]) == MEM && GET_CODE (ops[1]) != REG)
		ops[1] = force_reg(mode,ops[1]);

	/* ok can generate direct move */
	emit_insn(gen_rtx_SET(VOIDmode,ops[0],ops[1]));
}

struct fcpu_compare fcpu_compare;

/* generates and returns code to compare fcpu_compare operands
   in relation "code"; comparison generates value ot the same
   mode as operands are which is nonzero resp. zero if the
   condition is met (reversed if set to 0 resp 1). 
   Note that we detect special cases (cmp with 0) here. */
static rtx
fcpu_gen_compare (code,reversed)
	enum rtx_code code;
	int *reversed;
{
	enum machine_mode opmode;
	rtx op0 = fcpu_compare.op0, op1 = fcpu_compare.op1, tem;
	HOST_WIDE_INT wi;
	
	opmode = GET_MODE(op0);
	if (GET_MODE_CLASS(opmode) != MODE_INT ||
		(opmode != GET_MODE(op1) && GET_MODE(op1) != VOIDmode)) 
	    abort(); /* don't support FP yet */
	
	/* if second is constant, offset it */
	wi = -(GET_MODE_MASK(opmode)>>1);
	if (GET_CODE(op1) == CONST_INT
		&& (INTVAL(op1) > 0 || (code != GEU && code != LTU))
	 	&& (INTVAL(op1) >= wi || (code != GE && code != LT)) ) {
	    int off = 1;
	    switch (code) {
		case GE:  code = GT; break;
		case LT:  code = LE; break;
		case GEU: code = GTU; break;
		case LTU: code = LEU; break;
		default:  off = 0; break;
	    }
	    if (off) op1 = GEN_INT(INTVAL(op1)-1);
	}
	/* we have no LT and GE in F-CPU, swap the operands if in regs */
	*reversed = 0;
	switch (code) {
	    case GE: case LT: case GEU: case LTU: 
		tem = op1; op1 = op0; op0 = tem;
		code = swap_condition(code);
		break;
	    case EQ:
		code = NE, *reversed = 1;
	    case LE:  case GT:  case LEU:  case GTU: case NE:
		break; /* ok */
	    default:  
		abort();
	}

	/* we need ops in registers; combiner will make immediates again */
	if (!regzero_operand (op0, opmode))
		op0 = force_reg (opmode, op0);
	if (!regzero_operand (op1, opmode))
		op1 = force_reg (opmode, op1);
	
	/* compare and branch against 0 directly. TODO: use 63th bit too */
	if (op1 == const0_rtx && code == NE)
	    	return op0;

	/* treat NE as XOR since now */
	return gen_rtx_fmt_ee (code == NE ? XOR : code, 
		    opmode, op0, op1);
}

/* like above but the value must comply with STORE_FLAG_VALUE;
   resmode is mode wanted for the result; we also want result in QImode */
void
fcpu_emit_scc (code,ops)
	enum rtx_code code;
	rtx ops[];
{
	enum machine_mode opmode;
	int reversed;
	rtx tem,tem2;

	/* generate the value in "native" mode */
	tem = fcpu_gen_compare(code,&reversed);
	opmode = GET_MODE(tem);

	/* not needed anymore */
	memset (&fcpu_compare, 0, sizeof (fcpu_compare));

	/* let's normalize the value - it is ok unless
	   XOR was used - then compare it with 0 */
	if (code == EQ || code == NE) {
	    	/* we need tem in register */
	    	if (!regzero_operand (tem, opmode))
			tem = force_reg (opmode, tem);
	    	tem = gen_rtx_fmt_ee (reversed ? LEU : GTU,
			opmode, tem, CONST0_RTX (opmode));
	}
	if (GET_MODE(ops[0]) != QImode) abort();

	if (opmode != GET_MODE(ops[0])) {
	    emit_move_insn(tem2 = gen_reg_rtx(opmode),tem);
	    tem = gen_rtx_TRUNCATE(QImode,tem2);
	}
		
	emit_move_insn(ops[0],tem);
}

rtx 
fcpu_expand_cmove (ops, mode)
	rtx ops[];
	enum machine_mode mode ATTRIBUTE_UNUSED;
{
    	rtx scc;
	enum machine_mode opmode;
	int reversed;
	enum rtx_code cmp = GET_CODE(ops[1]);

	/* test for case with one branch only */
	if (REG_P(ops[2]) && REGNO(ops[0]) == REGNO(ops[2]))
	    	;
	else if (!REG_P(ops[3]) || REGNO(ops[0]) != REGNO(ops[3]))
	    	return NULL; /* can't handle full if-then-else */
	
	opmode = GET_MODE(fcpu_compare.op0);
	if (GET_MODE_CLASS(opmode) != MODE_INT ||
		(opmode != GET_MODE(fcpu_compare.op1) && 
		GET_MODE(fcpu_compare.op1) != VOIDmode)) 
	    abort(); /* don't support FP yet */

    	/* simple case: NE/EQ register comparison with 0 in any mode;
	   this doesn't need new pseudos */
    	if ((cmp == NE || cmp == EQ)
		&& fcpu_compare.op1 == const0_rtx
		&& GET_CODE(fcpu_compare.op0) == REG) {
	    	return gen_rtx(cmp,VOIDmode,
			fcpu_compare.op0,fcpu_compare.op1);
	}
	/* above was the only case if we can't create new imtermediate (it
	   would be needed to hold result of compare */
	if (no_new_pseudos) return NULL;

	/* store the raw condition value */
	scc = fcpu_gen_compare(cmp,&reversed);

	/* not needed anymore */
	memset (&fcpu_compare, 0, sizeof (fcpu_compare));

	/* we need scc in register */
	if (!regzero_operand (scc, opmode))
		scc = force_reg (opmode, scc);

	/* can directly generate cmove with it (no normalization needed) */
	return gen_rtx_fmt_ee (reversed ? EQ : NE,
		opmode, scc, CONST0_RTX (opmode));
}

rtx
fcpu_emit_conditional_branch (code)
	enum rtx_code code;
{
	enum machine_mode opmode;
	int reversed;
	rtx tem;

	/* generate the compare value */
	tem = fcpu_gen_compare(code,&reversed);
	opmode = GET_MODE(tem);

	/* not needed anymore */
	memset (&fcpu_compare, 0, sizeof (fcpu_compare));

	/* we need tem in register */
	if (!regzero_operand (tem, opmode))
		tem = force_reg (opmode, tem);

	/* Return the branch comparison.  */
	return gen_rtx_fmt_ee (reversed ? EQ : NE, 
		opmode, tem, CONST0_RTX (opmode));
}
