; assemble with nasm -o e.fromfs -l e.lst -f bin e.nasm

; Directory entry flags
FROMFS_FLAG_VALID   equ 1  ; entry is used (later used for long file names)
FROMFS_FLAG_EXEC    equ 2  ; data can be executed
; FROMFS_FLAG_COMPR   equ 4  ; data block is compressed
; FROMFS_FLAG_DIR     equ 8  ; data block is actually an embedded directory
; FROMFS_FLAG_LINK    equ 16 ; symbolic link

; header
db "FROMFS0L"  ; little endian signature
dd END_FROMS   ; size
dd nb_entries  ; number of entries

start_entries equ $
; 1st entry
db 10                ; number of chars
db "runmefirst"      ; the actual name
db 0,0,0,0,0,0,0,0,0 ; zero padding
dd FROMFS_FLAG_VALID ; flags
dd size_block_1      ; block size
dd index_block_1     ; block index

; 2nd entry
db 9                 ; number of chars
db "runmenext"       ; the actual name
db 0,0,0,0,0,0,0,0,0,0 ; zero padding
dd FROMFS_FLAG_VALID ; flags
dd size_block_2      ; block size
dd index_block_2     ; block index

; 3rd entry : a "hard link" to block 2
db 8                 ; number of chars
db "hardlink"        ; the actual name
db 0,0,0,0,0,0,0,0,0,0,0 ; zero padding
dd FROMFS_FLAG_VALID ; flags
dd size_block_2      ; block size
dd index_block_2     ; block index

end_entries equ $
nb_entries equ (end_entries - start_entries)>>5

; block 1 :
index_block_1 equ $
; insert stuff here :
db "if you can read that, cool !",0dh, 0ah
size_block_1 equ $ - index_block_1
align 8 ; inserts NOPs, but i don't know how to make something else...

; block 2 :
index_block_2 equ $
db "if you can read that, too, you're in a good day !",0dh, 0ah
size_block_2 equ $ - index_block_2
align 8

; the very end :
END_FROMS equ $
