/*
 * mkstemp.c - a reimplementation of mkstemp(3).
 * Copyright (C) 1998 - 2001 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef lint
static const char rcsid[] = "@(#) $Id: mkstemp.c,v 1.1 2002/12/27 18:17:36 michael Exp $";
#endif /* lint */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <sys/stat.h>
#include <errno.h>
#include <mkstemp.h>

#ifndef MAXTRIES
#define MAXTRIES 10000
#endif /* MAXTRIES */

int
mkstemp(char *tmpl) {
	static unsigned long rnd = 0UL;
	int tries = 0;
	int fd, i, j;
	size_t len;
	unsigned long k;

	len = strlen(tmpl);
	if (len < 6 || strcmp(tmpl + len - 6, "XXXXXX")) {
		errno = EINVAL;
		return -1;
	}
	do {
		if (rnd == 0L) {
			rnd = (unsigned long)time(NULL) ^ ((unsigned long)getpid() << 16);
		}
		for (i = 1, k = rnd; i <= 6; i++) {
			j = k % 36; k /= 36;
			tmpl[len - i] = j + (j < 10 ? '0' : 'A' - 10);
		}
		fd = open(tmpl, O_RDWR | O_CREAT | O_EXCL, S_IRUSR | S_IWUSR);
		rnd += (unsigned long)++tries;
	}
	while (fd == -1 && errno == EEXIST && tries < MAXTRIES);
	return fd;
}
