/*
 * malloc.c - safe(r) memory allocation.
 * Copyright (C) 1998 - 2001 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

#include <common.h>
#include <stdio.h>
#include <elftools.h>

#ifndef lint
static const char rcsid[] = "@(#) $Id: malloc.c,v 1.1 2002/12/27 18:17:36 michael Exp $";
#endif /* lint */

static void
oom(void) {
	error("out of memory");
	exit(1);
}

void*
xmalloc(size_t n) {
	void *p;

	if (!(p = malloc(n ? n : 1))) {
		oom();
	}
	return p;
}

void*
xrealloc(void *p, size_t n) {
	if (p == NULL) {
		return xmalloc(n);
	}
	if (!(p = realloc(p, n ? n : 1))) {
		oom();
	}
	return p;
}

void
xfree(void *p) {
	if (p) {
		free(p);
	}
}

char*
xstrdup(const char *s) {
	char *p;

	if (!s) {
		s = "";
	}
	p = xmalloc(strlen(s) + 1);
	strcpy(p, s);
	return p;
}
