/*
 * findscn.c - find a section in an ELF file.
 * Copyright (C) 1995 - 2002 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

#include <common.h>
#include <elftools.h>

#ifndef lint
static const char rcsid[] = "@(#) $Id: findscn.c,v 1.2 2002/12/30 16:04:51 michael Exp $";
#endif /* lint */

Elf_Scn*
et_find_section_by_name(Elf *elf, const char *name, Elf_Scn *scn) {
	GElf_Shdr sh;
	GElf_Addr shstrndx;
	char *str;

	if (!elf || !name || !*name) {
		return NULL;
	}
	if (!(shstrndx = et_get_shstrndx(elf))) {
		return NULL;
	}
	elf_errno();
	while (gelf_getshdr(scn = elf_nextscn(elf, scn), &sh)) {
		if (sh.sh_type != SHT_NULL) {
			str = elf_strptr(elf, shstrndx, sh.sh_name);
			if (!str) {
				break;
			}
			if (strcmp(str, name) == 0) {
				return scn;
			}
		}
	}
	return NULL;
}

Elf_Scn*
et_find_section_by_type(Elf *elf, GElf_Word type, Elf_Scn *scn) {
	GElf_Shdr sh;

	if (!elf || type == SHT_NULL) {
		return NULL;
	}
	elf_errno();
	while ((scn = elf_nextscn(elf, scn))) {
		if (!gelf_getshdr(scn, &sh)) {
			return NULL;
		}
		if (sh.sh_type == type) {
			return scn;
		}
	}
	return NULL;
}
