/*
 * elftools.h - public header file for ELF tools utility library.
 * Copyright (C) 1995 - 2002 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* @(#) $Id: elftools.h,v 1.2 2002/12/30 16:04:51 michael Exp $ */

#ifndef _ELFTOOLS_H
#define _ELFTOOLS_H

#include <gelf.h>

extern Elf *et_delete_section(Elf *__old, Elf *__new, Elf_Scn *__section);
extern Elf *et_delete_sections(Elf *__old, Elf *__new, Elf_Scn **__sections, size_t __num);
extern Elf *et_copy(Elf *__old, Elf *__new);
extern int et_scnxlate(Elf *__elf, int *__tbl, size_t __num);

extern int et_layout(Elf *__elf);
extern GElf_Off et_layout_fixed(Elf *__elf);

extern Elf_Scn *et_find_section_by_name(Elf *__elf, const char *__name, Elf_Scn *__scn);
extern Elf_Scn *et_find_section_by_type(Elf *__elf, GElf_Word __type, Elf_Scn *__scn);

extern GElf_Addr et_get_shstrndx(Elf *__elf);
extern int et_set_shstrndx(Elf *__elf, GElf_Addr __shstrndx);
extern GElf_Addr et_get_shnum(Elf *__elf);

extern Elf_Scn *et_append_section(Elf *__elf, const char *__name, unsigned __type, size_t __pos);

typedef int (*pfunc_t)(const char *__name, Elf *__elf, int __outfd);
extern int et_modify_file(const char *__name, pfunc_t __func, int bak);
extern int et_read_file(const char *__name, pfunc_t __func);

extern void *xmalloc(size_t __size);
extern void *xrealloc(void *__ptr, size_t __size);
extern void xfree(void *__ptr);
extern char *xstrdup(const char *__str);

extern int xwrite(int __fd, const void *__buf, size_t __len);

extern void setprogname(const char *__newname);
extern void warn(const char *__msg, ...);
extern void error(const char *__msg, ...);
extern void fatal(const char *__msg, ...);
extern void file_warn(const char *__fn, const char *__msg, ...);
extern void file_error(const char *__fn, const char *__msg, ...);
extern void file_fatal(const char *__fn, const char *__msg, ...);

extern size_t et_build_string_table(Elf_Data *__data, const char *__string);

typedef struct archive_descriptor ardesc_t;
extern ardesc_t *ar_create(void);
extern size_t ar_add_fname(ardesc_t *ap, const char *name);
extern size_t ar_add_bytes(ardesc_t *ap, const void *data, size_t len);
extern size_t ar_add_header(ardesc_t *ap, const Elf_Arhdr *ah);
extern void ar_add_symbol(ardesc_t *ap, const char *name, size_t off);
extern void ar_align_bytes(ardesc_t *ap);
extern int ar_add_elf(ardesc_t *ap, Elf *elf, Elf_Arhdr ah);
extern int ar_add_file(ardesc_t *ap, const char *mname, const char *fname);
extern int ar_write(ardesc_t *ap, int fd);
extern int ar_update_archive(ardesc_t *ap, const char *arch, int bak);
extern void ar_destroy(ardesc_t *ap);

void show_version(const char *name);

#endif /* _ELFTOOLS_H */
