/*
 * common.h - common include file for ELF tools.
 * Copyright (C) 1995 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* @(#) $Id: common.h,v 1.6 2003/01/29 03:38:51 michael Exp $ */

#ifndef _COMMON_H
#define _COMMON_H

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
# include <stdarg.h>
# if !HAVE_STPCPY
extern char *stpcpy(char*, const char*);
# endif
#else
extern char *malloc(), *realloc(), *strcpy(), *strrchr(), *strcat();
extern char *stpcpy(), *strerror(), *strchr();
extern int strlen(), strcmp(), strncmp(), atoi();
extern void free(), bcopy(), *memset(), qsort();
extern void exit(), abort();
# if !HAVE_MEMCPY
#  define memcpy(d,s,n) bcopy((s),(d),(n))
# endif
#endif

#if HAVE_UNISTD_H
# include <unistd.h>
#else
extern int read(), write(), link(), unlink(), chown(), fchown();
extern int getpid();
#endif

#if HAVE_MKSTEMP == 0
# include <mkstemp.h>
#endif

#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#else
extern int chmod(), fchmod();
extern int stat(), fstat(), lstat();
extern int umask();
#endif

#if HAVE_FCNTL_H
# include <fcntl.h>
#else
extern int open(), creat(), close();
#endif
#ifndef O_RDONLY
# define O_RDONLY   0
# define O_WRONLY   1
# define O_RDWR	    2
#endif

#if HAVE_GETOPT_H
# include <getopt.h>
#else
extern int getopt(), optind;
extern char *optarg;
#endif

#if HAVE_ERRNO_H
# include <errno.h>
#else
extern int errno;
#endif

#if HAVE_TIME_H
#include <time.h>
#else
extern long time();
#endif

/*
 * Missing pieces
 */
#ifndef SHN_XINDEX
#define SHN_XINDEX	0xffff
#endif

#endif /* _COMMON_H */
