/*
 * missing.h -- add missing ELF definitions
 * Copyright (C) 2000 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* @(#) $Id: missing.h,v 1.4 2003/02/09 00:34:12 michael Exp $ */

#ifndef STN_UNDEF
#define STN_UNDEF 0
#endif

#ifndef SHN_LOOS
#define SHN_LOOS	0xff20
#endif
#ifndef SHN_HIOS
#define SHN_HIOS	0xff3f
#endif
#ifndef SHN_XINDEX
#define SHN_XINDEX	0xffff
#endif

#ifndef SHT_SYMTAB_SHNDX
#define SHT_SYMTAB_SHNDX	18
#endif
#ifndef SHT_LOOS
#define SHT_LOOS			0x60000000
#endif
#ifndef SHT_HIOS
#define SHT_HIOS			0x6fffffff
#endif

#if !defined(ELF32_R_SYM) || !defined(ELF32_R_TYPE) || !defined(ELF32_R_INFO)
# undef ELF32_R_SYM
# undef ELF32_R_TYPE
# undef ELF32_R_INFO
# define ELF32_R_SYM(i)		((i)>>8)
# define ELF32_R_TYPE(i)	((unsigned char)(i))
# define ELF32_R_INFO(s,t)	(((s)<<8)+(unsigned char)(t))
#endif /* !defined(...) */

#if !defined(ELF64_R_SYM) || !defined(ELF64_R_TYPE) || !defined(ELF64_R_INFO)
# undef ELF64_R_SYM
# undef ELF64_R_TYPE
# undef ELF64_R_INFO
# define ELF64_R_SYM(i)		((Elf64_Xword)(i)>>32)
# define ELF64_R_TYPE(i)	((i)&0xffffffffL)
# define ELF64_R_INFO(s,t)	(((Elf64_Xword)(s)<<32)+((t)&0xffffffffL))
#endif /* !defined(...) */

#if !defined(ELF32_ST_BIND) || !defined(ELF32_ST_TYPE) || !defined(ELF32_ST_INFO)
# undef ELF32_ST_BIND
# undef ELF32_ST_TYPE
# undef ELF32_ST_INFO
# define ELF32_ST_BIND(i)	((i)>>4)
# define ELF32_ST_TYPE(i)	((i)&0xf)
# define ELF32_ST_INFO(b,t)	(((b)<<4)+((t)&0xf))
#endif /* !defined(...) */

#if !defined(ELF64_ST_BIND) || !defined(ELF64_ST_TYPE) || !defined(ELF64_ST_INFO)
# undef ELF64_ST_BIND
# undef ELF64_ST_TYPE
# undef ELF64_ST_INFO
# define ELF64_ST_BIND(i)	((i)>>4)
# define ELF64_ST_TYPE(i)	((i)&0xf)
# define ELF64_ST_INFO(b,t)	(((b)<<4)+((t)&0xf))
#endif /* !defined(...) */

