/*
 * ldstrs.c -- string handling for ld(1)
 * Copyright (C) 2000 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

static const char rcsid[] = "@(#) $Id: ldstrs.c,v 1.3 2003/02/07 00:25:11 michael Exp $";

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gelf.h>
#include <assert.h>

#include <ld/ld.h>
#include <ld/ldmisc.h>

#define COMPACT_STRING_TABLES	1
#define COMPACT_STRING_TABLES_EVEN_MORE 0

size_t
ld_add_string(Elf_Data *data, const char *str) {
	const size_t blocksize = 1024;
	size_t len;
	size_t off;
	size_t l;

	assert(data);
	if (!str) {
		data->d_buf = xmalloc(blocksize);
		*(char*)data->d_buf = '\0';
		data->d_size = 1;
		data->d_align = 1;
		data->d_type = ELF_T_BYTE;
		data->d_version = EV_CURRENT;
		return 0;
	}
	if (!*str) {
		return 0;
	}
	len = strlen(str) + 1;
#if COMPACT_STRING_TABLES
	for (off = 1; off < data->d_size; off += l) {
		l = strlen((char*)data->d_buf + off) + 1;
#if COMPACT_STRING_TABLES_EVEN_MORE
		if (l >= len && strcmp(str, (char*)data->d_buf + off + l - len) == 0) {
			debug("compacting strings `%s' and `%s'",
				  str, (char*)data->d_buf + off);
			return off + l - len;
		}
#else
		if (l == len && strcmp(str, (char*)data->d_buf + off) == 0) {
			debug("compacting string `%s'", str);
			return off;
		}
#endif
	}
#endif
	off = data->d_size;
	l = off + len + blocksize - 1;
	if ((off + blocksize - 1) / blocksize < l / blocksize) {
		data->d_buf = xrealloc(data->d_buf, l - l % blocksize);
	}
	strcpy((char*)data->d_buf + off, str);
	data->d_size = off + len;
	return off;
}
