/*
 * elf_FCPU.h -- ELF definitions for F-CPU processors
 * Copyright (C) 2000 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* @(#) $Id: elf_FCPU.h,v 1.4 2003/01/27 05:46:42 michael Exp $ */

#ifndef _ELF_FCPU_H
#define _ELF_FCPU_H

/* Interim value for F-CPU architecture (NOT official) */
#define EM_FCPU		0xFC0	/* of course, the pun is intended :-) */

/*
 * F-CPU relocation types
 * Note that we use explicit addends!
 */
#define R_FCPU_NONE      0
#define R_FCPU_PC17      1  /* (S + A - P) & 0x1ffff          | loadaddri symbol */
#define R_FCPU_8         2  /* S + A                          | .byte     symbol   */
#define R_FCPU_PC8       3  /* S + A - P                      | .byte     symbol-. */
#define R_FCPU_LE_16     4  /* S + A                          | .le_short symbol   */
#define R_FCPU_LE_PC16   5  /* S + A - P                      | .le_short symbol-. */
#define R_FCPU_BE_16     6  /* S + A                          | .be_short symbol   */
#define R_FCPU_BE_PC16   7  /* S + A - P                      | .be_short symbol-. */
#define R_FCPU_LE_32     8  /* S + A                          | .le_int   symbol   */
#define R_FCPU_LE_PC32   9  /* S + A - P                      | .le_int   symbol-. */
#define R_FCPU_BE_32    10  /* S + A                          | .be_int   symbol   */
#define R_FCPU_BE_PC32  11  /* S + A - P                      | .be_int   symbol-. */
#define R_FCPU_LE_64    12  /* S + A                          | .le_long  symbol   */
#define R_FCPU_LE_PC64  13  /* S + A - P                      | .le_long  symbol-. */
#define R_FCPU_BE_64    14  /* S + A                          | .be_long  symbol   */
#define R_FCPU_BE_PC64  15  /* S + A - P                      | .be_long  symbol-. */
#define R_FCPU_U_16     16  /* ((S + A) >>  0) & 0xffff       | loadcons[x].0 symbol   */
#define R_FCPU_U_PC16   17  /* ((S + A - P) >>  0) & 0xffff   | loadcons[x].0 symbol-. */
#define R_FCPU_U_32     18  /* ((S + A) >> 16) & 0xffff       | loadcons[x].1 symbol   */
#define R_FCPU_U_PC32   19  /* ((S + A - P) >> 16) & 0xffff   | loadcons[x].1 symbol-. */
#define R_FCPU_U_48     20  /* ((S + A) >> 32) & 0xffff       | loadcons[x].2 symbol   */
#define R_FCPU_U_PC48   21  /* ((S + A - P) >> 32) & 0xffff   | loadcons[x].2 symbol-. */
#define R_FCPU_U_64     22  /* ((S + A) >> 48) & 0xffff       | loadcons[x].3 symbol   */
#define R_FCPU_U_PC64   23  /* ((S + A - P) >> 48) & 0xffff   | loadcons[x].3 symbol-. */
#define R_FCPU_NUM      24  /* so far */

#endif /* _ELF_FCPU_H */
