/*
 * eatypes.h -- ELF Assembler Definitions
 * Copyright (C) 2001 - 2003 Michael Riepe <michael@stud.uni-hannover.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* @(#) $Id: eatypes.h,v 1.8 2003/01/09 02:24:36 michael Exp $ */

#ifndef _EATYPES_H
#define _EATYPES_H

typedef unsigned long long word_t;	/* largest unsigned integer we have */
typedef signed long long sword_t;	/* largest signed integer we have */

typedef union expr expr_t;
typedef struct sym sym_t;
typedef struct scn scn_t;
typedef struct macro macro_t;
typedef struct token token_t;

extern unsigned long current_line;
extern unsigned long lineno;
extern int yylex(void);		/* most skeleton files seem to lack this */

extern void suspend_scanner(void);

extern char *unescape(const char *str, size_t *len);

extern void push_input_file(const char *name, FILE *fp);
extern void set_input_file(const char *name, FILE *fp);

/* Macros (disabled)
extern void push_tokens(token_t *tokens, size_t cnt, token_t **args, size_t nargs, int release);
extern void pop_tokens(void);
extern token_t *collect(int term, const char **argv, size_t argc, int tok);
extern macro_t* define_macro(const char *name);
extern void macro_param(macro_t *mac, const char *name);
extern void complete_macro(macro_t *mac);
extern void invoke_macro(const char *name, int token);
extern void delete_macro(const char *name);
*/

extern void *palloc(size_t size);
extern void pfreeall(void);

extern void *xrealloc(void *p, size_t size);
extern void xfree(void *p);
#define xmalloc(size)	(xrealloc(NULL, (size)))
#define xstrdup(str)	(strcpy(xmalloc(strlen(str)+1), (str)))

extern void warn(const char *fmt, ...);
extern void error(const char *fmt, ...);
extern void fatal(const char *fmt, ...);	/* does not return */
extern void yyerror(const char *msg);
extern int errors, warnings;

#endif /* _EATYPES_H */
