/*
 * xio.c - I/O procedures.
 * Copyright (C) 1995 - 2001 Michael Riepe <michael@stud.uni-hannover.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA
 */

#include <common.h>
#include <elftools.h>
#include <errno.h>

#ifndef lint
static const char rcsid[] = "@(#) $Id: xio.c,v 1.1 2002/12/27 18:17:37 michael Exp $";
#endif /* lint */

int
xwrite(int fd, const void *buf, size_t len) {
	size_t written = 0, n;

	while (written < len) {
		n = write(fd, (char*)buf + written, len - written);
		if (n != (size_t)-1) {
			written += n;
		}
		else if (errno != EINTR) {
			error("write: %s", strerror(errno));
			return 1;
		}
	}
	return 0;
}
